/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import org.violetmoon.quark.content.world.module.FairyRingsModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.BlockUtils;
import org.violetmoon.zeta.world.generator.Generator;

public class FairyRingGenerator
extends Generator {
    public FairyRingGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos corner) {
        int x = corner.m_123341_() + rand.m_188503_(16);
        int z = corner.m_123343_() + rand.m_188503_(16);
        BlockPos center = new BlockPos(x, 128, z);
        Holder biome = this.getBiome((LevelAccessor)worldIn, center, false);
        double chance = 0.0;
        if (biome.m_203656_(BiomeTags.f_207611_)) {
            chance = FairyRingsModule.forestChance;
        } else if (biome.m_203656_(Tags.Biomes.IS_PLAINS)) {
            chance = FairyRingsModule.plainsChance;
        }
        if (rand.m_188500_() < chance) {
            BlockPos pos = center;
            BlockState state = worldIn.m_8055_(pos);
            while (BlockUtils.isGlassBased((BlockState)state, (BlockGetter)worldIn, (BlockPos)corner) && pos.m_123342_() > 30) {
                pos = pos.m_7495_();
                state = worldIn.m_8055_(pos);
            }
            if (BlockUtils.isGlassBased((BlockState)state, (BlockGetter)worldIn, (BlockPos)corner)) {
                FairyRingGenerator.spawnFairyRing((WorldGenLevel)worldIn, generator, pos.m_7495_(), (Holder<Biome>)biome, rand);
            }
        }
    }

    public static void spawnFairyRing(WorldGenLevel world, ChunkGenerator generator, BlockPos pos, Holder<Biome> biome, RandomSource rand) {
        List features = ((Biome)biome.m_203334_()).m_47536_().m_47815_();
        Holder holder = features.isEmpty() ? null : ((RandomPatchConfiguration)((ConfiguredFeature)features.get(0)).f_65378_()).f_191304_();
        BlockState flowerState = holder == null ? Blocks.f_50120_.m_49966_() : null;
        for (int i = -3; i <= 3; ++i) {
            block1: for (int j = -3; j <= 3; ++j) {
                BlockPos fpos;
                int k;
                float dist = i * i + j * j;
                if (dist < 7.0f || dist > 10.0f) {
                    for (k = 6; k > -3; --k) {
                        fpos = pos.m_7918_(i, k, j);
                        BlockState state = world.m_8055_(fpos);
                        if (!state.m_204336_(BlockTags.f_13037_)) continue;
                        world.m_7731_(fpos, Blocks.f_50016_.m_49966_(), 2);
                        continue block1;
                    }
                    continue;
                }
                for (k = 5; k > -4; --k) {
                    fpos = pos.m_7918_(i, k, j);
                    BlockPos fposUp = fpos.m_7494_();
                    BlockState state = world.m_8055_(fpos);
                    if (!(state.m_60734_() instanceof AbstractGlassBlock) || !world.m_46859_(fposUp)) continue;
                    if (flowerState == null) {
                        ((PlacedFeature)holder.m_203334_()).m_226357_(world, generator, rand, fposUp);
                        flowerState = world.m_8055_(fposUp);
                        continue block1;
                    }
                    world.m_7731_(fposUp, flowerState, 2);
                    continue block1;
                }
            }
        }
        BlockPos orePos = pos.m_6625_(rand.m_188503_(10) + 25);
        BlockState stoneState = world.m_8055_(orePos);
        for (int down = 0; !stoneState.m_204336_(Tags.Blocks.STONE) && down < 10; ++down) {
            orePos = orePos.m_7495_();
            stoneState = world.m_8055_(orePos);
        }
        if (stoneState.m_204336_(Tags.Blocks.STONE)) {
            BlockState ore = FairyRingsModule.ores.get(rand.m_188503_(FairyRingsModule.ores.size()));
            world.m_7731_(orePos, ore, 2);
            for (Direction face : Direction.values()) {
                if (!rand.m_188499_()) continue;
                world.m_7731_(orePos.m_121945_(face), ore, 2);
            }
        }
    }
}

