/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.recipe.MCRecipe;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCRecipeTransferHandler
implements IRecipeTransferHandler<class_1714, class_3955> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<class_1714, class_3955> handler;

    public MCRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        IRecipeTransferInfo basicRecipeTransferInfo = handlerHelper.createBasicRecipeTransferInfo(class_1714.class, class_3917.field_17333, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler(basicRecipeTransferInfo);
    }

    @NotNull
    public Class<? extends class_1714> getContainerClass() {
        return this.handler.getContainerClass();
    }

    @NotNull
    public Optional<class_3917<class_1714>> getMenuType() {
        return this.handler.getMenuType();
    }

    @NotNull
    public RecipeType<class_3955> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull class_1714 container, @NotNull class_3955 recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            class_5250 tooltipMessage = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)tooltipMessage);
        }
        List<IRecipeSlotView> missingItems = this.getMissingItems(container, recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT));
        if (recipe instanceof MCRecipe && !missingItems.isEmpty()) {
            class_5250 tooltipMessage = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.missing");
            if (!this.missingTieredUpMiningCard(container, missingItems).isEmpty()) {
                tooltipMessage.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"jei.ultimine_addition.tooltip.missing_card"));
            }
            return this.handlerHelper.createUserErrorForMissingSlots((class_2561)tooltipMessage, missingItems);
        }
        return this.handler.transferRecipe((class_1703)container, (Object)recipe, recipeSlotsView, player, maxTransfer, doTransfer);
    }

    private List<IRecipeSlotView> getMissingItems(@NotNull class_1714 container, List<IRecipeSlotView> slotViews) {
        return slotViews.stream().filter(slotView -> !slotView.isEmpty()).filter(slotView -> slotView.getItemStacks().filter(stack -> {
            class_1792 patt3983$temp = stack.method_7909();
            if (patt3983$temp instanceof MiningSkillCardItem) {
                MiningSkillCardItem item = (MiningSkillCardItem)patt3983$temp;
                MiningSkillCardData data = item.getData((class_1799)stack);
                List<class_1799> inv = container.method_7602().stream().filter(stack1 -> stack1.method_31574(stack.method_7909()) && item.getData((class_1799)stack1).getTier().equals((Object)data.getTier())).toList();
                return !inv.isEmpty();
            }
            List<class_1799> inv = container.method_7602().stream().filter(stack1 -> stack1.method_31574(stack.method_7909())).toList();
            return !inv.isEmpty();
        }).toList().isEmpty()).collect(Collectors.toList());
    }

    private List<IRecipeSlotView> missingTieredUpMiningCard(@NotNull class_1714 container, List<IRecipeSlotView> slotViews) {
        return slotViews.stream().filter(slotView -> !slotView.isEmpty()).filter(slotView -> {
            ArrayList list = new ArrayList(slotView.getItemStacks().toList());
            list.removeIf(stack -> {
                MiningSkillCardData data = new MiningSkillCardData().loadData((class_1799)stack);
                List<class_1799> inv = container.method_7602().stream().filter(stack1 -> stack1.method_31574(stack.method_7909()) && !new MiningSkillCardData().loadData((class_1799)stack1).getTier().equals((Object)data.getTier())).toList();
                return inv.isEmpty();
            });
            return !list.isEmpty();
        }).collect(Collectors.toList());
    }
}

