/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.ixdarklord.ultimine_addition.integration.jei.ItemStorageDataRecipeCategory;
import net.ixdarklord.ultimine_addition.integration.jei.MCRecipeTransferHandler;
import net.ixdarklord.ultimine_addition.integration.jei.MiningSkillsCardInterpreter;
import net.ixdarklord.ultimine_addition.integration.jei.PenInterpreter;
import net.ixdarklord.ultimine_addition.integration.jei.SkillsRecordScreenHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    @NotNull
    public class_2960 getPluginUid() {
        return UltimineAddition.getLocation("jei_integration");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModItems.PEN, (IIngredientSubtypeInterpreter)new PenInterpreter());
        MiningSkillsCardInterpreter.init(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new SkillsRecordScreenHandler());
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemStorageDataRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(ItemStorageDataRecipeCategory.RECIPE_TYPE, ItemStorageDataRecipeCategory.getItemStorageDataRecipes());
        List<class_1799> cards = Stream.of(ModItems.MINING_SKILL_CARD_PICKAXE, ModItems.MINING_SKILL_CARD_AXE, ModItems.MINING_SKILL_CARD_SHOVEL, ModItems.MINING_SKILL_CARD_HOE).map(item -> (MiningSkillCardItem)item).map(item -> {
            class_1799 stack = item.method_7854();
            item.getData(stack).setTier(MiningSkillCardItem.Tier.Mastered).saveData(stack);
            return stack;
        }).toList();
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return;
        }
        registration.addItemStackInfo(cards, new class_2561[]{class_2561.method_43471((String)"jei.ultimine_addition.info.cards.grade_up")});
        registration.addItemStackInfo(ModItems.MINING_SKILL_CARD_EMPTY.method_7854(), new class_2561[]{class_2561.method_43469((String)"jei.ultimine_addition.info.cards.obtain", (Object[])new Object[]{ConfigHandler.COMMON.CARD_TRADE_LEVEL.get()})});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        ItemStorageDataRecipeCategory.getCatalysts().forEach(stack -> registration.addRecipeCatalyst(stack, new RecipeType[]{ItemStorageDataRecipeCategory.RECIPE_TYPE}));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MCRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }
}

