/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.ixdarklord.coolcat_lib.util.MouseHelper;
import net.ixdarklord.coolcat_lib.util.ScreenUtils;
import net.ixdarklord.ultimine_addition.common.recipe.ItemStorageDataRecipe;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.DataIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

public class ItemStorageDataRecipeCategory
implements IRecipeCategory<ItemStorageDataRecipe> {
    public static final class_2960 TEXTURES = UltimineAddition.getGuiTexture("item_storage_data_recipe_jei", "png");
    public static final RecipeType<ItemStorageDataRecipe> RECIPE_TYPE = RecipeType.create((String)"ultimine_addition", (String)ItemStorageDataRecipe.Serializer.NAME.method_12832(), ItemStorageDataRecipe.class);
    private final IGuiHelper helper;
    private final IDrawable background;
    private final ITickTimer timer;
    private IDrawable icon;
    private class_2561 title;

    public ItemStorageDataRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURES, 0, 0, 128, 41);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)class_1802.field_8542));
        this.title = class_2561.method_43470((String)"Not Assigned!");
        this.timer = helper.createTickTimer(60, 380, false);
    }

    @NotNull
    public static List<class_1799> getCatalysts() {
        class_1863 rm = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        ArrayList<ItemStorageDataRecipe> recipes = new ArrayList<ItemStorageDataRecipe>(rm.method_30027(class_3956.field_17545).stream().filter(recipe -> recipe instanceof ItemStorageDataRecipe).map(recipe -> (ItemStorageDataRecipe)((Object)recipe)).toList());
        return recipes.stream().map(ItemStorageDataRecipe::getResultItem).toList();
    }

    public static List<ItemStorageDataRecipe> getItemStorageDataRecipes() {
        class_1863 rm = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        List<ItemStorageDataRecipe> storageDataRecipes = rm.method_30027(class_3956.field_17545).stream().filter(recipe -> recipe instanceof ItemStorageDataRecipe).map(recipe -> (ItemStorageDataRecipe)((Object)recipe)).toList();
        ArrayList<ItemStorageDataRecipe> result = new ArrayList<ItemStorageDataRecipe>();
        storageDataRecipes.forEach(recipe -> recipe.getDataIngredients().forEach(i -> {
            class_2371 items = class_2371.method_10211();
            items.add((Object)DataIngredient.of(i.getAmount(), i.getItems()));
            result.add(new ItemStorageDataRecipe(recipe.method_8114(), recipe.method_8112(), recipe.getCategory(), recipe.getResultItem(), recipe.getStorageName(), (class_2371<DataIngredient>)items));
        }));
        return result;
    }

    @NotNull
    public RecipeType<ItemStorageDataRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ItemStorageDataRecipe recipe, @NotNull IFocusGroup focuses) {
        if (this.icon != this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)class_1802.field_8465.method_7854())) {
            this.icon = this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)class_1802.field_8465.method_7854());
            this.title = class_2561.method_43471((String)String.format("jei.ultimine_addition.category.item_storage.%s", Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)recipe.getResultItem().method_7909())).method_12832()));
        }
        List items = DataIngredient.toNormal(recipe.getDataIngredients()).stream().map(class_1856::method_8105).flatMap(Arrays::stream).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 5).addItemStack(recipe.getResultItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 103, 5).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, items);
    }

    @NotNull
    public List<class_2561> getTooltipStrings(ItemStorageDataRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int value = ((IRecipeSlotView)recipeSlotsView.getSlotViews().get(1)).getDisplayedItemStack().orElse(class_1799.field_8037).method_7948().method_10550("amount");
        class_5250 component = class_2561.method_43469((String)String.format("jei.ultimine_addition.recipe.item_storage.%s", recipe.getStorageName()), (Object[])new Object[]{value});
        if (component.getString().length() >= 27 && MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)3, (int)28, (int)121, (int)12)) {
            return List.of(component);
        }
        return Collections.emptyList();
    }

    public void draw(@NotNull ItemStorageDataRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22904(45.0, 12.0 + Math.cos((float)this.timer.getValue() / 20.0f), 100.0);
        poseStack.method_46416(8.0f, 8.0f, 0.0f);
        poseStack.method_22905(1.0f, -1.0f, 1.0f);
        poseStack.method_22905(16.0f, 16.0f, 16.0f);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(30.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(1.0f));
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_776 dispatcher = class_310.method_1551().method_1541();
        dispatcher.method_3353(class_2246.field_9980.method_9564(), poseStack, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444);
        bufferSource.method_22993();
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22904(0.0, Math.sin((float)this.timer.getValue() / 20.0f), 120.0);
        RenderSystem.setShader(class_757::method_34542);
        guiGraphics.method_25290(TEXTURES, 69, 14, 0.0f, 42.0f, 12, 12, 256, 256);
        poseStack.method_22909();
        poseStack.method_22903();
        class_327 font = class_310.method_1551().field_1772;
        int value = ((IRecipeSlotView)recipeSlotsView.getSlotViews().get(1)).getDisplayedItemStack().orElse(class_1799.field_8037).method_7948().method_10550("amount");
        class_2561 component = ScreenUtils.limitComponent((class_2561)class_2561.method_43469((String)String.format("jei.ultimine_addition.recipe.item_storage.%s", recipe.getStorageName()), (Object[])new Object[]{value}), (int)27);
        guiGraphics.method_27535(font, component, 5, 30, Color.WHITE.getRGB());
        poseStack.method_22909();
    }
}

