/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.DataIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStorageDataRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private String storageName;
    private final List<DataIngredient> ingredients = new ArrayList<DataIngredient>();
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    @Nullable
    private String group;

    private ItemStorageDataRecipeBuilder(class_7800 category, class_1935 result, int count) {
        this.category = category;
        this.result = result.method_8389();
        this.count = count;
    }

    public static ItemStorageDataRecipeBuilder create(class_7800 category, class_1935 item) {
        return new ItemStorageDataRecipeBuilder(category, item, 1);
    }

    public static ItemStorageDataRecipeBuilder create(class_7800 category, class_1935 item, int count) {
        return new ItemStorageDataRecipeBuilder(category, item, count);
    }

    public ItemStorageDataRecipeBuilder storage(String name, int size) {
        this.storageName = name;
        return this;
    }

    public ItemStorageDataRecipeBuilder requires(class_6862<class_1792> tag, int amount) {
        return this.requires(DataIngredient.of(tag, amount));
    }

    public ItemStorageDataRecipeBuilder requires(class_1935 item) {
        return this.requires(item, 1);
    }

    public ItemStorageDataRecipeBuilder requires(class_1935 item, int amount) {
        this.requires(DataIngredient.of(amount, item));
        return this;
    }

    public ItemStorageDataRecipeBuilder requires(DataIngredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ItemStorageDataRecipeBuilder requires(DataIngredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    @NotNull
    public ItemStorageDataRecipeBuilder unlockedBy(@NotNull String key, @NotNull class_184 criterionTriggerInstance) {
        this.advancement.method_709(key, criterionTriggerInstance);
        return this;
    }

    @NotNull
    public ItemStorageDataRecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @NotNull
    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> consumer, @NotNull class_2960 actionLocation) {
        class_2960 recipeId = new class_2960(actionLocation.method_12836(), Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)this.result)).method_12832() + "_" + actionLocation.method_12832());
        this.ensureValid(recipeId);
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        consumer.accept((class_2444)new Result(recipeId, this.result, this.count, this.storageName, this.group == null ? "" : this.group, ItemStorageDataRecipeBuilder.method_46202((class_7800)this.category), this.ingredients, this.advancement, recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private void ensureValid(class_2960 p_126208_) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126208_);
        }
    }

    public static class Result
    extends class_7798.class_7799 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String storageName;
        private final String group;
        private final List<DataIngredient> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 id, class_1792 result, int count, String storageName, String group, class_7710 category, List<DataIngredient> ingredients, class_161.class_162 advancement, class_2960 advancementId) {
            super(category);
            this.id = id;
            this.result = result;
            this.count = count;
            this.storageName = storageName;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(@NotNull JsonObject json) {
            super.method_10416(json);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (DataIngredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.toJson());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)this.result)).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            if (this.storageName != null) {
                jsonobject.addProperty("storage_name", this.storageName);
            }
            json.add("result", (JsonElement)jsonobject);
        }

        @NotNull
        public class_1865<?> method_17800() {
            return (class_1865)Registration.ITEM_DATA_STORAGE_RECIPE_SERIALIZER.get();
        }

        @NotNull
        public class_2960 method_10417() {
            return this.id;
        }

        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

