/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.particle;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_2400;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public abstract class ParticleProvider
implements class_2405 {
    private final class_7784.class_7489 pathProvider;
    private final Map<String, List<class_2960>> data = new TreeMap<String, List<class_2960>>();

    protected abstract void addParticles();

    public ParticleProvider(class_7784 output) {
        this.pathProvider = output.method_45973(class_7784.class_7490.field_39368, "particles");
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        this.clear();
        this.addParticles();
        if (this.data.isEmpty()) {
            throw new IllegalStateException("The structure data is empty!");
        }
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<String, List<class_2960>> particle : this.data.entrySet()) {
            JsonObject JSONProperties = new JsonObject();
            JsonArray array = new JsonArray();
            for (class_2960 entry : particle.getValue()) {
                array.add(entry.toString());
            }
            JSONProperties.add("textures", (JsonElement)array);
            futures[i++] = class_2405.method_10320((class_7403)cache, (JsonElement)JSONProperties, (Path)this.pathProvider.method_44108(UltimineAddition.getLocation(particle.getKey()), "json"));
        }
        return CompletableFuture.allOf(futures);
    }

    public void add(class_2400 particle, class_2960 ... texture) {
        String particleName = Objects.requireNonNull(Registration.PARTICLE_TYPES.getRegistrar().getId((Object)particle)).method_12832();
        if (this.data.containsKey(particleName)) {
            throw new IllegalStateException("Duplicate particle " + particleName);
        }
        this.data.put(particleName, Arrays.stream(texture).toList());
    }

    private void clear() {
        this.data.clear();
    }

    @NotNull
    public final String method_10321() {
        return "Particles";
    }
}

