/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.model;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.ixdarklord.coolcat_lib.util.JsonUtils;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_793;
import org.jetbrains.annotations.NotNull;

public abstract class ItemModelProvider
extends FabricModelProvider {
    private final List<ModelBuilder> builders = new ArrayList<ModelBuilder>();

    public ItemModelProvider(FabricDataOutput output) {
        super(output);
        this.registerModels();
    }

    protected abstract void registerModels();

    public void generateItemModels(class_4915 generator) {
        this.builders.forEach(builder -> this.create(builder.getItemModelLocation(), class_4944.method_25895((class_2960)builder.getItemTextureLocation()), (ModelBuilder)builder, generator.field_22844));
    }

    protected void create(class_2960 location, class_4944 textureMapping, ModelBuilder builder, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        Map map = builder.template.method_25850(textureMapping);
        biConsumer.accept(location, () -> {
            boolean isCustomRenderer;
            JsonObject jsonObject = new JsonObject();
            builder.template.field_22901.ifPresent(resourceLocation -> jsonObject.addProperty("parent", resourceLocation.toString()));
            if (builder.guiLight != null) {
                jsonObject.addProperty("gui_light", builder.guiLight.toString().toLowerCase());
            }
            JsonUtils.deepMerge((JsonObject)builder.toJson(), (JsonObject)jsonObject);
            boolean bl = isCustomRenderer = builder.template.field_22901.isPresent() && ((class_2960)builder.template.field_22901.get()).toString().contains("builtin/entity");
            if (!map.isEmpty() && !isCustomRenderer) {
                JsonObject jsonObject2 = new JsonObject();
                map.forEach((textureSlot, resourceLocation) -> jsonObject2.addProperty(textureSlot.method_25912(), resourceLocation.toString()));
                jsonObject.add("textures", (JsonElement)jsonObject2);
            }
            return jsonObject;
        });
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
    }

    protected ModelBuilder simpleItem(class_1792 item) {
        return this.simpleItem(Registration.ITEMS.getRegistrar().getId((Object)item), null);
    }

    protected ModelBuilder simpleItem(class_1792 item, String string) {
        return this.simpleItem(Registration.ITEMS.getRegistrar().getId((Object)item), string);
    }

    protected ModelBuilder simpleItem(class_2960 location, String string) {
        ModelBuilder builder = new ModelBuilder(location, string, class_4943.field_22938);
        this.builders.add(builder);
        return builder;
    }

    protected ModelBuilder handheldItem(class_1792 item) {
        return this.handheldItem(Registration.ITEMS.getRegistrar().getId((Object)item), null);
    }

    protected ModelBuilder handheldItem(class_2960 location, String string) {
        ModelBuilder builder = new ModelBuilder(location, string, class_4943.field_22939);
        this.builders.add(builder);
        return builder;
    }

    protected ModelBuilder specialRendererItem(class_1792 item) {
        return this.specialRendererItem(Registration.ITEMS.getRegistrar().getId((Object)item), null);
    }

    protected ModelBuilder specialRendererItem(class_2960 location) {
        return this.specialRendererItem(location, null);
    }

    protected ModelBuilder specialRendererItem(class_2960 location, String string) {
        class_4942 template = new class_4942(Optional.of(new class_2960("minecraft", "builtin/entity")), Optional.empty(), new class_4945[]{class_4945.field_23006});
        ModelBuilder builder = new ModelBuilder(location, string, template);
        this.builders.add(builder);
        return builder;
    }

    @NotNull
    public final String method_10321() {
        return "Item Models";
    }

    protected static class ModelBuilder {
        private final class_2960 id;
        private final String string;
        private final class_4942 template;
        private class_793.class_4751 guiLight;
        private boolean isAddingStringToFileName;
        private final List<OverrideBuilder> overrides = new ArrayList<OverrideBuilder>();

        public ModelBuilder(class_2960 id, String string, class_4942 template) {
            this.id = id;
            this.string = string;
            this.template = template;
        }

        public class_2960 getItemModelLocation() {
            return new class_2960(this.id.method_12836(), "item/" + this.id.method_12832() + (this.string != null ? (this.isAddingStringToFileName ? this.string : "") : ""));
        }

        public class_2960 getItemTextureLocation() {
            return new class_2960(this.id.method_12836(), "item/" + this.id.method_12832() + (this.string != null ? this.string : ""));
        }

        public ModelBuilder guiLight(class_793.class_4751 guiLight) {
            this.guiLight = guiLight;
            return this;
        }

        public ModelBuilder addStringToFileName() {
            this.isAddingStringToFileName = true;
            return this;
        }

        public OverrideBuilder override() {
            OverrideBuilder ret = new OverrideBuilder();
            this.overrides.add(ret);
            return ret;
        }

        public OverrideBuilder override(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.overrides.size(), (String)"override");
            return this.overrides.get(index);
        }

        public JsonObject toJson() {
            JsonObject root = new JsonObject();
            if (!this.overrides.isEmpty()) {
                JsonArray overridesJson = new JsonArray();
                this.overrides.stream().map(OverrideBuilder::toJson).forEach(arg_0 -> ((JsonArray)overridesJson).add(arg_0));
                root.add("overrides", (JsonElement)overridesJson);
            }
            return root;
        }

        protected class OverrideBuilder {
            protected final Map<class_2960, Float> predicates = new LinkedHashMap<class_2960, Float>();
            protected class_2960 model;

            protected OverrideBuilder() {
            }

            public OverrideBuilder predicate(class_2960 location, float value) {
                this.predicates.put(location, Float.valueOf(value));
                return this;
            }

            public OverrideBuilder model(class_2960 location) {
                this.model = location;
                return this;
            }

            public ModelBuilder end() {
                return ModelBuilder.this;
            }

            JsonObject toJson() {
                JsonObject ret = new JsonObject();
                JsonObject predicatesJson = new JsonObject();
                this.predicates.forEach((key, val) -> predicatesJson.addProperty(key.toString(), (Number)val));
                ret.add("predicate", (JsonElement)predicatesJson);
                ret.addProperty("model", this.model.toString());
                return ret;
            }
        }
    }
}

