/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.language.builder;

import java.util.HashMap;
import java.util.Map;
import net.ixdarklord.ultimine_addition.client.handler.KeyHandler;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_304;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageBuilder {
    public static LanguageBuilder INSTANCE = new LanguageBuilder();
    private final Map<Object, String> translations = new HashMap<Object, String>();

    public LanguageBuilder() {
        this.add("itemGroup", "tab", "Ultimine Addition");
        this.add((class_1792)Registration.MINER_CERTIFICATE.get(), "Miner Certificate");
        this.add((class_1792)Registration.SKILLS_RECORD.get(), "Skills Record");
        this.add((class_1792)Registration.INK_CHAMBER.get(), "Ink Chamber");
        this.add((class_1792)Registration.PEN.get(), "Pen");
        this.add((class_1792)Registration.CARD_BLUEPRINT.get(), "Card Blueprint");
        this.add((class_1792)Registration.MINING_SKILL_CARD_EMPTY.get(), "Mining Skill Card: Empty");
        this.add((class_1792)Registration.MINING_SKILL_CARD_PICKAXE.get(), "Mining Skill Card: Pickaxe");
        this.add((class_1792)Registration.MINING_SKILL_CARD_AXE.get(), "Mining Skill Card: Axe");
        this.add((class_1792)Registration.MINING_SKILL_CARD_SHOVEL.get(), "Mining Skill Card: Shovel");
        this.add((class_1792)Registration.MINING_SKILL_CARD_HOE.get(), "Mining Skill Card: Hoe");
        this.addPotion(Registration.KNOWLEDGE_POTION.getId().method_12832(), "Knowledge", null);
        this.addPotion(Registration.MINE_GO_JUICE_PICKAXE_POTION.getId().method_12832(), "Mine-Go%t: Rock Roulette", "Juice");
        this.addPotion(Registration.MINE_GO_JUICE_AXE_POTION.getId().method_12832(), "Mine-Go%t: Lumberjack Limbo", "Juice");
        this.addPotion(Registration.MINE_GO_JUICE_SHOVEL_POTION.getId().method_12832(), "Mine-Go%t: Worm Whispers", "Juice");
        this.addPotion(Registration.MINE_GO_JUICE_HOE_POTION.getId().method_12832(), "Mine-Go%t: Soil Serenade", "Juice");
        this.add((class_1291)Registration.MINE_GO_JUICE_PICKAXE.get(), "Mine-Go Juice: Rock Roulette");
        this.add((class_1291)Registration.MINE_GO_JUICE_AXE.get(), "Mine-Go Juice: Lumberjack Limbo");
        this.add((class_1291)Registration.MINE_GO_JUICE_SHOVEL.get(), "Mine-Go Juice: Worm Whispers");
        this.add((class_1291)Registration.MINE_GO_JUICE_HOE.get(), "Mine-Go Juice: Soil Serenade");
        this.add("jei", "info.cards.obtain", "You can obtain this item from a level %s toolsmith villager.");
        this.add("jei", "info.cards.grade_up", "You can obtain the Mastered tier by accomplishing challenges using the Skills Record.");
        this.add("jei", "tooltip.missing_card", "or Tiered up Card");
        this.add("jei", "category.item_storage.pen", "Refill Pen");
        this.add("jei", "recipe.item_storage.ink_chamber", "Ink Amount: %s+");
        this.addCurios("skills_record", "Skills Record");
        this.addTrinkets("hand.skills_record", "Skills Record");
        this.add("tooltip", "legacy_mode.disabled_item", "This item has been Disabled by Legacy Mode.");
        this.add("tooltip", "certificate.info", "Interact with this parchment to obtain the ultimine ability permanently!");
        this.add("tooltip", "certificate.legacy.info", "Obtain this knowledge to develop your mining skill!");
        this.add("tooltip", "certificate.legacy.sealed", "Sealed");
        this.add("tooltip", "certificate.legacy.opened", "Opened");
        this.add("tooltip", "certificate.legacy.quest.congrats", "You made it! You've destroyed %s ores.");
        this.add("tooltip", "certificate.legacy.quest.info", "To unseal the the scroll, Mine %s Ores!");
        this.add("tooltip", "certificate.legacy.quest", "Destroyed Ores: %s");
        this.add("tooltip", "skills_record.info", "A tool needed for upgrading mining skills card.");
        this.add("tooltip", "skills_record.contents", "Contents:");
        this.add("tooltip", "skills_record.press.left_click", "Press Left Click Mouse to cycle through blocks.");
        this.add("tooltip", "skill_card.component", "You can use this item to craft any other skill card type.");
        this.add("tooltip", "skill_card.potion_point", "Potion Points: %s");
        this.add("tooltip", "skill_card.tier", "Tier: %s");
        this.add("tooltip", "skill_card.tier.unlearned", "Unlearned");
        this.add("tooltip", "skill_card.tier.novice", "Novice");
        this.add("tooltip", "skill_card.tier.apprentice", "Apprentice");
        this.add("tooltip", "skill_card.tier.adept", "Adept");
        this.add("tooltip", "skill_card.tier.mastered", "Mastered");
        this.add("tooltip", "skill_card.info.empty", "A mining card that can record your mining actions and skills. It can be Useful!");
        this.add("tooltip", "skill_card.info", "You have to put it in the Skills Record to discover the challenges given to you.");
        this.add("tooltip", "pen.info", "It's a required tool for the Skills Record.");
        this.add("tooltip", "pen.ink_chamber", "Ink Chamber: %s");
        this.add("gui", "color.default", "Default");
        this.add("gui", "color.red", "Red");
        this.add("gui", "color.orange", "Orange");
        this.add("gui", "color.yellow", "Yellow");
        this.add("gui", "color.green", "Green");
        this.add("gui", "color.blue", "Blue");
        this.add("gui", "color.indigo", "Indigo");
        this.add("gui", "color.violet", "Violet");
        this.add("gui", "skills_record.configuration", "Configuration");
        this.add("gui", "skills_record.option.soon", "Coming Soon...");
        this.add("gui", "skills_record.option.bg_color", "Background Color");
        this.add("gui", "skills_record.option.animations", "Animations");
        this.add("gui", "skills_record.option.progression_bar", "Progression Bar");
        this.add("gui", "skills_record.option.hold_keybind", "Hold %s");
        this.add("gui", "skills_record.option.panel_pos", "Challenges Panel Position");
        this.add("gui", "skills_record.option.panel_pos.disabled", "Disabled");
        this.add("gui", "skills_record.option.panel_pos.top_left", "Top Left");
        this.add("gui", "skills_record.option.panel_pos.top", "Top");
        this.add("gui", "skills_record.option.panel_pos.top_right", "Top Right");
        this.add("gui", "skills_record.option.panel_pos.left", "Left");
        this.add("gui", "skills_record.option.panel_pos.right", "Right");
        this.add("gui", "skills_record.option.panel_pos.bottom_left", "Bottom Left");
        this.add("gui", "skills_record.option.panel_pos.bottom_right", "Bottom Right");
        this.add("gui", "skills_record.option.panel_size", "Challenges Panel Size");
        this.add("gui", "skills_record.consume", "Consume Mode: %s");
        this.add("gui", "skills_record.consume.no_cards", "No cards need this mode to be toggled.");
        this.add("gui", "skills_record.example", "This is an example!");
        this.add("gui", "skills_record.no_cards", "There is no card inserted!");
        this.add("gui", "skills_record.select_card", "Select a card by right click it to discover the challenges.");
        this.add("gui", "skills_record.no_challenges", "There are no challenges added yet!");
        this.add("gui", "skills_record.completed_card", "Congratulations! You made it. You have completed all the challenges.");
        this.add("gui", "skills_record.progress", "Progress: %s");
        this.add("gui", "skills_record.missing_items", "You can't accomplish any challenge! It would help if you had these items available:");
        this.add("gui", "skills_record.not_enough_ink", "There is not enough ink in the pen! Please refill it.");
        this.add("gui", "skills_record.pin", "Press to pin the challenge.");
        this.add("gui", "skills_record.pin.panel", "There are %s+ more hidden panels");
        this.add("toast", "challenge.completed", "Challenge Completed!");
        this.add("toast", "challenge.completed.info", "You have completed Challenge %s in %s");
        this.add("toast", "challenge.all_completed", "Congratulations!");
        this.add("toast", "challenge.all_completed.info", "You have completed all the challenges for the %s.");
        this.add("advancement", "root.desc", "Have you been feeling weak lately? Take this journey for an improvement!");
        this.add("advancement", "obtain", "Obtain a %s");
        this.add("advancement", "craft", "Craft a %s");
        this.add("advancement", "amethyst_gathering", "Bring me the crystals!");
        this.add("advancement", "obtain.slime_balls", "Huh? oh... Yuck!");
        this.add("advancement", "obtain.card.empty", "Well... This is Useless!");
        this.add("advancement", "craft.pen", "Isn't this Exquisite?");
        this.add("advancement", "craft.skills_record", "It's time to take notes!");
        this.add("advancement", "craft.card.blueprint", "Ctrl-C + Ctrl-V = Copy-Paste");
        this.add("advancement", "craft.card.pickaxe", "That's my Geode Gobbler!");
        this.add("advancement", "craft.card.axe", "Oh, I had an AXEIDENT! Did you get it?");
        this.add("advancement", "craft.card.shovel", "Gold Rush!");
        this.add("advancement", "craft.card.hoe", "You can't sit with us.");
        this.add("advancement", "ultimine_ability", "Powerful like a machine!");
        this.add("advancement", "ultimine_ability.desc", "Craft a %s using all four types of mastered mining skill cards and interact with it.");
        this.add("challenge", "title", "Challenge %s");
        this.add("challenge", "consume", "The block will be voided!");
        this.add("challenge", "consume.info", "In order to accomplish this challenge, You have to enable the consume mode.");
        this.add("challenge", "break_block", "Destroy %s.");
        this.add("challenge", "strip_block", "Strip the %s.");
        this.add("challenge", "flatten_block", "Flatten the %s.");
        this.add("challenge", "tilling_block", "Plow the %s.");
        this.add("challenge", "interact_with_block", "Interact with %s.");
        this.add("challenge", "various_blocks", "one of these blocks (%s)");
        this.add("info", "placed_by_entity", "Ineligible block! This block was placed by %s.");
        this.add("info", "obtain", "Congratulations on learning the excavation skill!");
        this.add("info", "obtained_already", "You have already obtained this knowledge!");
        this.add("info", "incapable", "You need the excavation skill to perform this action! First, Obtain a Miner Certificate or drink a Mine-Go Juice.");
        this.add("info", "legacy_mode", "You can't use this! The playstyle mode has been set to Legacy.");
        this.add("info", "required_skill", "Required Skill for: %s");
        this.add("info", "required_skill.many_tools", "List of Tools");
        this.add("info", "required_skill.pickaxe", "Pickaxe");
        this.add("info", "required_skill.axe", "Axe");
        this.add("info", "required_skill.shovel", "Shovel");
        this.add("info", "required_skill.hoe", "Hoe");
        this.add("info", "required_skill.all", "All Tools");
        this.add("argument", "inventory.unknown", "Unknown inventory '%s'");
        this.add("argument", "challenge.unknown", "Unknown challenge '%s'");
        this.add("argument", "cards.tier.unknown", "Unknown card tier '%s'");
        this.add("command", "cards.not_found", "There is no card in the selected slot!");
        this.add("command", "challenge.success", "You have successfully changed the '%s' challenge current point from %s to %s!");
        this.add("command", "challenge.sender", "You have successfully changed the '%s' challenge current point from %s to %s for:");
        this.add("command", "challenge.receiver", "Your '%s' challenge current point has been changed from %s to %s! (by %s)");
        this.add("command", "challenge.accomplished", "The '%s' challenge is already accomplished.");
        this.add("command", "cards.tier.set.success", "You have successfully set the %s tier to %s!");
        this.add("command", "cards.tier.set.sender", "You have successfully set the %s tier to %s for:");
        this.add("command", "cards.tier.set.receiver", "Your %s tier has been set to %s! (by %s)");
        this.add("command", "cards.tier.set.already_setted", "The %s tier is already set to %s.");
        this.add("command", "set_ability.success", "You have successfully set the ultimine ability to %s!");
        this.add("command", "set_ability.sender", "You have successfully set the ultimine ability to %s for:");
        this.add("command", "set_ability.receiver", "Your ultimine ability has been set to %s! (by %s)");
        this.add("command", "set_ability.already_setted", "The ultimine ability is already set to %s.");
        this.add("key.category", "general", "Ultimine Addition");
        this.add(KeyHandler.KEY_OPEN_SKILLS_RECORD, "Open Skills Record");
        this.add(KeyHandler.KEY_SHOW_PROGRESSION_BAR, "Skills Record: Show Progression Bar");
    }

    private void add(String key, String value) {
        this.translations.put(key, value);
    }

    private void add(class_1792 item, String value) {
        this.translations.put(item, value);
    }

    private void add(class_1291 mobEffect, String value) {
        this.translations.put(mobEffect, value);
    }

    private void add(class_304 keyMapping, String value) {
        this.translations.put(keyMapping.method_1431(), value);
    }

    private void add(String category, String key, @NotNull String value) {
        this.add(String.format("%s.%s.%s", category, "ultimine_addition", key), value);
    }

    private void addPotion(String key, String value, @Nullable String potionType) {
        String type = potionType == null ? "Potion" : potionType;
        String potion = potionType == null ? value + " Potion" : value.replace("%t", " " + type);
        String potionName = value.replace("%t", "");
        this.add(String.format("item.minecraft.potion.effect.%s", key), potion);
        this.add(String.format("item.minecraft.splash_potion.effect.%s", key), String.format("Splash %s of %s", type, potionName));
        this.add(String.format("item.minecraft.tipped_arrow.effect.%s", key), String.format("Arrow of %s", potion));
        this.add(String.format("item.minecraft.lingering_potion.effect.%s", key), String.format("Lingering %s of %s", type, potionName));
    }

    private void addCurios(String key, String value) {
        this.translations.put("curios.identifier.%s".formatted(key), value);
    }

    private void addTrinkets(String key, String value) {
        this.translations.put("trinkets.slot.%s".formatted(key), value);
    }

    public Map<Object, String> getTranslations() {
        return this.translations;
    }
}

