/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.challenge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.datagen.challenge.builder.ChallengesBuilder;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public abstract class ChallengeProvider
implements class_2405 {
    private final class_7784 output;
    private final Map<class_2960, ChallengesData> data = new TreeMap<class_2960, ChallengesData>();

    protected abstract void buildChallenges(Consumer<ChallengesBuilder.Result> var1);

    public ChallengeProvider(class_7784 output) {
        this.output = output;
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        this.clear();
        this.buildChallenges(result -> {
            if (this.data.containsKey(result.id())) {
                throw new IllegalStateException("Duplicate challenge " + result.id().toString());
            }
            this.data.put(result.id(), result.data());
        });
        if (this.data.isEmpty()) {
            throw new IllegalStateException("The challenges data is empty!");
        }
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<class_2960, ChallengesData> data : this.data.entrySet()) {
            AtomicReference<JsonObject> JSONProperties = new AtomicReference<JsonObject>(new JsonObject());
            ChallengesData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data.getValue()).result().ifPresent(json -> JSONProperties.set(json.getAsJsonObject()));
            futures[i++] = class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)JSONProperties.get()), (Path)this.pathProvider(data.getValue()).method_44107(data.getKey()));
        }
        return CompletableFuture.allOf(futures);
    }

    private class_7784.class_7489 pathProvider(ChallengesData value) {
        String path = "";
        if (value.getForCardType().equals(MiningSkillCardItem.Type.PICKAXE)) {
            path = "/pickaxe";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.AXE)) {
            path = "/axe";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.SHOVEL)) {
            path = "/shovel";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.HOE)) {
            path = "/hoe";
        }
        return this.output.method_45973(class_7784.class_7490.field_39367, "challenges" + path);
    }

    private void clear() {
        this.data.clear();
    }

    @NotNull
    public final String method_10321() {
        return "Ultimine Addition Challenges";
    }
}

