/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.challenge;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.tag.ModBlockTags;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.ixdarklord.ultimine_addition.datagen.challenge.ChallengeProvider;
import net.ixdarklord.ultimine_addition.datagen.challenge.builder.ChallengesBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import net.minecraft.class_7784;

public class ChallengeGenerator
extends ChallengeProvider {
    public ChallengeGenerator(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        super(output);
    }

    @Override
    protected void buildChallenges(Consumer<ChallengesBuilder.Result> consumer) {
        this.buildPickaxeChallenges(consumer);
        this.buildAxeChallenges(consumer);
        this.buildShovelChallenges(consumer);
        this.buildHoeChallenges(consumer);
    }

    private void buildPickaxeChallenges(Consumer<ChallengesBuilder.Result> consumer) {
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_stones"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(128).targetedBlocks(ModBlockTags.FORGE_STONE, ModBlockTags.FABRIC_STONE).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("it_looks_dripping"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(25, 64).targetedBlocks(class_2246.field_28049, class_2246.field_28048).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_coal"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(ModBlockTags.FORGE_COAL_ORES, ModBlockTags.FABRIC_COAL_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_iron"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(ModBlockTags.FORGE_IRON_ORES, ModBlockTags.FABRIC_IRON_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_copper"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(ModBlockTags.FORGE_COPPER_ORES, ModBlockTags.FABRIC_COPPER_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_gold"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(32, 64).targetedBlocks(ModBlockTags.FORGE_GOLD_ORES, ModBlockTags.FABRIC_GOLD_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_lapis"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(ModBlockTags.FORGE_LAPIS_ORES, ModBlockTags.FABRIC_LAPIS_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("ugly_quartz"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_27161).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("is_it_useful"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_27114, class_2246.field_22091).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_redstone"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(32, 64).targetedBlocks(ModBlockTags.FORGE_REDSTONE_ORES, ModBlockTags.FABRIC_REDSTONE_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_diamond"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(32, 64).targetedBlocks(ModBlockTags.FORGE_DIAMOND_ORES, ModBlockTags.FABRIC_DIAMOND_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("digging_for_emerald"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 32).targetedBlocks(ModBlockTags.FORGE_EMERALD_ORES, ModBlockTags.FABRIC_EMERALD_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("under_da_sea"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 32).targetedBlocks(class_2246.field_10135, class_2246.field_10297, class_2246.field_10174).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("nether_time"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(10).targetedBlocks(class_2246.field_10540).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("netherrack"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(128, 350).targetedBlocks(class_2246.field_10515).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("do_you_wanna_build_a_laser"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(ModBlockTags.FORGE_QUARTZ_ORES, ModBlockTags.FABRIC_QUARTZ_ORES).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("glowstone"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10171).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("bone_block"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(20, 40).targetedBlocks(class_2246.field_10166).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("badlands_or_mesa"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(128, 256).targetedBlocks(class_3481.field_36265).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("blackstone_variants"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_23869, class_2246.field_23880).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("this_looks_old_but_good"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(8, 16).targetedBlocks(class_2246.field_22109).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("the_end"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_10471).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("purrr_blocks"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10286, class_2246.field_10505).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_cobblestone_hardmode"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(256, 512).targetedBlocks(ModBlockTags.FORGE_STONE, ModBlockTags.FABRIC_STONE).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_obsidian_hardmode"), MiningSkillCardItem.Type.PICKAXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 180).targetedBlocks(ModBlockTags.FORGE_OBSIDIAN, ModBlockTags.FABRIC_OBSIDIAN).save(consumer);
    }

    private void buildAxeChallenges(Consumer<ChallengesBuilder.Result> consumer) {
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_logs"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(128).targetedBlocks(class_3481.field_15475).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_birch"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_2246.field_10511).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_spruce"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_2246.field_10037).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_bases"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(4, 8).targetedBlocks(class_2246.field_9980, class_2246.field_10034, class_2246.field_16328).targetedBlocks(class_3481.field_16443).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_dark_oak"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10010).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("strip_oak"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.STRIP_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(32, 64).targetedBlocks(class_2246.field_10431).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_stripped_oak"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64).targetedBlocks(class_2246.field_10519).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_ladder"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 32).targetedBlocks(class_2246.field_9983).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("strip_dark_oak"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.STRIP_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10010).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_stripped_dark_oak"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(40, 80).targetedBlocks(class_2246.field_10244).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_bookshelf"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(8, 16).targetedBlocks(class_2246.field_10504).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_composter"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(2, 4).targetedBlocks(class_2246.field_17563).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_melon"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 32).targetedBlocks(class_2246.field_10545).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_pumpkin"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 32).targetedBlocks(class_2246.field_10261).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_bamboo"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(16, 32).targetedBlocks(class_2246.field_10211).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_oak_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(200, 350).targetedBlocks(class_2246.field_10431).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_spruce_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(200, 350).targetedBlocks(class_2246.field_10037).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_birch_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(200, 350).targetedBlocks(class_2246.field_10511).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_jungle_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(200, 350).targetedBlocks(class_2246.field_10511).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("strip_logs_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(200, 350).targetedBlocks(class_3481.field_15475).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_melon_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10545).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("obtain_pumpkin_hardcore"), MiningSkillCardItem.Type.AXE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10261).save(consumer);
    }

    private void buildShovelChallenges(Consumer<ChallengesBuilder.Result> consumer) {
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_dirt"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_3481.field_29822).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sand"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_3481.field_15466).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_gravel"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_2246.field_10255).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_clay"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10460).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_podzol"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10520).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_mud"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_37576).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_snow"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(128, 256).targetedBlocks(class_2246.field_10477, class_2246.field_10491).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_soul_sand"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(128, 256).targetedBlocks(class_2246.field_10114, class_2246.field_22090).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_mycelium"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10402).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("flatting_dirt"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.FLATTEN_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10566).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("flatting_grass"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.FLATTEN_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10219).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_dirt_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_3481.field_29822).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("flatting_dirt_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.FLATTEN_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10219, class_2246.field_10566).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_red_sand_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_10534).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sand_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(256, 512).targetedBlocks(class_2246.field_10102).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_mud_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_37576).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_podzol_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_10520).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_snow_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(256, 512).targetedBlocks(class_2246.field_10477, class_2246.field_10491).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_gravel_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_10255).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_clay_hardcore"), MiningSkillCardItem.Type.SHOVEL).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(128, 256).targetedBlocks(class_2246.field_10460).save(consumer);
    }

    private void buildHoeChallenges(Consumer<ChallengesBuilder.Result> consumer) {
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_leaves"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_3481.field_15503).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("tilling_for_farmland"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.TILLING_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_2246.field_10219, class_2246.field_10566, class_2246.field_10194).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_flowers"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Unlearned).requiredAmount(64, 128).targetedBlocks(class_3481.field_20339).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_grass"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10479, class_2246.field_10214).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_birch_leaves"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10539).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_poppy_and_dandelion"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(16, 128).targetedBlocks(class_2246.field_10449, class_2246.field_10182).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_jungle_leaves"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Novice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10335).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_hay_bale"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(64, 128).targetedBlocks(class_2246.field_10359).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_oxeye"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 64).targetedBlocks(class_2246.field_10554).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_kelp"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(16, 128).targetedBlocks(class_2246.field_9993).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sculk"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(32, 128).targetedBlocks(class_2246.field_37568, class_2246.field_37569).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sculk_sensor"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(4, 16).targetedBlocks(class_2246.field_28108).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sculk_catalyst"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Apprentice).requiredAmount(4, 16).targetedBlocks(class_2246.field_37570).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_shroomlight"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_22122).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_nether_wart_block"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10541).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_warped_wart_block"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10541).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_nether_wart"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(16, 32).targetedBlocks(class_2246.field_9974).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_sponge"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(16, 32).targetedBlocks(class_2246.field_10258, class_2246.field_10562).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("tilling_for_farmland_hardcore"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.TILLING_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_10219, class_2246.field_10566, class_2246.field_10194).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_moss"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(64, 128).targetedBlocks(class_2246.field_28681, class_2246.field_28680).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("gathering_leaves_hardcore"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(256, 512).targetedBlocks(class_3481.field_15503).save(consumer);
        ChallengesBuilder.create(UltimineAddition.getLocation("break_flowers"), MiningSkillCardItem.Type.HOE).forType(ChallengesData.Type.BREAK_BLOCK_CONSUME).forTier(MiningSkillCardItem.Tier.Adept).requiredAmount(256, 512).targetedBlocks(class_3481.field_20339).save(consumer);
    }
}

