/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.core;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.ixdarklord.coolcat_lib.util.ArgumentTypeHelper;
import net.ixdarklord.ultimine_addition.api.CustomMSCApi;
import net.ixdarklord.ultimine_addition.client.particle.CelebrateParticle;
import net.ixdarklord.ultimine_addition.common.advancement.UltimineAbilityTrigger;
import net.ixdarklord.ultimine_addition.common.command.arguments.CardSlotsArgument;
import net.ixdarklord.ultimine_addition.common.command.arguments.CardTierArgument;
import net.ixdarklord.ultimine_addition.common.command.arguments.ChallengesArgument;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.effect.MineGoJuiceEffect;
import net.ixdarklord.ultimine_addition.common.effect.ModMobEffects;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.common.potion.MineGoPotion;
import net.ixdarklord.ultimine_addition.common.recipe.ItemStorageDataRecipe;
import net.ixdarklord.ultimine_addition.common.recipe.MCRecipe;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_174;
import net.minecraft.class_1761;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Registration {
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_44688);
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41197);
    public static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41208);
    public static final DeferredRegister<class_1842> POTIONS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41215);
    public static final DeferredRegister<class_3917<?>> CONTAINERS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41207);
    public static final DeferredRegister<class_1865<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41216);
    public static final DeferredRegister<class_2396<?>> PARTICLE_TYPES = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41210);
    public static final DeferredRegister<class_2314<?, ?>> ARGUMENT_TYPES = DeferredRegister.create((String)"ultimine_addition", (class_5321)class_7924.field_41262);
    private static final Map<String, Supplier<class_1291>> mineGoJuiceList = new HashMap<String, Supplier<class_1291>>();
    public static final RegistrySupplier<class_1761> ULTIMINE_ADDITION_TAB = TABS.register("general_tab", () -> CreativeTabRegistry.create(builder -> {
        builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.ultimine_addition.tab"));
        builder.method_47320(() -> ((class_1792)ModItems.MINER_CERTIFICATE).method_7854());
        builder.method_47317((itemDisplayParameters, output) -> {
            output.method_45421((class_1935)ModItems.MINER_CERTIFICATE);
            if (ConfigHandler.COMMON.PLAYSTYLE_MODE_SAFE.get() != PlaystyleMode.LEGACY) {
                output.method_45421((class_1935)ModItems.SKILLS_RECORD);
                output.method_45421((class_1935)ModItems.INK_CHAMBER);
                output.method_45421((class_1935)ModItems.PEN);
                class_1799 penStack = ModItems.PEN.method_7854();
                ItemStorageData storageData = ((PenItem)penStack.method_7909()).getData(penStack);
                storageData.setCapacity(storageData.getMaxCapacity()).saveData(penStack);
                output.method_45420(penStack);
                output.method_45421((class_1935)ModItems.CARD_BLUEPRINT);
                output.method_45421((class_1935)ModItems.MINING_SKILL_CARD_EMPTY);
                for (MiningSkillCardItem.Type type : MiningSkillCardItem.Type.TYPES) {
                    MiningSkillCardItem cardItem;
                    String name = "mining_skill_card_" + type.getId();
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(UltimineAddition.getLocation(name));
                    if (!(item instanceof MiningSkillCardItem) || (cardItem = (MiningSkillCardItem)item).getType() == MiningSkillCardItem.Type.EMPTY) continue;
                    class_1799 cardStack = cardItem.method_7854();
                    MiningSkillCardData cardData = new MiningSkillCardData().loadData(cardStack).setTier(MiningSkillCardItem.Tier.Mastered);
                    cardData.saveData(cardStack);
                    output.method_45421((class_1935)item);
                    output.method_45420(cardStack);
                }
            }
        });
        builder.method_47324();
    }));
    public static final RegistrySupplier<class_1792> MINER_CERTIFICATE = ITEMS.register("miner_certificate", () -> ModItems.MINER_CERTIFICATE);
    public static final RegistrySupplier<class_1792> SKILLS_RECORD = ITEMS.register("skills_record", () -> ModItems.SKILLS_RECORD);
    public static final RegistrySupplier<class_1792> INK_CHAMBER = ITEMS.register("ink_chamber", () -> ModItems.INK_CHAMBER);
    public static final RegistrySupplier<class_1792> PEN = ITEMS.register("pen", () -> ModItems.PEN);
    public static final RegistrySupplier<class_1792> CARD_BLUEPRINT = ITEMS.register("card_blueprint", () -> ModItems.CARD_BLUEPRINT);
    public static final RegistrySupplier<class_1792> MINING_SKILL_CARD_EMPTY = ITEMS.register("mining_skill_card_empty", () -> ModItems.MINING_SKILL_CARD_EMPTY);
    public static final RegistrySupplier<class_1792> MINING_SKILL_CARD_PICKAXE = ITEMS.register("mining_skill_card_pickaxe", () -> ModItems.MINING_SKILL_CARD_PICKAXE);
    public static final RegistrySupplier<class_1792> MINING_SKILL_CARD_AXE = ITEMS.register("mining_skill_card_axe", () -> ModItems.MINING_SKILL_CARD_AXE);
    public static final RegistrySupplier<class_1792> MINING_SKILL_CARD_SHOVEL = ITEMS.register("mining_skill_card_shovel", () -> ModItems.MINING_SKILL_CARD_SHOVEL);
    public static final RegistrySupplier<class_1792> MINING_SKILL_CARD_HOE = ITEMS.register("mining_skill_card_hoe", () -> ModItems.MINING_SKILL_CARD_HOE);
    public static final RegistrySupplier<class_1291> MINE_GO_JUICE_PICKAXE = MOB_EFFECTS.register("mine_go_juice_pickaxe", () -> ModMobEffects.MINE_GO_JUICE_PICKAXE);
    public static final RegistrySupplier<class_1291> MINE_GO_JUICE_AXE = MOB_EFFECTS.register("mine_go_juice_axe", () -> ModMobEffects.MINE_GO_JUICE_AXE);
    public static final RegistrySupplier<class_1291> MINE_GO_JUICE_SHOVEL = MOB_EFFECTS.register("mine_go_juice_shovel", () -> ModMobEffects.MINE_GO_JUICE_SHOVEL);
    public static final RegistrySupplier<class_1291> MINE_GO_JUICE_HOE = MOB_EFFECTS.register("mine_go_juice_hoe", () -> ModMobEffects.MINE_GO_JUICE_HOE);
    public static final RegistrySupplier<class_1842> KNOWLEDGE_POTION = POTIONS.register("knowledge", () -> new class_1842(new class_1293[0]));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_PICKAXE_POTION = POTIONS.register("mine_go_juice_pickaxe", () -> new MineGoPotion(MiningSkillCardItem.Tier.Novice, new class_1293(ModMobEffects.MINE_GO_JUICE_PICKAXE, ConfigHandler.COMMON.TIER_1_TIME_SAFE.get() * 20, 0)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_PICKAXE_POTION2 = POTIONS.register("mine_go_juice_pickaxe_2", () -> new MineGoPotion(MiningSkillCardItem.Tier.Apprentice, new class_1293(ModMobEffects.MINE_GO_JUICE_PICKAXE, ConfigHandler.COMMON.TIER_2_TIME_SAFE.get() * 20, 1)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_PICKAXE_POTION3 = POTIONS.register("mine_go_juice_pickaxe_3", () -> new MineGoPotion(MiningSkillCardItem.Tier.Adept, new class_1293(ModMobEffects.MINE_GO_JUICE_PICKAXE, ConfigHandler.COMMON.TIER_3_TIME_SAFE.get() * 20, 2)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_AXE_POTION = POTIONS.register("mine_go_juice_axe", () -> new MineGoPotion(MiningSkillCardItem.Tier.Novice, new class_1293(ModMobEffects.MINE_GO_JUICE_AXE, ConfigHandler.COMMON.TIER_1_TIME_SAFE.get() * 20, 0)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_AXE_POTION2 = POTIONS.register("mine_go_juice_axe_2", () -> new MineGoPotion(MiningSkillCardItem.Tier.Apprentice, new class_1293(ModMobEffects.MINE_GO_JUICE_AXE, ConfigHandler.COMMON.TIER_2_TIME_SAFE.get() * 20, 1)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_AXE_POTION3 = POTIONS.register("mine_go_juice_axe_3", () -> new MineGoPotion(MiningSkillCardItem.Tier.Adept, new class_1293(ModMobEffects.MINE_GO_JUICE_AXE, ConfigHandler.COMMON.TIER_3_TIME_SAFE.get() * 20, 2)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_SHOVEL_POTION = POTIONS.register("mine_go_juice_shovel", () -> new MineGoPotion(MiningSkillCardItem.Tier.Novice, new class_1293(ModMobEffects.MINE_GO_JUICE_SHOVEL, ConfigHandler.COMMON.TIER_1_TIME_SAFE.get() * 20, 0)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_SHOVEL_POTION2 = POTIONS.register("mine_go_juice_shovel_2", () -> new MineGoPotion(MiningSkillCardItem.Tier.Apprentice, new class_1293(ModMobEffects.MINE_GO_JUICE_SHOVEL, ConfigHandler.COMMON.TIER_2_TIME_SAFE.get() * 20, 1)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_SHOVEL_POTION3 = POTIONS.register("mine_go_juice_shovel_3", () -> new MineGoPotion(MiningSkillCardItem.Tier.Adept, new class_1293(ModMobEffects.MINE_GO_JUICE_SHOVEL, ConfigHandler.COMMON.TIER_3_TIME_SAFE.get() * 20, 2)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_HOE_POTION = POTIONS.register("mine_go_juice_hoe", () -> new MineGoPotion(MiningSkillCardItem.Tier.Novice, new class_1293(ModMobEffects.MINE_GO_JUICE_HOE, ConfigHandler.COMMON.TIER_1_TIME_SAFE.get() * 20, 0)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_HOE_POTION2 = POTIONS.register("mine_go_juice_hoe_2", () -> new MineGoPotion(MiningSkillCardItem.Tier.Apprentice, new class_1293(ModMobEffects.MINE_GO_JUICE_HOE, ConfigHandler.COMMON.TIER_2_TIME_SAFE.get() * 20, 1)));
    public static final RegistrySupplier<class_1842> MINE_GO_JUICE_HOE_POTION3 = POTIONS.register("mine_go_juice_hoe_3", () -> new MineGoPotion(MiningSkillCardItem.Tier.Adept, new class_1293(ModMobEffects.MINE_GO_JUICE_HOE, ConfigHandler.COMMON.TIER_3_TIME_SAFE.get() * 20, 2)));
    public static final RegistrySupplier<class_3917<SkillsRecordMenu>> SKILLS_RECORD_CONTAINER = CONTAINERS.register("skills_record", () -> MenuRegistry.ofExtended(SkillsRecordMenu::new));
    public static final RegistrySupplier<ItemStorageDataRecipe.Serializer> ITEM_DATA_STORAGE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register(ItemStorageDataRecipe.Serializer.NAME, ItemStorageDataRecipe.Serializer::new);
    public static final RegistrySupplier<MCRecipe.Serializer> MC_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register(MCRecipe.Serializer.NAME, MCRecipe.Serializer::new);
    public static final RegistrySupplier<class_2400> CELEBRATE_PARTICLE = PARTICLE_TYPES.register("celebrate", () -> new class_2400(true));
    public static final UltimineAbilityTrigger OBTAIN_ULTIMINE_TRIGGER = (UltimineAbilityTrigger)class_174.method_767((class_179)new UltimineAbilityTrigger());
    public static final RegistrySupplier<class_2314<CardTierArgument, ?>> CARD_TIER_ARGUMENT = ARGUMENT_TYPES.register("card_tier", () -> ArgumentTypeHelper.register(CardTierArgument.class, (class_2314)class_2319.method_41999(CardTierArgument::tier)));
    public static final RegistrySupplier<class_2314<CardSlotsArgument, ?>> CARD_SLOTS_ARGUMENT = ARGUMENT_TYPES.register("card_slots", () -> ArgumentTypeHelper.register(CardSlotsArgument.class, (class_2314)class_2319.method_41999(CardSlotsArgument::slots)));
    public static final RegistrySupplier<class_2314<ChallengesArgument, ?>> CHALLENGES_ARGUMENT = ARGUMENT_TYPES.register("challenges", () -> ArgumentTypeHelper.register(ChallengesArgument.class, (class_2314)class_2319.method_41999(ChallengesArgument::data)));

    public static void register() {
        Registration.registerItems();
        Registration.registerMobEffects();
        Registration.registerPotions();
        TABS.register();
        CONTAINERS.register();
        RECIPE_SERIALIZERS.register();
        ARGUMENT_TYPES.register();
        PARTICLE_TYPES.register();
    }

    private static void registerItems() {
        for (MiningSkillCardItem.Type type : CustomMSCApi.CUSTOM_TYPES) {
            String name = "mining_skill_card_%s".formatted(type.getId());
            ITEMS.register(name, () -> new MiningSkillCardItem(new class_1792.class_1793().method_7889(1), type));
        }
        ITEMS.register();
    }

    private static void registerMobEffects() {
        for (MiningSkillCardItem.Type type : CustomMSCApi.CUSTOM_TYPES) {
            String id = MineGoJuiceEffect.getId(type).method_12832();
            MineGoJuiceEffect mobEffect = new MineGoJuiceEffect(type, class_4081.field_18271, type.getPotionColor().getRGB());
            MOB_EFFECTS.register(id, () -> mobEffect);
            mineGoJuiceList.put(id, () -> mobEffect);
        }
        MOB_EFFECTS.register();
    }

    private static void registerPotions() {
        for (MiningSkillCardItem.Type type : CustomMSCApi.CUSTOM_TYPES) {
            String id = MineGoJuiceEffect.getId(type).method_12832();
            Supplier<class_1291> mobEffect = mineGoJuiceList.get(id);
            if (mobEffect == null) continue;
            POTIONS.register(id, () -> new MineGoPotion(MiningSkillCardItem.Tier.Novice, new class_1293((class_1291)mobEffect.get(), ConfigHandler.COMMON.TIER_1_TIME_SAFE.get() * 20, 0)));
            POTIONS.register(id + "_2", () -> new MineGoPotion(MiningSkillCardItem.Tier.Apprentice, new class_1293((class_1291)mobEffect.get(), ConfigHandler.COMMON.TIER_2_TIME_SAFE.get() * 20, 1)));
            POTIONS.register(id + "_3", () -> new MineGoPotion(MiningSkillCardItem.Tier.Adept, new class_1293((class_1291)mobEffect.get(), ConfigHandler.COMMON.TIER_3_TIME_SAFE.get() * 20, 2)));
        }
        mineGoJuiceList.clear();
        POTIONS.register();
    }

    public static void registerParticleProviders() {
        ParticleProviderRegistry.register(CELEBRATE_PARTICLE, CelebrateParticle.Provider::new);
    }
}

