/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.core;

import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBRanksIntegration;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.effect.MineGoJuiceEffect;
import net.ixdarklord.ultimine_addition.common.effect.ModMobEffects;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class FTBUltimineIntegration
implements FTBUltiminePlugin {
    private static boolean isButtonPressed;

    public void init() {
        UltimineAddition.LOGGER.info("Registering plugin to FTBUltimine!");
    }

    public boolean canUltimine(class_1657 player) {
        boolean result = ServicePlatform.Players.isPlayerUltimineCapable(player);
        if (result) {
            return true;
        }
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return result;
        }
        if (FTBUltimineIntegration.isPlayerHasCustomCardValidEffect(player) && ItemUtils.isItemInHandCustomCardValid(player)) {
            result = true;
        }
        if (!ItemUtils.checkTargetedBlock(player)) {
            return false;
        }
        if (player.method_6059(ModMobEffects.MINE_GO_JUICE_PICKAXE) && ItemUtils.isItemInHandPickaxe(player)) {
            result = true;
        }
        if (player.method_6059(ModMobEffects.MINE_GO_JUICE_AXE) && ItemUtils.isItemInHandAxe(player)) {
            result = true;
        }
        if (player.method_6059(ModMobEffects.MINE_GO_JUICE_SHOVEL) && ItemUtils.isItemInHandShovel(player)) {
            result = true;
        }
        if (player.method_6059(ModMobEffects.MINE_GO_JUICE_HOE) && ItemUtils.isItemInHandHoe(player)) {
            result = true;
        }
        return result;
    }

    public static void keyEvent(class_1657 player) {
        if (FTBUltimineClient.keyBinding.method_1434()) {
            if (!isButtonPressed) {
                class_5250 MSG = class_2561.method_43471((String)"info.ultimine_addition.incapable");
                class_5250 requiredTool = null;
                if (!ServicePlatform.Players.isPlayerUltimineCapable(player)) {
                    if (ItemUtils.isItemInHandCustomCardValid(player)) {
                        if (!FTBUltimineIntegration.isPlayerHasCustomCardValidEffect(player)) {
                            String[] toolNames = (String[])FTBUltimineIntegration.getCustomCardTypes(player).stream().map(MiningSkillCardItem.Type::getId).toArray(String[]::new);
                            String toolPrefix = toolNames.length > 1 ? "many_tools" : toolNames[0];
                            class_5250 toolsList = class_2561.method_43473();
                            for (int i = 0; i < toolNames.length; ++i) {
                                toolsList.method_27693("[").method_10852((class_2561)class_2561.method_43471((String)"info.ultimine_addition.required_skill.%s".formatted(toolNames[i]))).method_27693("]");
                                if (i == toolNames.length - 1) continue;
                                toolsList.method_27693(", ");
                            }
                            class_2568 event = new class_2568(class_2568.class_5247.field_24342, (Object)toolsList);
                            class_2583 style = toolNames.length > 1 ? class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10949(event) : class_2583.field_24360;
                            requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.%s".formatted(toolPrefix)).method_27696(style);
                        }
                    } else if (ItemUtils.isItemInHandPickaxe(player)) {
                        if (!player.method_6059(ModMobEffects.MINE_GO_JUICE_PICKAXE)) {
                            requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.pickaxe");
                        }
                    } else if (ItemUtils.isItemInHandAxe(player)) {
                        if (!player.method_6059(ModMobEffects.MINE_GO_JUICE_AXE)) {
                            requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.axe");
                        }
                    } else if (ItemUtils.isItemInHandShovel(player)) {
                        if (!player.method_6059(ModMobEffects.MINE_GO_JUICE_SHOVEL)) {
                            requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.shovel");
                        }
                    } else if (ItemUtils.isItemInHandHoe(player)) {
                        if (!player.method_6059(ModMobEffects.MINE_GO_JUICE_HOE)) {
                            requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.hoe");
                        }
                    } else if (ItemUtils.isItemInHandNotTools(player)) {
                        requiredTool = class_2561.method_43471((String)"info.ultimine_addition.required_skill.all");
                    }
                    if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() != PlaystyleMode.LEGACY) {
                        if (requiredTool != null) {
                            player.method_7353((class_2561)MSG.method_27692(class_124.field_1061), false);
                            player.method_7353((class_2561)class_2561.method_43470((String)"\u2716 ").method_10852((class_2561)class_2561.method_43469((String)"info.ultimine_addition.required_skill", (Object[])new Object[]{requiredTool})).method_27692(class_124.field_1080), false);
                        }
                    } else {
                        player.method_7353((class_2561)MSG.method_27692(class_124.field_1061), false);
                    }
                }
                isButtonPressed = true;
            }
        } else {
            isButtonPressed = false;
        }
    }

    public static List<MiningSkillCardItem.Type> getCustomCardTypes(class_1657 player) {
        class_1799 stack = ItemUtils.getItemInHand(player, true);
        return MiningSkillCardItem.Type.TYPES.stream().filter(MiningSkillCardItem.Type::isCustomType).filter(type -> type.utilizeRequiredTools().contains(stack.method_7909())).toList();
    }

    private static boolean isPlayerHasCustomCardValidEffect(class_1657 player) {
        List<MiningSkillCardItem.Type> types = FTBUltimineIntegration.getCustomCardTypes(player);
        for (MiningSkillCardItem.Type type : types) {
            class_1291 mobEffect = (class_1291)Registration.MOB_EFFECTS.getRegistrar().get(UltimineAddition.getLocation("mine_go_juice_%s".formatted(type.getId())));
            if (mobEffect == null || !player.method_6059(mobEffect)) continue;
            return true;
        }
        return false;
    }

    public static int getMaxBlocks(class_3222 player) {
        if (!((Boolean)ConfigHandler.COMMON.TIER_BASED_MAX_BLOCKS.get()).booleanValue()) {
            return FTBUltimine.ranksMod ? FTBRanksIntegration.getMaxBlocks((class_3222)player) : (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
        }
        ArrayList<class_1293> instances = new ArrayList<class_1293>(player.method_6026().stream().filter(mobEffectInstance -> mobEffectInstance.method_5579() instanceof MineGoJuiceEffect).toList());
        if (!ServicePlatform.Players.isPlayerUltimineCapable((class_1657)player) && !instances.isEmpty()) {
            instances.sort(Comparator.comparingInt(class_1293::method_5578).reversed());
            if (ItemUtils.isItemInHandCustomCardValid((class_1657)player)) {
                instances.removeIf(instance -> {
                    class_1799 stack = ItemUtils.getItemInHand((class_1657)player, true);
                    class_1792 patt8323$temp = stack.method_7909();
                    if (patt8323$temp instanceof MiningSkillCardItem) {
                        MiningSkillCardItem cardItem = (MiningSkillCardItem)patt8323$temp;
                        return ((MineGoJuiceEffect)instance.method_5579()).getType() != cardItem.getType();
                    }
                    return false;
                });
            } else if (ItemUtils.isItemInHandPickaxe((class_1657)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)instance.method_5579()).getType() != MiningSkillCardItem.Type.PICKAXE);
            } else if (ItemUtils.isItemInHandAxe((class_1657)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)instance.method_5579()).getType() != MiningSkillCardItem.Type.AXE);
            } else if (ItemUtils.isItemInHandShovel((class_1657)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)instance.method_5579()).getType() != MiningSkillCardItem.Type.SHOVEL);
            } else if (ItemUtils.isItemInHandHoe((class_1657)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)instance.method_5579()).getType() != MiningSkillCardItem.Type.HOE);
            }
            if (!instances.isEmpty()) {
                return switch (((class_1293)instances.get(0)).method_5578()) {
                    case 0 -> (Integer)ConfigHandler.COMMON.TIER_1_MAX_BLOCKS.get();
                    case 1 -> (Integer)ConfigHandler.COMMON.TIER_2_MAX_BLOCKS.get();
                    case 2 -> (Integer)ConfigHandler.COMMON.TIER_3_MAX_BLOCKS.get();
                    default -> (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
                };
            }
        }
        return FTBUltimine.ranksMod ? FTBRanksIntegration.getMaxBlocks((class_3222)player) : (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
    }
}

