/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class MCIngredient
implements Predicate<class_1799> {
    public static final MCIngredient EMPTY = new MCIngredient(Stream.empty());
    private final Value[] values;
    @Nullable
    private class_1799[] itemStacks;
    private MiningSkillCardItem.Tier tier;
    @Nullable
    private IntList stackingIds;

    private MCIngredient(Stream<? extends Value> stream) {
        this.values = (Value[])stream.toArray(Value[]::new);
    }

    public class_1799[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    public MiningSkillCardItem.Tier getTier() {
        this.dissolve();
        return this.tier;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (class_1799[])Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toArray(class_1799[]::new);
        }
        this.tier = Arrays.stream(this.values).map(Value::getTier).toList().get(0);
    }

    @Override
    public boolean test(@Nullable class_1799 stack) {
        class_1799[] stacks;
        if (stack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return stack.method_7960();
        }
        for (class_1799 itemStack : stacks = this.itemStacks) {
            if (!itemStack.method_31574(stack.method_7909())) continue;
            if (this.tier != null) {
                if (!itemStack.method_31574(stack.method_7909())) continue;
                MiningSkillCardData cardData = new MiningSkillCardData().loadData(stack);
                return this.tier.equals((Object)cardData.getTier());
            }
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            class_1799[] var1;
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (class_1799 itemStack : var1 = this.itemStacks) {
                this.stackingIds.add(class_1662.method_7408((class_1799)itemStack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(class_2540 buffer) {
        this.dissolve();
        buffer.writeBoolean(this.tier != null);
        if (this.tier != null) {
            buffer.writeInt(this.tier.getValue());
        }
        buffer.method_34062(Arrays.asList(this.itemStacks), class_2540::method_10793);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        return jsonArray;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    private static MCIngredient fromValues(Stream<? extends Value> stream) {
        MCIngredient DataIngredient2 = new MCIngredient(stream);
        return DataIngredient2.values.length == 0 ? EMPTY : DataIngredient2;
    }

    public static MCIngredient of() {
        return EMPTY;
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, class_1935 ... items) {
        return MCIngredient.of(tier, Arrays.stream(items).map(class_1799::new));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, class_1799 ... stacks) {
        return MCIngredient.of(tier, Arrays.stream(stacks));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, Stream<class_1799> stacks) {
        return MCIngredient.fromValues(stacks.filter(itemStack -> !itemStack.method_7960()).map(stack -> new ItemValue((class_1799)stack, tier)));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, class_6862<class_1792> tag) {
        return MCIngredient.fromValues(Stream.of(new TagValue(tag, tier)));
    }

    public static class_2371<class_1856> toNormal(class_2371<MCIngredient> inputs) {
        class_2371 result = class_2371.method_10211();
        result.addAll(inputs.stream().filter(ingredient -> !Arrays.stream(ingredient.values).filter(value -> value instanceof ItemValue).toList().isEmpty()).map(ingredient -> {
            class_1799[] items = (class_1799[])Arrays.stream(ingredient.getItems()).peek(stack -> {
                class_1792 patt5911$temp = stack.method_7909();
                if (patt5911$temp instanceof MiningSkillCardItem) {
                    MiningSkillCardItem item = (MiningSkillCardItem)patt5911$temp;
                    if (ingredient.getTier() != null) {
                        item.getData((class_1799)stack).setTier(ingredient.getTier()).saveData((class_1799)stack);
                    }
                }
            }).toArray(class_1799[]::new);
            return class_1856.method_8101((class_1799[])items);
        }).toList());
        result.addAll(inputs.stream().filter(ingredient -> !Arrays.stream(ingredient.values).filter(value -> value instanceof TagValue).toList().isEmpty()).map(ingredient -> {
            Stream<class_1856.class_1858> tagValueStream = Arrays.stream(ingredient.values).filter(value -> value instanceof TagValue).map(value -> new class_1856.class_1858(((TagValue)value).tag));
            return class_1856.method_8092(tagValueStream);
        }).toList());
        return result;
    }

    public static MCIngredient fromNetwork(class_2540 buffer) {
        MiningSkillCardItem.Tier tier = buffer.readBoolean() ? MiningSkillCardItem.Tier.fromInt(buffer.readInt()) : null;
        return MCIngredient.fromValues(buffer.method_34066(class_2540::method_10819).stream().map(stack -> new ItemValue((class_1799)stack, tier)));
    }

    public static MCIngredient fromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return MCIngredient.fromValues(Stream.of(MCIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.isEmpty()) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return MCIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> MCIngredient.valueFromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An MCIngredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            class_1792 item = class_1869.method_8155((JsonObject)json);
            MiningSkillCardItem.Tier tier = json.has("tier") ? MiningSkillCardItem.Tier.fromInt(class_3518.method_15260((JsonObject)json, (String)"tier")) : null;
            return new ItemValue(new class_1799((class_1935)item), tier);
        }
        if (json.has("tag")) {
            class_2960 resourceLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
            MiningSkillCardItem.Tier tier = json.has("tier") ? MiningSkillCardItem.Tier.fromInt(class_3518.method_15260((JsonObject)json, (String)"tier")) : null;
            return new TagValue((class_6862<class_1792>)tagKey, tier);
        }
        throw new JsonParseException("An MCIngredient entry needs either a tag or an item");
    }

    static interface Value {
        public Collection<class_1799> getItems();

        public MiningSkillCardItem.Tier getTier();

        public JsonObject serialize();
    }

    static class TagValue
    implements Value {
        protected final class_6862<class_1792> tag;
        private final MiningSkillCardItem.Tier tier;

        TagValue(class_6862<class_1792> tagKey, @Nullable MiningSkillCardItem.Tier tier) {
            this.tag = tagKey;
            this.tier = tier;
        }

        @Override
        public Collection<class_1799> getItems() {
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(this.tag)) {
                class_1799 stack = new class_1799(holder);
                if (this.tier != null && holder instanceof MiningSkillCardItem) {
                    MiningSkillCardItem item = (MiningSkillCardItem)holder;
                    item.getData(stack).setTier(this.tier).saveData(stack);
                }
                list.add(stack);
            }
            return list;
        }

        @Override
        @Nullable
        public MiningSkillCardItem.Tier getTier() {
            return this.tier;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.comp_327().toString());
            if (this.getTier() != null) {
                jsonObject.addProperty("tier", (Number)this.getTier().getValue());
            }
            return jsonObject;
        }
    }

    static class ItemValue
    implements Value {
        private final class_1799 stack;
        private final MiningSkillCardItem.Tier tier;

        ItemValue(class_1799 stack, @Nullable MiningSkillCardItem.Tier tier) {
            this.stack = stack;
            this.tier = tier;
        }

        @Override
        public Collection<class_1799> getItems() {
            return Collections.singleton(this.stack);
        }

        @Override
        @Nullable
        public MiningSkillCardItem.Tier getTier() {
            return this.tier;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)this.stack.method_7909())).toString());
            if (this.getTier() != null) {
                jsonObject.addProperty("tier", (Number)this.getTier().getValue());
            }
            return jsonObject;
        }
    }
}

