/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class DataIngredient
implements Predicate<class_1799> {
    public static final DataIngredient EMPTY = new DataIngredient(Stream.empty());
    private final Value[] values;
    @Nullable
    private class_1799[] itemStacks;
    private int amount;
    @Nullable
    private IntList stackingIds;

    private DataIngredient(Stream<? extends Value> stream) {
        this.values = (Value[])stream.toArray(Value[]::new);
    }

    public class_1799[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    public int getAmount() {
        this.dissolve();
        return this.amount;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (class_1799[])Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toArray(class_1799[]::new);
        }
        this.amount = Arrays.stream(this.values).map(Value::getAmount).toList().get(0);
    }

    @Override
    public boolean test(@Nullable class_1799 stack) {
        class_1799[] stacks;
        if (stack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return stack.method_7960();
        }
        for (class_1799 itemStack : stacks = this.itemStacks) {
            if (!itemStack.method_31574(stack.method_7909())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            class_1799[] var1;
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (class_1799 itemStack : var1 = this.itemStacks) {
                this.stackingIds.add(class_1662.method_7408((class_1799)itemStack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(class_2540 buffer) {
        this.dissolve();
        buffer.writeInt(this.amount);
        buffer.method_34062(Arrays.asList(this.itemStacks), class_2540::method_10793);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        return jsonArray;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    private static DataIngredient fromValues(Stream<? extends Value> stream) {
        DataIngredient DataIngredient2 = new DataIngredient(stream);
        return DataIngredient2.values.length == 0 ? EMPTY : DataIngredient2;
    }

    public static DataIngredient of() {
        return EMPTY;
    }

    public static DataIngredient of(int amount, class_1935 ... items) {
        return DataIngredient.of(amount, Arrays.stream(items).map(class_1799::new));
    }

    public static DataIngredient of(int amount, class_1799 ... stacks) {
        return DataIngredient.of(amount, Arrays.stream(stacks));
    }

    public static DataIngredient of(int amount, Stream<class_1799> stacks) {
        return DataIngredient.fromValues(stacks.filter(itemStack -> !itemStack.method_7960()).map(stack -> new ItemValue((class_1799)stack, amount)));
    }

    public static DataIngredient of(class_6862<class_1792> tag, int amount) {
        return DataIngredient.fromValues(Stream.of(new TagValue(tag, amount)));
    }

    public static class_2371<class_1856> toNormal(class_2371<DataIngredient> inputs) {
        class_2371 result = class_2371.method_10211();
        result.addAll(inputs.stream().map(ingredient -> {
            class_1799[] items = (class_1799[])Arrays.stream(ingredient.getItems()).peek(stack -> stack.method_7948().method_10569("amount", ingredient.getAmount())).toArray(class_1799[]::new);
            return class_1856.method_8101((class_1799[])items);
        }).toList());
        return result;
    }

    public static DataIngredient fromNetwork(class_2540 buffer) {
        int amount = buffer.readInt();
        return DataIngredient.fromValues(buffer.method_34066(class_2540::method_10819).stream().map(stack -> new ItemValue((class_1799)stack, amount)));
    }

    public static DataIngredient fromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return DataIngredient.fromValues(Stream.of(DataIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.isEmpty()) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return DataIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> DataIngredient.valueFromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An DataIngredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            class_1792 item = class_1869.method_8155((JsonObject)json);
            int amount = class_3518.method_15260((JsonObject)json, (String)"amount");
            return new ItemValue(new class_1799((class_1935)item), amount);
        }
        if (json.has("tag")) {
            class_2960 resourceLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
            int amount = class_3518.method_15260((JsonObject)json, (String)"amount");
            return new TagValue((class_6862<class_1792>)tagKey, amount);
        }
        throw new JsonParseException("An DataIngredient entry needs either a tag or an item");
    }

    static interface Value {
        public Collection<class_1799> getItems();

        public int getAmount();

        public JsonObject serialize();
    }

    static class TagValue
    implements Value {
        private final class_6862<class_1792> tag;
        private final int amount;

        TagValue(class_6862<class_1792> tagKey, int amount) {
            this.tag = tagKey;
            this.amount = amount;
        }

        @Override
        public Collection<class_1799> getItems() {
            ArrayList list = Lists.newArrayList();
            for (class_6880 holder : class_7923.field_41178.method_40286(this.tag)) {
                list.add(new class_1799(holder));
            }
            return list;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.comp_327().toString());
            jsonObject.addProperty("amount", (Number)this.getAmount());
            return jsonObject;
        }
    }

    static class ItemValue
    implements Value {
        private final class_1799 stack;
        private final int amount;

        ItemValue(class_1799 stack, int amount) {
            this.stack = stack;
            this.amount = amount;
        }

        @Override
        public Collection<class_1799> getItems() {
            return Collections.singleton(this.stack);
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)this.stack.method_7909())).toString());
            jsonObject.addProperty("amount", (Number)this.getAmount());
            return jsonObject;
        }
    }
}

