/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.MCIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class MCRecipe
extends class_1867 {
    private final class_2960 id;
    final String group;
    final class_7710 category;
    final class_1799 result;
    final class_2371<MCIngredient> ingredients;

    public MCRecipe(class_2960 id, String group, class_7710 category, class_1799 result, class_2371<MCIngredient> ingredients) {
        super(id, group, category, result, MCIngredient.toNormal(ingredients));
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
    }

    public boolean method_8118() {
        return false;
    }

    public boolean method_17730(@NotNull class_8566 container, @NotNull class_1937 level) {
        class_1662 stackedContents = new class_1662();
        int matchedValue = 0;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack = container.method_5438(i);
            if (itemStack.method_7960() || itemStack.method_7986() || this.ingredients.stream().filter(ingredient -> ingredient.test(itemStack)).toList().isEmpty()) continue;
            ++matchedValue;
            stackedContents.method_20478(itemStack, 1);
        }
        return matchedValue == this.ingredients.size() && stackedContents.method_7402((class_1860)this, null);
    }

    @NotNull
    public class_1799 method_17729(class_8566 container, class_5455 registryAccess) {
        class_1799 stack = this.method_8110(registryAccess).method_7972();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof MiningSkillCardItem) {
            MiningSkillCardItem item = (MiningSkillCardItem)class_17922;
            class_2371 inputs = class_2371.method_10211();
            for (int i = 0; i < container.method_5439(); ++i) {
                if (container.method_5438(i).method_7960() || container.method_5438(i).method_7909() instanceof MiningSkillCardItem) continue;
                inputs.add((Object)container.method_5438(i));
            }
            if (!inputs.isEmpty()) {
                item.getData(stack).setDisplayTool((class_1799)inputs.get(0)).saveData(stack);
            }
        }
        return stack;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public class_7710 getCategory() {
        return this.category;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public String method_8112() {
        return this.group;
    }

    @NotNull
    public class_2371<MCIngredient> getMCIngredients() {
        return this.ingredients;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)Registration.MC_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements class_1865<MCRecipe> {
        public static final class_2960 NAME = UltimineAddition.getLocation("mc_recipe");

        @NotNull
        public MCRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_7710 craftingBookCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
            class_2371<MCIngredient> nonnulllist = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            class_1799 stack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new MCRecipe(recipeId, group, craftingBookCategory, stack, nonnulllist);
        }

        private static class_2371<MCIngredient> itemsFromJson(JsonArray pIngredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                MCIngredient ingredient = MCIngredient.fromJson(pIngredientArray.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @NotNull
        public MCRecipe fromNetwork(@NotNull class_2960 pRecipeId, class_2540 buffer) {
            String group = buffer.method_19772();
            class_7710 craftingBookCategory = (class_7710)buffer.method_10818(class_7710.class);
            int i = buffer.method_10816();
            class_2371 nonnulllist = class_2371.method_10213((int)i, (Object)MCIngredient.EMPTY);
            nonnulllist.replaceAll(ignored -> MCIngredient.fromNetwork(buffer));
            class_1799 stack = buffer.method_10819();
            return new MCRecipe(pRecipeId, group, craftingBookCategory, stack, (class_2371<MCIngredient>)nonnulllist);
        }

        public void toNetwork(class_2540 buffer, MCRecipe recipe) {
            buffer.method_10814(recipe.method_8112());
            buffer.method_10817((Enum)recipe.category);
            buffer.method_10804(recipe.method_8117().size());
            for (MCIngredient ingredient : recipe.getMCIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.method_10793(recipe.result);
        }
    }
}

