/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.DataIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class ItemStorageDataRecipe
extends class_1852 {
    private final class_2960 id;
    final String group;
    final class_7710 category;
    final class_1799 result;
    final String storageName;
    final class_2371<DataIngredient> ingredients;

    public ItemStorageDataRecipe(class_2960 id, String group, class_7710 category, class_1799 result, String storageName, class_2371<DataIngredient> ingredients) {
        super(id, category);
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.storageName = storageName;
        this.ingredients = ingredients;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_8566 container) {
        int i;
        class_2371 items = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        ArrayList<ItemUtils.ItemSorter> sorterList = new ArrayList<ItemUtils.ItemSorter>();
        int sameItems = 0;
        for (i = 0; i < items.size(); ++i) {
            if (!this.result.method_31574(container.method_5438(i).method_7909())) continue;
            ItemStorageData data = new ItemStorageData(this.storageName).loadData(container.method_5438(i));
            sorterList.add(new ItemUtils.ItemSorter(container.method_5438(i), i, data.getCapacity()));
            ++sameItems;
        }
        if (sameItems <= 1) {
            return items;
        }
        sorterList.sort((o1, o2) -> Integer.compare(o2.order(), o1.order()));
        for (i = 1; i < sorterList.size(); ++i) {
            class_1799 stack = ((ItemUtils.ItemSorter)sorterList.get(i)).item().method_7972();
            new ItemStorageData(this.storageName).loadData(stack).setCapacity(0).saveData(stack);
            items.set(((ItemUtils.ItemSorter)sorterList.get(i)).slotId(), (Object)stack);
        }
        return items;
    }

    public boolean matches(@NotNull class_8566 container, @NotNull class_1937 level) {
        ItemStorageData data;
        class_2371 items = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        ArrayList<ItemUtils.ItemSorter> sorterList = new ArrayList<ItemUtils.ItemSorter>();
        for (int i = 0; i < container.method_5439(); ++i) {
            if (container.method_5438(i).method_7960()) continue;
            items.set(i, (Object)container.method_5438(i));
        }
        int capacity = 0;
        int matchedValue = 0;
        for (class_1799 input : items) {
            if (input.method_31574(this.result.method_7909())) {
                ItemStorageData data2 = new ItemStorageData(this.storageName).loadData(input);
                sorterList.add(new ItemUtils.ItemSorter(input, 0, data2.getCapacity()));
                capacity += data2.getCapacity();
                ++matchedValue;
            }
            for (DataIngredient ingredient : this.ingredients) {
                if (!ingredient.test(input)) continue;
                capacity += ingredient.getAmount();
                ++matchedValue;
            }
        }
        if (sorterList.isEmpty()) {
            return false;
        }
        sorterList.sort((o1, o2) -> Integer.compare(o2.order(), o1.order()));
        if (sorterList.size() > 1) {
            for (int i = 1; i < sorterList.size(); ++i) {
                data = new ItemStorageData(this.storageName).loadData(((ItemUtils.ItemSorter)sorterList.get(i)).item());
                if (data.getCapacity() != 0) continue;
                return false;
            }
        }
        int size = items.stream().filter(stack -> !stack.method_7960()).toList().size();
        data = new ItemStorageData(this.storageName).loadData(((ItemUtils.ItemSorter)sorterList.get(0)).item());
        boolean isValid = matchedValue >= 2 && size == matchedValue;
        boolean isOverflow = capacity > data.getMaxCapacity();
        return isValid && !isOverflow;
    }

    @NotNull
    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        int amount = 0;
        ItemStorageData data = new ItemStorageData(this.storageName);
        class_1799 itemStack = null;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(this.result.method_7909())) {
                amount += data.loadData(stack).getCapacity();
                itemStack = stack;
            }
            for (DataIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                amount += ingredient.getAmount();
            }
        }
        class_1799 itemStack1 = this.result.method_7972();
        data.loadData(itemStack == null ? itemStack1 : itemStack).setCapacity(amount).saveData(itemStack1);
        return itemStack1;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public class_7710 getCategory() {
        return this.category;
    }

    public class_1799 getResultItem() {
        return this.result;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_2371<DataIngredient> getDataIngredients() {
        return this.ingredients;
    }

    public String getStorageName() {
        return this.storageName;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)Registration.ITEM_DATA_STORAGE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements class_1865<ItemStorageDataRecipe> {
        public static final class_2960 NAME = UltimineAddition.getLocation("item_storage_data");

        @NotNull
        public ItemStorageDataRecipe fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_7710 craftingBookCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
            class_2371<DataIngredient> nonnulllist = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            class_1799 stack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            String storageName = class_3518.method_15253((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"), (String)"storage_name", (String)"storage");
            return new ItemStorageDataRecipe(id, group, craftingBookCategory, stack, storageName, nonnulllist);
        }

        private static class_2371<DataIngredient> itemsFromJson(JsonArray pIngredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                DataIngredient ingredient = DataIngredient.fromJson(pIngredientArray.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @NotNull
        public ItemStorageDataRecipe fromNetwork(@NotNull class_2960 id, class_2540 buffer) {
            String group = buffer.method_19772();
            class_7710 craftingBookCategory = (class_7710)buffer.method_10818(class_7710.class);
            int i = buffer.method_10816();
            class_2371 nonnulllist = class_2371.method_10213((int)i, (Object)DataIngredient.EMPTY);
            nonnulllist.replaceAll(ignored -> DataIngredient.fromNetwork(buffer));
            class_1799 itemstack = buffer.method_10819();
            String storageName = buffer.method_19772();
            return new ItemStorageDataRecipe(id, group, craftingBookCategory, itemstack, storageName, (class_2371<DataIngredient>)nonnulllist);
        }

        public void toNetwork(class_2540 buffer, ItemStorageDataRecipe recipe) {
            buffer.method_10814(recipe.method_8112());
            buffer.method_10817((Enum)recipe.category);
            buffer.method_10804(recipe.getDataIngredients().size());
            for (DataIngredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(buffer);
            }
            buffer.method_10793(recipe.result);
            buffer.method_10814(recipe.getStorageName());
        }
    }
}

