/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.menu;

import java.util.concurrent.atomic.AtomicBoolean;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.menu.DataAbstractContainerMenu;
import net.ixdarklord.ultimine_addition.common.menu.slot.CustomSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.MiningSkillCardSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PaperSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PenSlot;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class SkillsRecordMenu
extends DataAbstractContainerMenu<SkillsRecordData> {
    private final class_1799 stack;
    private final class_1657 player;
    private final class_1661 playerInventory;
    private final class_1263 container;
    private final boolean isSlotAPI;

    public SkillsRecordMenu(int id, class_1661 inventory, class_2540 buf) {
        this(id, inventory, inventory.field_7546, buf.method_10819(), buf.readBoolean());
    }

    public SkillsRecordMenu(int id, class_1661 playerInventory, class_1657 player, class_1799 stack, boolean isSlotAPI) {
        super((class_3917)Registration.SKILLS_RECORD_CONTAINER.get(), id);
        if (!(stack.method_7909() instanceof SkillsRecordItem)) {
            throw new IllegalArgumentException("Invalid item! This container only accepts Skills Record.");
        }
        this.stack = stack;
        this.player = player;
        this.playerInventory = playerInventory;
        this.container = this.createData().getContainer();
        this.isSlotAPI = isSlotAPI;
        this.addSlotBox(this.container, 0, 8, 107, 4, 20, 1, 0);
        this.method_7621(new PenSlot(this.container, 4, 132, 107));
        this.method_7621(new PaperSlot(this.container, 5, 152, 107));
        this.layoutPlayerInventorySlots(8, 136);
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        super.method_7593(slotId, button, clickType, player);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ((SkillsRecordData)this.createData().insertContainer(this.container).sendToClient(serverPlayer)).saveData(this.stack);
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 sourceSlot = (class_1735)this.field_7761.get(index);
        if (!sourceSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 sourceStack = sourceSlot.method_7677();
        class_1799 copyOfSourceStack = sourceStack.method_7972();
        if (index >= this.container.method_5439() && index < this.container.method_5439() + 36) {
            if (!this.method_7616(sourceStack, 0, this.container.method_5439(), false)) {
                return class_1799.field_8037;
            }
        } else if (index > -1) {
            if (!this.method_7616(sourceStack, this.container.method_5439(), this.container.method_5439() + 36, true)) {
                return class_1799.field_8037;
            }
        } else {
            UltimineAddition.LOGGER.error("Invalid slotIndex:" + index);
            return class_1799.field_8037;
        }
        if (sourceStack.method_7947() == 0) {
            sourceSlot.method_7673(class_1799.field_8037);
        } else {
            sourceSlot.method_7668();
        }
        sourceSlot.method_7667(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        if (this.isSlotAPI) {
            return ServicePlatform.SlotAPI.getSkillsRecordItem(player).equals(this.stack);
        }
        return player.method_6047().equals(this.stack) || player.method_6079().equals(this.stack);
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    private int addSlotRange(class_1263 container, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (container.method_5439() == this.container.method_5439()) {
                this.method_7621(new MiningSkillCardSlot(container, index, x, y));
            } else {
                this.method_7621(new class_1735(container, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private void addSlotBox(class_1263 container, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(container, index, x, y, horAmount, dx);
            y += dy;
        }
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox((class_1263)this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((class_1263)this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public class_2371<class_1735> getAllSlots() {
        class_2371 SLOTS = class_2371.method_10211();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            if (!(this.field_7761.get(i) instanceof CustomSlot)) continue;
            SLOTS.add(i, (Object)((class_1735)this.field_7761.get(i)));
        }
        return SLOTS;
    }

    public class_2371<class_1735> getCardSlots() {
        class_2371 SLOTS = class_2371.method_10211();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            if (!(this.field_7761.get(i) instanceof MiningSkillCardSlot)) continue;
            SLOTS.add(i, (Object)((class_1735)this.field_7761.get(i)));
        }
        return SLOTS;
    }

    public boolean isCardSlotsEmpty() {
        AtomicBoolean value = new AtomicBoolean(true);
        this.getCardSlots().forEach(slot -> {
            if (!slot.method_7677().method_7960()) {
                value.set(false);
            }
        });
        return value.get();
    }

    public int getInkAmount() {
        class_1799 stack = ((class_1735)this.getAllSlots().get(4)).method_7677();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof PenItem) {
            PenItem item = (PenItem)class_17922;
            return item.getData(stack).getCapacity();
        }
        return 0;
    }

    public SkillsRecordData getData() {
        return this.createData().insertContainer(this.container);
    }

    @Override
    public SkillsRecordData createData() {
        return new SkillsRecordData().loadData(this.stack);
    }
}

