/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.CodecException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.ixdarklord.coolcat_lib.common.item.ComponentItem;
import net.ixdarklord.coolcat_lib.util.ScreenUtils;
import net.ixdarklord.ultimine_addition.api.CustomMSCApi;
import net.ixdarklord.ultimine_addition.client.gui.screen.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.client.handler.ItemRendererHandler;
import net.ixdarklord.ultimine_addition.client.renderer.item.IItemRenderer;
import net.ixdarklord.ultimine_addition.client.renderer.item.UAItemRenderer;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.effect.MineGoJuiceEffect;
import net.ixdarklord.ultimine_addition.common.item.DataAbstractItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.util.ChatFormattingUtils;
import net.ixdarklord.ultimine_addition.util.CodecHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiningSkillCardItem
extends DataAbstractItem<MiningSkillCardData>
implements IItemRenderer {
    private final Type type;

    public MiningSkillCardItem(class_1792.class_1793 properties, Type type) {
        super(properties, ComponentItem.ComponentType.CRAFTING);
        this.type = type;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        return class_1271.method_22431((Object)stack);
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1297 entity, int slotID, boolean isSelected) {
        if (this.isLegacyMode() || level.method_8608() || this.type == Type.EMPTY) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (!stack.method_7985() && this.getData(stack).getChallenges().isEmpty()) {
                ((MiningSkillCardData)this.getData(stack).sendToClient(player)).initChallenges().saveData(stack);
            }
        }
    }

    public static void giveMineGoJuice(class_3222 player, Type type) {
        class_1291 effect = (class_1291)Registration.MOB_EFFECTS.getRegistrar().get(MineGoJuiceEffect.getId(type));
        if (effect == null) {
            return;
        }
        class_1293 instance = new class_1293(effect, 20, 2, false, false, false);
        if (player.method_6088().keySet().stream().filter(mobEffect -> {
            MineGoJuiceEffect juiceEffect;
            return mobEffect instanceof MineGoJuiceEffect && (juiceEffect = (MineGoJuiceEffect)((Object)mobEffect)).getType() == type;
        }).toList().isEmpty()) {
            player.method_6092(instance);
        }
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        SkillsRecordScreen screen;
        class_437 class_4372;
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (!(class_310.method_1551().field_1755 instanceof SkillsRecordScreen) && this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        if (this.getType() == Type.EMPTY) {
            class_5250 component = class_2561.method_43471((String)"tooltip.ultimine_addition.skill_card.info.empty").method_27692(class_124.field_1080);
            List components = ScreenUtils.splitComponent((class_2561)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
            return;
        }
        class_5250 component = class_2561.method_43469((String)"tooltip.ultimine_addition.skill_card.tier", (Object[])new Object[]{!stack.method_7985() ? class_2561.method_43470((String)"\u00a7kNawaf") : this.getData(stack).getTier().getDisplayName()});
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1063).method_10852((class_2561)component.method_27692(class_124.field_1080)));
        if (stack.method_7985() && this.type != Type.EMPTY && this.getData(stack).getTier() != Tier.Unlearned && this.getData(stack).getTier() != Tier.Mastered) {
            class_124 formatting = ChatFormattingUtils.get3ColorPercentageFormat(this.getData(stack).getPotionPoints(), this.getData(stack).getMaxPotionPoints());
            component = class_2561.method_43469((String)"tooltip.ultimine_addition.skill_card.potion_point", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.getData(stack).getPotionPoints())).method_27692(formatting)});
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1063).method_10852((class_2561)component.method_27692(class_124.field_1080)));
        }
        if ((class_4372 = class_310.method_1551().field_1755) instanceof SkillsRecordScreen && ((SkillsRecordMenu)(screen = (SkillsRecordScreen)class_4372).method_17577()).getCardSlots().stream().anyMatch(slot -> slot.method_7677().equals(stack))) {
            return;
        }
        if (this.getData(stack).getTier() != Tier.Mastered) {
            component = class_2561.method_43471((String)"tooltip.ultimine_addition.skill_card.info").method_27692(class_124.field_1068);
            List components = ScreenUtils.splitComponent((class_2561)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
        }
    }

    public boolean method_31567(class_1799 itemStack) {
        MiningSkillCardData data = this.getData(itemStack);
        if (!itemStack.method_7985() || this.type == Type.EMPTY || data.getTier() == Tier.Unlearned || data.getTier() == Tier.Mastered) {
            return false;
        }
        return !data.isPotionPointsFull();
    }

    public int method_31569(class_1799 itemStack) {
        MiningSkillCardData data = this.getData(itemStack);
        return Math.round((float)data.getPotionPoints() / (float)data.getMaxPotionPoints() * 13.0f);
    }

    public int method_31571(class_1799 itemStack) {
        return class_3532.method_15369((float)(Math.max(0.0f, (float)this.method_31569(itemStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public UAItemRenderer createItemRenderer() {
        return ItemRendererHandler.MiningSkillCardRenderer();
    }

    @Override
    public MiningSkillCardData getData(class_1799 stack) {
        return new MiningSkillCardData().loadData(stack);
    }

    public Type getType() {
        return this.type;
    }

    public static boolean isTierEqual(class_1799 stack, Tier tier) {
        return new MiningSkillCardData().loadData(stack).getTier() == tier;
    }

    public static class Type {
        public static final Type EMPTY = new Type(true, "empty", List.of(), class_1802.field_8077);
        public static final Type PICKAXE = new Type(true, "pickaxe", List.of(), class_1802.field_22024);
        public static final Type AXE = new Type(true, "axe", List.of(), class_1802.field_22025);
        public static final Type SHOVEL = new Type(true, "shovel", List.of(), class_1802.field_22023);
        public static final Type HOE = new Type(true, "hoe", List.of(), class_1802.field_22026);
        public static List<Type> TYPES = new ArrayList<Type>();
        private final boolean active;
        private final String id;
        private final List<String> requiredTools;
        private final Color potionColor;
        private final class_1792 defaultDisplayItem;
        public static final Codec<Type> CODEC = Codec.STRING.comapFlatMap(s -> {
            try {
                return DataResult.success((Object)Type.fromString(s));
            }
            catch (CodecException e) {
                return DataResult.error(() -> s + " is not present.");
            }
        }, Type::getId);
        public static final Codec<Type> CARD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("active").forGetter(Type::isActive), (App)Codec.STRING.fieldOf("card_id").forGetter(Type::getId), (App)Codec.STRING.listOf().fieldOf("required_tools").forGetter(Type::getRequiredTools), (App)CodecHelper.COLOR_CODEC.optionalFieldOf("potion_color", (Object)Color.WHITE).forGetter(Type::getPotionColor), (App)CodecHelper.ITEM_CODEC.optionalFieldOf("default_display_item", (Object)class_1802.field_8077).forGetter(Type::getDefaultDisplayItem)).apply((Applicative)instance, Type::new));

        public Type(boolean active, String id, List<String> requiredTools) {
            this(active, id, requiredTools, Color.WHITE, class_1802.field_8077);
        }

        public Type(boolean active, String id, List<String> requiredTools, class_1792 defaultDisplayItem) {
            this(active, id, requiredTools, Color.WHITE, defaultDisplayItem);
        }

        public Type(boolean active, String id, List<String> requiredTools, Color potionColor, class_1792 defaultDisplayItem) {
            this.active = active;
            this.id = this.validateId(id);
            this.requiredTools = requiredTools;
            this.potionColor = potionColor;
            this.defaultDisplayItem = defaultDisplayItem;
        }

        private String validateId(String input) {
            String pattern = "^[a-z0-9_.-]+$";
            if (!input.matches(pattern)) {
                throw new IllegalArgumentException("Invalid Custom Card Id format! Non [a-z0-9_.-] character exists. (\"%s\")".formatted(input));
            }
            return input;
        }

        public static void refreshTypes() {
            TYPES = new ArrayList<Type>(List.of(EMPTY, PICKAXE, AXE, SHOVEL, HOE));
            TYPES.addAll(CustomMSCApi.CUSTOM_TYPES);
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getRequiredTools() {
            return this.requiredTools;
        }

        public Color getPotionColor() {
            return this.potionColor;
        }

        public class_1792 getDefaultDisplayItem() {
            return this.defaultDisplayItem;
        }

        public static Type fromString(String input) {
            for (Type type : TYPES) {
                if (!type.getId().equalsIgnoreCase(input) || input.equalsIgnoreCase(EMPTY.getId())) continue;
                return type;
            }
            throw new IllegalArgumentException("No type with the specified name");
        }

        public boolean isCustomType() {
            return TYPES.stream().filter(t -> !t.equals(EMPTY) && !t.equals(PICKAXE) && !t.equals(AXE) && !t.equals(SHOVEL) && !t.equals(HOE)).toList().contains(this);
        }

        public List<class_1792> utilizeRequiredTools() {
            ArrayList<class_1792> list = new ArrayList<class_1792>();
            if (this.requiredTools == null) {
                return list;
            }
            for (String value : this.requiredTools) {
                if (value.startsWith("#")) {
                    ArrayList items = new ArrayList();
                    class_7923.field_41178.method_40266(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(value.replaceAll("#", "")))).ifPresent(holders -> items.addAll(holders.method_40239().map(class_6880::comp_349).toList()));
                    if (items.isEmpty()) continue;
                    list.addAll(items);
                    continue;
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(value));
                if (item == class_1802.field_8162) continue;
                list.add(item);
            }
            return list;
        }
    }

    public static enum Tier {
        Unlearned(0),
        Novice(1),
        Apprentice(2),
        Adept(3),
        Mastered(4);

        private final int tier;
        public static final Codec<Tier> CODEC;

        private Tier(int tier) {
            this.tier = tier;
        }

        public boolean isEligible(Tier tier) {
            return tier.getValue() >= this.tier;
        }

        public int getValue() {
            return this.tier;
        }

        public class_5250 getDisplayName() {
            return switch (this.tier) {
                case 1 -> class_2561.method_43471((String)this.descriptionId()).method_27692(class_124.field_1060);
                case 2 -> class_2561.method_43471((String)this.descriptionId()).method_27692(class_124.field_1075);
                case 3 -> class_2561.method_43471((String)this.descriptionId()).method_27692(class_124.field_1076);
                case 4 -> class_2561.method_43471((String)this.descriptionId()).method_27692(class_124.field_1065);
                default -> class_2561.method_43471((String)this.descriptionId());
            };
        }

        private String descriptionId() {
            return String.format("tooltip.ultimine_addition.skill_card.tier.%s", this.name().toLowerCase());
        }

        public Tier next() {
            int nextIndex = (this.ordinal() + 1) % Tier.values().length;
            return Tier.values()[nextIndex];
        }

        public Tier previous() {
            int prevIndex = (this.ordinal() - 1 + Tier.values().length) % Tier.values().length;
            return Tier.values()[prevIndex];
        }

        public static String[] getNames() {
            String[] enumNames = new String[Tier.values().length];
            for (int i = 0; i < enumNames.length; ++i) {
                enumNames[i] = Tier.values()[i].name().toLowerCase();
            }
            return enumNames;
        }

        public static Tier fromString(String input) {
            for (Tier enumValue : Tier.values()) {
                if (!enumValue.name().equalsIgnoreCase(input)) continue;
                return enumValue;
            }
            return null;
        }

        public static Tier fromInt(int input) {
            for (Tier enumValue : Tier.values()) {
                if (enumValue.getValue() != input) continue;
                return enumValue;
            }
            throw new RuntimeException("There is no tier enum with value: " + input);
        }

        static {
            CODEC = Codec.INT.comapFlatMap(i -> {
                try {
                    return DataResult.success((Object)((Object)Tier.fromInt(i)));
                }
                catch (EnumConstantNotPresentException e) {
                    return DataResult.success((Object)((Object)Unlearned));
                }
            }, Tier::getValue);
        }
    }
}

