/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.challenge.IneligibleBlocksSavedData;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.common.tag.ModBlockTags;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SkillsRecordData
extends DataHandler<SkillsRecordData, class_1799> {
    private class_1799 stack;
    @Nullable
    private UUID uuid;
    private class_1263 container;
    private byte viewingCard;
    private boolean consumeMode;
    private final Map<Integer, List<class_2960>> pinnedChallenges = new TreeMap<Integer, List<class_2960>>();

    public Pair<Boolean, Boolean> initTaskValidator(class_2680 state, class_2338 pos, class_1657 player, ChallengesData.Type challengeType) {
        boolean b1 = false;
        boolean b2 = false;
        for (int i = 0; i < this.getCardSlots().size(); ++i) {
            class_1799 stack = (class_1799)this.getCardSlots().get(i);
            if (stack == class_1799.field_8037) continue;
            Pair<Boolean, Boolean> pair = this.validateTask(stack, state, pos, player, challengeType);
            if (((Boolean)pair.getFirst()).booleanValue()) {
                b1 = true;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) continue;
            b2 = true;
        }
        return Pair.of((Object)b1, (Object)b2);
    }

    private Pair<Boolean, Boolean> validateTask(class_1799 stack, class_2680 state, class_2338 pos, class_1657 player, ChallengesData.Type challengeType) {
        AtomicReference<Pair> isConsumed = new AtomicReference<Pair>(Pair.of((Object)false, (Object)false));
        try {
            AtomicInteger i = new AtomicInteger();
            MiningSkillCardData cardData = (MiningSkillCardData)new MiningSkillCardData().loadData(stack).sendToClient((class_3222)player);
            cardData.getChallenges().forEach((identifier, values) -> {
                if (i.get() == 0) {
                    boolean isBlockPlacedByEntity;
                    IneligibleBlocksSavedData savedData = IneligibleBlocksSavedData.getOrCreate((class_3218)player.method_37908());
                    ChallengesData challengeData = ChallengesManager.INSTANCE.getAllChallenges().get(identifier.id());
                    List<class_2248> blocks = ChallengesManager.INSTANCE.utilizeTargetedBlocks(challengeData);
                    int inkChamber = this.getPenSlot().method_7909() instanceof PenItem ? ((PenItem)((class_1799)this.getAllSlots().get(4)).method_7909()).getData((class_1799)this.getAllSlots().get(4)).getCapacity() : 0;
                    boolean hasCorrectGamemode = !player.method_7337() && !player.method_7325();
                    boolean isMissingRequiredItems = hasCorrectGamemode && (((class_1799)this.getAllSlots().get(4)).method_7960() || ((class_1799)this.getAllSlots().get(5)).method_7960());
                    boolean notEnoughInk = hasCorrectGamemode && inkChamber == 0;
                    boolean isChallengeAccomplished = cardData.isChallengeAccomplished(identifier.id());
                    boolean isCorrectAction = challengeData.getChallengeType().equals((Object)challengeType) || challengeData.getChallengeType().equals((Object)challengeType.getConsumeVersion());
                    boolean isValidBlock = blocks.contains(state.method_26204());
                    boolean isCorrectTool = !hasCorrectGamemode || ChallengesManager.INSTANCE.isCorrectTool(player, challengeData);
                    boolean bl = isBlockPlacedByEntity = (Boolean)ConfigHandler.COMMON.IS_PLACED_BY_ENTITY_CONDITION.get() != false && hasCorrectGamemode && !state.method_26164(ModBlockTags.DENY_IS_PLACED_BY_ENTITY) && savedData.isBlockPlacedByEntity(pos);
                    if (((Boolean)ConfigHandler.COMMON.CHALLENGE_ACTIONS_LOGGER.get()).booleanValue()) {
                        ChallengesManager.LOGGER.debug("/===========================================/");
                        ChallengesManager.LOGGER.debug("Challenge: {}", (Object)identifier.id());
                        ChallengesManager.LOGGER.debug("hasCorrectGamemode: {}", (Object)hasCorrectGamemode);
                        ChallengesManager.LOGGER.debug("isMissingRequiredItems: {}", (Object)isMissingRequiredItems);
                        ChallengesManager.LOGGER.debug("notEnoughInk: {}", (Object)notEnoughInk);
                        ChallengesManager.LOGGER.debug("isChallengeAccomplished: {}", (Object)isChallengeAccomplished);
                        ChallengesManager.LOGGER.debug("isCorrectAction: {}", (Object)isCorrectAction);
                        ChallengesManager.LOGGER.debug("isValidBlock: {}", (Object)isValidBlock);
                        ChallengesManager.LOGGER.debug("isCorrectTool: {}", (Object)isCorrectTool);
                        ChallengesManager.LOGGER.debug("isBlockPlacedByEntity: {}", (Object)isBlockPlacedByEntity);
                        ChallengesManager.LOGGER.debug("/===========================================/");
                    }
                    if (!isMissingRequiredItems && !notEnoughInk && !isChallengeAccomplished && isCorrectAction && isValidBlock && isCorrectTool && isBlockPlacedByEntity) {
                        savedData.getChunkEntries().forEach((chunkPos, chunkEntries) -> {
                            List<IneligibleBlocksSavedData.BlockEntry> list = chunkEntries.stream().filter(blockEntry -> !blockEntry.placedBlocks().stream().filter(blockInfo -> blockInfo.pos.equals((Object)pos)).toList().isEmpty()).toList();
                            if (!list.isEmpty()) {
                                IneligibleBlocksSavedData.BlockEntry blockEntry2 = list.get(0);
                                class_5250 component = class_2561.method_43470((String)"[").method_10852((class_2561)SkillsRecordItem.TITLE.method_27661().method_27692(class_124.field_1054)).method_27693("] ").method_27692(class_124.field_1080);
                                class_5250 info = class_2561.method_43469((String)"info.ultimine_addition.placed_by_entity", (Object[])new Object[]{class_2561.method_43471((String)"entity.%s.%s".formatted(blockEntry2.entityId().method_12836(), blockEntry2.entityId().method_12832()))}).method_27692(class_124.field_1061);
                                player.method_7353((class_2561)component.method_10852((class_2561)info), true);
                            }
                        });
                    }
                    if (!isMissingRequiredItems && !notEnoughInk && !isChallengeAccomplished && isCorrectAction && isValidBlock && isCorrectTool && !isBlockPlacedByEntity) {
                        if (challengeData.getChallengeType().isConsuming()) {
                            if (this.consumeMode) {
                                cardData.addAmount(identifier.id(), 1).saveData(stack);
                                if (hasCorrectGamemode) {
                                    this.consumeContents((class_3222)player);
                                }
                                isConsumed.set(Pair.of((Object)true, (Object)true));
                                player.method_37908().method_8651(pos, false, (class_1297)player);
                            }
                        } else {
                            cardData.addAmount(identifier.id(), 1).saveData(stack);
                            if (hasCorrectGamemode) {
                                this.consumeContents((class_3222)player);
                            }
                            isConsumed.set(Pair.of((Object)true, (Object)false));
                        }
                        i.getAndIncrement();
                    }
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return isConsumed.get();
    }

    public SkillsRecordData togglePinned(int slot, class_2960 challengeId) {
        class_1799 itemStack;
        MiningSkillCardData data;
        MiningSkillCardData.InfoData infoData;
        if (this.pinnedChallenges.containsKey(slot)) {
            if (!this.pinnedChallenges.get(slot).contains(challengeId)) {
                this.pinnedChallenges.get(slot).add(challengeId);
            }
        } else {
            this.pinnedChallenges.put(slot, new ArrayList<class_2960>(List.of(challengeId)));
        }
        if ((infoData = (data = new MiningSkillCardData().loadData(itemStack = (class_1799)this.getCardSlots().get(slot))).getChallenge(challengeId)) != null) {
            infoData.togglePinned();
            data.saveData(itemStack);
        }
        return this;
    }

    private void consumeContents(class_3222 player) {
        class_1799 pen = this.getPenSlot();
        class_1799 paper = this.getPaperSlot();
        class_1792 class_17922 = pen.method_7909();
        if (class_17922 instanceof PenItem) {
            PenItem item = (PenItem)class_17922;
            ((ItemStorageData)item.getData(pen).sendToClient(player)).removeAmount(1).saveData(pen);
        }
        if (paper.method_7909() == class_1802.field_8407) {
            boolean chance = ThreadLocalRandom.current().nextDouble() < (Double)ConfigHandler.COMMON.PAPER_CONSUMPTION_RATE.get();
            paper.method_7934(chance ? 1 : 0);
        }
    }

    public class_2371<class_1799> getCardSlots() {
        class_2371 items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        for (int i = 0; i < items.size(); ++i) {
            if (!(this.container.method_5438(i).method_7909() instanceof MiningSkillCardItem)) continue;
            items.set(i, (Object)this.container.method_5438(i));
        }
        return items;
    }

    public class_2371<class_1799> getAllSlots() {
        class_2371 items = class_2371.method_10213((int)this.container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < items.size(); ++i) {
            if (this.container.method_5438(i) == class_1799.field_8037) continue;
            items.set(i, (Object)this.container.method_5438(i));
        }
        return items;
    }

    public class_1799 getPenSlot() {
        return (class_1799)this.getAllSlots().get(4);
    }

    private class_1799 getPaperSlot() {
        return (class_1799)this.getAllSlots().get(5);
    }

    public boolean isConsumeMode() {
        return this.consumeMode;
    }

    public byte getViewingCard() {
        return this.viewingCard;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    @Override
    public class_1799 get() {
        return this.stack;
    }

    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public SkillsRecordData insertContainer(class_1263 container) {
        this.container = container;
        return this;
    }

    public SkillsRecordData setViewingCard(int selectedSlot) {
        this.viewingCard = (byte)selectedSlot;
        return this;
    }

    public SkillsRecordData toggleConsumeMode() {
        this.consumeMode ^= true;
        return this;
    }

    @Override
    public void saveData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        NBT.method_25927("UUID", this.uuid == null ? UUID.randomUUID() : this.uuid);
        NBT.method_10543(SkillsRecordData.getNBTFromContainer(this.container));
        NBT.method_10567("ViewingCard", this.viewingCard);
        NBT.method_10556("ConsumeMode", this.consumeMode);
        stack.method_7948().method_10566(this.NBTBase, (class_2520)NBT);
        super.saveData(stack);
    }

    public SkillsRecordData syncData(class_3222 player) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof SkillsRecordMenu) {
            SkillsRecordMenu skillsRecordMenu = (SkillsRecordMenu)class_17032;
            this.pinnedChallenges.forEach((slot, challengeList) -> {
                class_1799 cardStack = ((class_1735)skillsRecordMenu.getCardSlots().get(slot.intValue())).method_7677();
                MiningSkillCardData cardData = new MiningSkillCardData().loadData(cardStack);
                challengeList.forEach(location -> {
                    MiningSkillCardData.InfoData infoData = cardData.getChallenge((class_2960)location);
                    if (infoData != null) {
                        infoData.togglePinned();
                        cardData.saveData(cardStack);
                    }
                });
            });
        }
        return this;
    }

    public SkillsRecordData loadData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        this.uuid = NBT.method_10545("UUID") ? NBT.method_25926("UUID") : null;
        this.container = SkillsRecordData.getContainerFromNBT(NBT);
        this.viewingCard = (byte)(NBT.method_10545("ViewingCard") ? (int)NBT.method_10571("ViewingCard") : -1);
        this.consumeMode = NBT.method_10577("ConsumeMode");
        this.stack = stack;
        return this;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10793(this.stack);
        buf.writeByte((int)this.viewingCard);
        buf.writeBoolean(this.consumeMode);
        this.encodePinnedChallenges(buf);
    }

    public static SkillsRecordData fromNetwork(class_2540 buf) {
        return new SkillsRecordData().loadData(buf.method_10819()).setViewingCard(buf.readByte()).setConsumeMode(buf.readBoolean()).decodePinnedChallenges(buf);
    }

    private void encodePinnedChallenges(class_2540 buf) {
        buf.method_34063(this.pinnedChallenges, class_2540::writeInt, (buffer, locationList) -> buffer.method_34062((Collection)locationList, class_2540::method_10812));
    }

    private SkillsRecordData decodePinnedChallenges(class_2540 buf) {
        this.pinnedChallenges.putAll(buf.method_34067(class_2540::readInt, buffer -> buffer.method_34066(class_2540::method_10810)));
        return this;
    }

    private SkillsRecordData setConsumeMode(boolean consumeMode) {
        this.consumeMode = consumeMode;
        return this;
    }

    private static class_2487 getNBTFromContainer(class_1263 container) {
        class_2499 listTag = new class_2499();
        for (int i = 0; i < container.method_5439() && !container.method_5442(); ++i) {
            class_1799 itemStack = container.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10567("Slot", (byte)i);
            itemStack.method_7953(tag);
            listTag.add((Object)tag);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("Contents", (class_2520)listTag);
        return tag;
    }

    private static class_1263 getContainerFromNBT(class_2487 NBT) {
        class_1277 container = new class_1277(6);
        class_2499 listTag = new class_2499();
        if (NBT != null) {
            listTag = NBT.method_10554("Contents", 10);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            if (j >= container.method_5439()) continue;
            container.method_5447(j, class_1799.method_7915((class_2487)compoundTag));
        }
        return container;
    }
}

