/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.ixdarklord.ultimine_addition.client.handler.ToastHandler;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiningSkillCardData
extends DataHandler<MiningSkillCardData, class_1799> {
    private class_1799 stack;
    private class_1799 displayItem;
    private Map<Identifier, InfoData> currentChallenges = new TreeMap<Identifier, InfoData>();
    private final List<Identifier> finishedChallenges = new ArrayList<Identifier>();
    private MiningSkillCardItem.Tier tier = MiningSkillCardItem.Tier.Unlearned;
    private int potionPoints;

    public MiningSkillCardData initChallenges() {
        if (this.tier == MiningSkillCardItem.Tier.Mastered) {
            this.currentChallenges.clear();
            return this;
        }
        AtomicInteger slotId = new AtomicInteger(1);
        AtomicInteger quantity = new AtomicInteger();
        MiningSkillCardItem.Type type = ((MiningSkillCardItem)this.stack.method_7909()).getType();
        switch (this.tier) {
            case Unlearned: {
                quantity.set((Integer)ConfigHandler.COMMON.TIER_0_CHALLENGES_AMOUNT.get());
                break;
            }
            case Novice: {
                quantity.set((Integer)ConfigHandler.COMMON.TIER_1_CHALLENGES_AMOUNT.get());
                break;
            }
            case Apprentice: {
                quantity.set((Integer)ConfigHandler.COMMON.TIER_2_CHALLENGES_AMOUNT.get());
                break;
            }
            case Adept: {
                quantity.set((Integer)ConfigHandler.COMMON.TIER_3_CHALLENGES_AMOUNT.get());
            }
        }
        if (this.tier != MiningSkillCardItem.Tier.Unlearned && this.tier != MiningSkillCardItem.Tier.Mastered) {
            this.setPotionPoints(this.getMaxPotionPoints());
        }
        this.currentChallenges.clear();
        ChallengesManager.INSTANCE.getRandomChallenges(quantity.get(), type, this.tier).forEach((location, data) -> {
            this.currentChallenges.put(new Identifier(slotId.get(), (class_2960)location), new InfoData(data.getRequiredAmount()));
            slotId.getAndIncrement();
        });
        return this;
    }

    public MiningSkillCardData validateChallenges() {
        if (this.tier == MiningSkillCardItem.Tier.Mastered) {
            return this;
        }
        MiningSkillCardItem.Type type = ((MiningSkillCardItem)this.stack.method_7909()).getType();
        if (!this.currentChallenges.isEmpty()) {
            HashSet removedChallenges = new HashSet();
            this.currentChallenges.forEach((identifier, infoData) -> {
                if (!ChallengesManager.INSTANCE.getAllChallenges().containsKey(identifier.id)) {
                    removedChallenges.add(identifier);
                }
            });
            removedChallenges.forEach(identifier -> {
                AtomicBoolean isDone = new AtomicBoolean(true);
                this.currentChallenges.remove(identifier);
                do {
                    ChallengesManager.INSTANCE.getRandomChallenges(1, type, this.tier).forEach((location, data) -> {
                        if (this.currentChallenges.keySet().stream().filter(identifier1 -> identifier1.id.equals(location)).toList().isEmpty()) {
                            this.currentChallenges.put(new Identifier(identifier.order, (class_2960)location), new InfoData(data.getRequiredAmount()));
                            if (((Boolean)ConfigHandler.COMMON.CHALLENGE_MANAGER_LOGGER.get()).booleanValue() || Platform.isDevelopmentEnvironment()) {
                                ChallengesManager.LOGGER.info("Changed the challenge from: id:\"{}\" to: id:\"{}\"", (Object)identifier.id, location);
                            }
                            isDone.set(false);
                        }
                    });
                } while (isDone.get());
            });
        } else {
            this.initChallenges();
        }
        return this;
    }

    public MiningSkillCardData setDisplayTool(class_1799 stack) {
        this.displayItem = stack;
        return this;
    }

    public MiningSkillCardData setAmount(class_2960 challengeId, int value) {
        InfoData infoData = this.getChallenge(challengeId);
        if (infoData == null) {
            return this;
        }
        int requiredAmount = infoData.requiredValue;
        infoData.setCurrentValue(Math.min(value, requiredAmount));
        this.checkChallengeAccomplishment(challengeId, this.getChallenge(challengeId));
        if (this.isAllChallengesCompleted()) {
            this.tier = this.tier.next();
            this.initChallenges();
            this.finishedChallenges.add(new Identifier(0, new class_2960("completed")));
        } else {
            this.checkChallengeAccomplishment(challengeId, this.getChallenge(challengeId));
        }
        return this;
    }

    public MiningSkillCardData addAmount(class_2960 challengeId, int value) {
        InfoData infoData = this.getChallenge(challengeId);
        if (infoData == null) {
            return this;
        }
        int currentAmount = infoData.currentValue;
        int requiredAmount = infoData.requiredValue;
        if (currentAmount >= requiredAmount) {
            return this;
        }
        infoData.setCurrentValue(Math.min(currentAmount + value, requiredAmount));
        if (this.isAllChallengesCompleted()) {
            this.tier = this.tier.next();
            this.initChallenges();
            this.finishedChallenges.add(new Identifier(0, new class_2960("completed")));
        } else {
            this.checkChallengeAccomplishment(challengeId, this.getChallenge(challengeId));
        }
        return this;
    }

    public MiningSkillCardData accomplishChallenge(class_2960 challengeId) {
        InfoData infoData = this.getChallenge(challengeId);
        if (infoData == null) {
            return this;
        }
        int requiredAmount = infoData.requiredValue;
        infoData.setCurrentValue(requiredAmount);
        if (this.isAllChallengesCompleted()) {
            this.tier = this.tier.next();
            this.initChallenges();
            this.finishedChallenges.add(new Identifier(0, new class_2960("completed")));
        } else {
            this.checkChallengeAccomplishment(challengeId, this.getChallenge(challengeId));
        }
        return this;
    }

    public MiningSkillCardData setChallenges(Map<Identifier, InfoData> map) {
        this.currentChallenges = map;
        return this;
    }

    public void setPotionPoints(int value) {
        this.potionPoints = value;
    }

    public MiningSkillCardData consumePotionPoint(int value) {
        this.potionPoints = Math.max(0, this.potionPoints - value);
        return this;
    }

    public MiningSkillCardData setTier(MiningSkillCardItem.Tier tier) {
        this.tier = tier;
        return this;
    }

    public boolean isChallengeAccomplished(class_2960 challengeId) {
        InfoData infoData = this.getChallenge(challengeId);
        if (infoData == null || !this.isChallengeExists(challengeId)) {
            return false;
        }
        return infoData.currentValue >= infoData.requiredValue;
    }

    private boolean isAllChallengesCompleted() {
        AtomicInteger allCurrentValues = new AtomicInteger();
        AtomicInteger allRequiredValues = new AtomicInteger();
        this.currentChallenges.forEach((identifier, infoData) -> {
            allCurrentValues.addAndGet(infoData.currentValue);
            allRequiredValues.addAndGet(infoData.requiredValue);
        });
        return allCurrentValues.get() >= allRequiredValues.get();
    }

    @Override
    public class_1799 get() {
        return this.stack;
    }

    public class_1799 getDisplayItem() {
        if (this.displayItem.method_7960()) {
            MiningSkillCardItem.Type type = ((MiningSkillCardItem)this.stack.method_7909()).getType();
            return type.getDefaultDisplayItem().method_7854();
        }
        return this.displayItem;
    }

    @Nullable
    public InfoData getChallenge(class_2960 challengeId) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.currentChallenges.forEach((identifier, infoData) -> {
            if (identifier.id.equals((Object)challengeId)) {
                result.set(infoData);
            }
        });
        return result.get();
    }

    public Map<Identifier, InfoData> getChallenges() {
        return this.currentChallenges;
    }

    public boolean isChallengeExists(class_2960 challengeId) {
        AtomicBoolean result = new AtomicBoolean();
        this.currentChallenges.forEach((identifier, integers) -> {
            if (identifier.id.equals((Object)challengeId)) {
                result.set(true);
            }
        });
        return result.get();
    }

    public MiningSkillCardItem.Tier getTier() {
        return this.tier;
    }

    public boolean isPotionPointsFull() {
        return this.potionPoints >= this.getMaxPotionPoints();
    }

    public int getPotionPoints() {
        return this.potionPoints;
    }

    public int getMaxPotionPoints() {
        return switch (this.tier) {
            case MiningSkillCardItem.Tier.Novice -> (Integer)ConfigHandler.COMMON.TIER_1_POTION_POINTS.get();
            case MiningSkillCardItem.Tier.Apprentice -> (Integer)ConfigHandler.COMMON.TIER_2_POTION_POINTS.get();
            case MiningSkillCardItem.Tier.Adept -> (Integer)ConfigHandler.COMMON.TIER_3_POTION_POINTS.get();
            default -> 0;
        };
    }

    public void clientUpdate() {
        this.finishedChallenges.forEach(identifier -> ToastHandler.playChallengeToast(identifier, this.stack));
    }

    @Override
    public void saveData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        if (this.displayItem != null) {
            NBT.method_10582("DisplayItem", UltimineAddition.getIdAsString(Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)this.displayItem.method_7909()))));
        }
        NBT.method_10569("Tier", this.tier.getValue());
        NBT.method_10569("PotionPoint", this.potionPoints);
        NBT.method_10543(MiningSkillCardData.getNBTFromChallenges(this.currentChallenges));
        stack.method_7948().method_10566(this.NBTBase, (class_2520)NBT);
        super.saveData(stack);
    }

    public MiningSkillCardData loadData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        this.displayItem = Objects.requireNonNull((class_1792)Registration.ITEMS.getRegistrar().get(new class_2960(NBT.method_10558("DisplayItem")))).method_7854();
        this.tier = MiningSkillCardData.getTierFromInt(NBT.method_10550("Tier"));
        this.potionPoints = NBT.method_10550("PotionPoint");
        this.currentChallenges = MiningSkillCardData.getChallengesFromNBT(NBT);
        this.stack = stack;
        return this;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10793(this.stack);
        this.encodeFinishedChallenges(buf);
    }

    public static MiningSkillCardData fromNetwork(class_2540 buf) {
        return new MiningSkillCardData().loadData(buf.method_10819()).decodeFinishedChallenges(buf);
    }

    private void encodeFinishedChallenges(class_2540 buf) {
        buf.method_34062(this.finishedChallenges, (buffer, identifier) -> {
            buffer.writeInt(identifier.order);
            buffer.method_10812(identifier.id);
        });
    }

    private MiningSkillCardData decodeFinishedChallenges(class_2540 buf) {
        this.finishedChallenges.addAll(buf.method_34066(buffer -> new Identifier(buffer.readInt(), buffer.method_10810())));
        return this;
    }

    private static MiningSkillCardItem.Tier getTierFromInt(int value) {
        return MiningSkillCardItem.Tier.fromInt(value);
    }

    private static class_2487 getNBTFromChallenges(Map<Identifier, InfoData> value) {
        class_2499 listTag = new class_2499();
        value.forEach((identifier, infoData) -> {
            class_2487 tag = new class_2487();
            tag.method_10569("Order", identifier.order);
            tag.method_10582("Id", identifier.id.toString());
            tag.method_10556("IsPinned", infoData.isPinned);
            tag.method_10569("CurrentAmount", infoData.currentValue);
            tag.method_10569("RequiredAmount", infoData.requiredValue);
            listTag.add((Object)tag);
        });
        class_2487 tag = new class_2487();
        tag.method_10566("Challenges", (class_2520)listTag);
        return tag;
    }

    private static Map<Identifier, InfoData> getChallengesFromNBT(class_2487 NBT) {
        TreeMap<Identifier, InfoData> result = new TreeMap<Identifier, InfoData>();
        class_2499 listTag = new class_2499();
        if (NBT != null) {
            listTag = NBT.method_10554("Challenges", 10);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 tag = listTag.method_10602(i);
            int order = tag.method_10550("Order");
            class_2960 id = new class_2960(tag.method_10558("Id"));
            boolean pinned = tag.method_10577("IsPinned");
            int current = tag.method_10550("CurrentAmount");
            int required = tag.method_10550("RequiredAmount");
            result.put(new Identifier(order, id), new InfoData(pinned, current, required));
        }
        return result;
    }

    private void checkChallengeAccomplishment(class_2960 challengeId, InfoData infoData) {
        AtomicReference identifier = new AtomicReference();
        this.currentChallenges.forEach((i, integers) -> {
            if (i.id.equals((Object)challengeId)) {
                identifier.set(i);
            }
        });
        if (identifier.get() == null) {
            return;
        }
        if (infoData.currentValue >= infoData.requiredValue && !this.finishedChallenges.contains(identifier.get())) {
            this.finishedChallenges.add((Identifier)identifier.get());
        }
    }

    public static class InfoData {
        private boolean isPinned;
        private int currentValue;
        private final int requiredValue;

        public InfoData(int requiredValue) {
            this(0, requiredValue);
        }

        public InfoData(int currentValue, int requiredValue) {
            this(false, currentValue, requiredValue);
        }

        public InfoData(boolean isPinned, int currentValue, int requiredValue) {
            this.isPinned = isPinned;
            this.currentValue = currentValue;
            this.requiredValue = requiredValue;
        }

        public void togglePinned() {
            this.isPinned ^= true;
        }

        public void setCurrentValue(int currentValue) {
            this.currentValue = currentValue;
        }

        public boolean isPinned() {
            return this.isPinned;
        }

        public int getCurrentValue() {
            return this.currentValue;
        }

        public int getRequiredValue() {
            return this.requiredValue;
        }
    }

    public record Identifier(int order, class_2960 id) implements Comparable<Identifier>
    {
        @Override
        public int compareTo(@NotNull Identifier other) {
            return Integer.compare(this.order, other.order);
        }
    }
}

