/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import java.util.List;
import net.ixdarklord.ultimine_addition.client.handler.ClientMinerCertificateHandler;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.item.MinerCertificateItem;
import net.ixdarklord.ultimine_addition.util.ChatFormattingUtils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class MinerCertificateData
extends DataHandler<MinerCertificateData, class_1799> {
    private class_1799 stack;
    @Nullable
    private Legacy legacy;
    private boolean isAccomplished;
    private boolean isCelebration;
    private boolean completeSound;

    public void tick() {
        if (this.legacy != null) {
            if (this.legacy.getRequiredAmount() == 0) {
                int min = (Integer)ConfigHandler.COMMON.LEGACY_REQUIRED_AMOUNT_MIN.get();
                int max = (Integer)ConfigHandler.COMMON.LEGACY_REQUIRED_AMOUNT_MAX.get();
                int value = class_5819.method_43047().method_39332(min, max);
                this.legacy.setRequiredAmount(value);
                this.saveData(this.stack);
            } else if (!this.isAccomplished && this.legacy.getMinedBlocks() == this.legacy.getRequiredAmount()) {
                this.completeSound(true).setAccomplished(true).saveData(this.stack);
            }
        } else if (!this.isAccomplished) {
            this.completeSound(true).setAccomplished(true).saveData(this.stack);
        }
    }

    @Override
    public class_1799 get() {
        return this.stack;
    }

    @Nullable
    public Legacy getLegacy() {
        return this.legacy;
    }

    public boolean isAccomplished() {
        return this.isAccomplished;
    }

    public MinerCertificateData setAccomplished(boolean state) {
        this.isAccomplished = state;
        return this;
    }

    public MinerCertificateData createCelebration(boolean state) {
        this.isCelebration = state;
        return this;
    }

    public MinerCertificateData completeSound(boolean state) {
        this.completeSound = state;
        return this;
    }

    public void clientUpdate() {
        if (this.stack.method_7909() instanceof MinerCertificateItem && this.completeSound) {
            ClientMinerCertificateHandler.playClientSound();
        }
        if (this.stack.method_7909() instanceof MinerCertificateItem && this.isCelebration) {
            ClientMinerCertificateHandler.sendClientMessage();
            ClientMinerCertificateHandler.playAnimation(this.stack);
        }
    }

    @Override
    public void saveData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        if (this.legacy != null) {
            NBT.method_10566("legacy", (class_2520)this.legacy.save());
        }
        NBT.method_10556("is_accomplished", this.isAccomplished);
        stack.method_7948().method_10566(this.NBTBase, (class_2520)NBT);
        super.saveData(stack);
    }

    public MinerCertificateData loadData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE_SAFE.get() == PlaystyleMode.LEGACY) {
            this.legacy = new Legacy().load(this, NBT.method_10562("legacy"));
        }
        this.isAccomplished = NBT.method_10577("is_accomplished");
        this.stack = stack;
        return this;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10793(this.stack);
        buf.writeBoolean(this.completeSound);
        buf.writeBoolean(this.isAccomplished);
        buf.writeBoolean(this.isCelebration);
    }

    public static MinerCertificateData fromNetwork(class_2540 buf) {
        return new MinerCertificateData().loadData(buf.method_10819()).completeSound(buf.readBoolean()).setAccomplished(buf.readBoolean()).createCelebration(buf.readBoolean());
    }

    public static class Legacy {
        private MinerCertificateData data;
        private int requiredAmount;
        private int minedBlocks;

        public int getRequiredAmount() {
            return this.requiredAmount;
        }

        public void setRequiredAmount(int requiredAmount) {
            this.requiredAmount = requiredAmount;
        }

        public int getMinedBlocks() {
            return this.minedBlocks;
        }

        public void addMiningPoint(int sum) {
            this.minedBlocks = Math.min(this.minedBlocks + sum, this.requiredAmount);
        }

        public void createInfoComponent(List<class_2561> tooltipComponents, boolean isShiftPressed) {
            if (!this.data.stack.method_7985()) {
                if (isShiftPressed) {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.ultimine_addition.certificate.legacy.info"));
                }
                return;
            }
            if (!isShiftPressed) {
                if (!this.data.isAccomplished) {
                    tooltipComponents.add(1, this.createBrackets((class_2561)class_2561.method_43471((String)"tooltip.ultimine_addition.certificate.legacy.sealed").method_27692(class_124.field_1080)));
                } else {
                    tooltipComponents.add(1, this.createBrackets((class_2561)class_2561.method_43471((String)"tooltip.ultimine_addition.certificate.legacy.opened").method_27692(class_124.field_1065)));
                }
            } else if (!this.data.isAccomplished) {
                class_124 formatting = ChatFormattingUtils.get3ColorPercentageFormat(this.minedBlocks, this.requiredAmount);
                class_5250 component = class_2561.method_43470((String)String.valueOf(this.minedBlocks)).method_27692(formatting);
                tooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltip.ultimine_addition.certificate.legacy.quest.info", (Object[])new Object[]{this.requiredAmount}).method_27692(class_124.field_1062));
                tooltipComponents.add((class_2561)class_2561.method_43470((String)"\u27a4 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"tooltip.ultimine_addition.certificate.legacy.quest", (Object[])new Object[]{component}).method_27692(class_124.field_1080)));
            } else {
                tooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltip.ultimine_addition.certificate.legacy.quest.congrats", (Object[])new Object[]{this.minedBlocks}).method_27692(class_124.field_1060));
            }
        }

        private class_2561 createBrackets(class_2561 component) {
            return class_2561.method_43470((String)"\u300e").method_27692(class_124.field_1063).method_10852(component).method_10852((class_2561)class_2561.method_43470((String)"\u300f").method_27692(class_124.field_1063));
        }

        public class_2487 save() {
            class_2487 NBT = new class_2487();
            NBT.method_10569("required_amount", this.requiredAmount);
            NBT.method_10569("mined_blocks", this.minedBlocks);
            return NBT;
        }

        public Legacy load(MinerCertificateData data, class_2487 NBT) {
            this.data = data;
            this.requiredAmount = NBT.method_10550("required_amount");
            this.minedBlocks = NBT.method_10550("mined_blocks");
            return this;
        }
    }
}

