/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class ItemStorageData
extends DataHandler<ItemStorageData, class_1799> {
    private final String storageName;
    private class_1799 stack;
    private int maxCapacity;
    private int capacity;

    public ItemStorageData(String storageName, int maxCapacity) {
        this.storageName = storageName;
        this.maxCapacity = maxCapacity;
    }

    public ItemStorageData(String storageName) {
        this.storageName = storageName;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ItemStorageData fullCapacity() {
        this.capacity = this.maxCapacity;
        return this;
    }

    public ItemStorageData setCapacity(int amount) {
        this.capacity = Math.min(amount, this.maxCapacity);
        return this;
    }

    public ItemStorageData removeAmount(int amount) {
        this.capacity -= Math.max(0, amount);
        return this;
    }

    @Override
    public class_1799 get() {
        return this.stack;
    }

    public boolean isFull() {
        return this.capacity >= this.maxCapacity;
    }

    @Override
    public void saveData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        NBT.method_10569("max_" + this.storageName, this.maxCapacity);
        NBT.method_10569(this.storageName, this.capacity);
        stack.method_7948().method_10566(this.NBTBase, (class_2520)NBT);
        super.saveData(stack);
    }

    public ItemStorageData loadData(class_1799 stack) {
        class_2487 NBT = (class_2487)stack.method_7948().method_10580(this.NBTBase);
        if (NBT == null) {
            NBT = new class_2487();
        }
        this.maxCapacity = this.maxCapacity == 0 ? (NBT.method_10550("max_" + this.storageName) == 0 ? 500 : NBT.method_10550("max_" + this.storageName)) : this.maxCapacity;
        this.capacity = NBT.method_10550(this.storageName);
        this.stack = stack;
        return this;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10814(this.storageName);
        buf.writeInt(this.maxCapacity);
        buf.method_10793(this.stack);
    }

    public static ItemStorageData fromNetwork(class_2540 buf) {
        return new ItemStorageData(buf.method_19772(), buf.readInt()).loadData(buf.method_10819());
    }
}

