/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.challenge;

import dev.architectury.platform.Platform;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IneligibleBlocksSavedData
extends class_18 {
    public static final String DATA_KEY = "ultimine_addition.ineligible_blocks";
    private final Logger LOGGER = LoggerFactory.getLogger((String)"Ultimine Addition/IneligibleBlocks");
    private final class_3218 level;
    private final Map<class_1923, List<BlockEntry>> ChunkEntries;

    public IneligibleBlocksSavedData(class_3218 level, Map<class_1923, List<BlockEntry>> ChunkEntries) {
        this.level = level;
        this.ChunkEntries = ChunkEntries;
    }

    public void add(class_1297 entity, BlockInfo blockInfo) {
        class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
        class_1923 chunkPos = this.level.method_22350(blockInfo.pos).method_12004();
        List<BlockEntry> blockEntryList = this.ChunkEntries.get(chunkPos);
        if (blockEntryList == null) {
            blockEntryList = new ArrayList<BlockEntry>();
        }
        boolean isPosExists = false;
        block0: for (BlockEntry blockEntry : blockEntryList) {
            for (BlockInfo info : blockEntry.placedBlocks) {
                if (!info.pos.equals((Object)blockInfo.pos)) continue;
                isPosExists = true;
                continue block0;
            }
        }
        boolean isIdentifierExists = false;
        for (BlockEntry blockEntry : blockEntryList) {
            if (!blockEntry.isEntityMatched(id, entity.method_5667())) continue;
            if (isPosExists) {
                for (BlockInfo info : blockEntry.placedBlocks) {
                    if (info.pos.equals((Object)blockInfo.pos)) continue;
                    info.blockState = blockInfo.blockState;
                    break;
                }
            } else {
                blockEntry.placedBlocks.add(blockInfo);
            }
            isIdentifierExists = true;
            break;
        }
        if (!isIdentifierExists) {
            blockEntryList.add(new BlockEntry(id, entity.method_5667(), new ArrayList<BlockInfo>(Collections.singleton(blockInfo))));
        }
        this.ChunkEntries.put(chunkPos, blockEntryList);
        this.printDebug();
    }

    public void remove(class_2338 pos) {
        ArrayList<BlockEntry> removedList = new ArrayList<BlockEntry>();
        class_1923 chunkPos = this.level.method_22350(pos).method_12004();
        List<BlockEntry> blockEntryList = this.ChunkEntries.get(chunkPos);
        if (blockEntryList == null) {
            return;
        }
        for (BlockEntry blockEntry : blockEntryList) {
            blockEntry.placedBlocks.removeIf(info -> info.pos.equals((Object)pos));
            if (!blockEntry.placedBlocks.isEmpty()) continue;
            removedList.add(blockEntry);
        }
        if (!removedList.isEmpty()) {
            for (Map.Entry entry : this.ChunkEntries.entrySet()) {
                if (!((class_1923)entry.getKey()).equals((Object)chunkPos)) continue;
                ((List)entry.getValue()).removeIf(removedList::contains);
            }
        }
        if (blockEntryList.isEmpty()) {
            this.ChunkEntries.remove(chunkPos);
        }
        this.printDebug();
    }

    public void printDebug() {
        if (!((Boolean)ConfigHandler.COMMON.INELIGIBLE_BLOCKS_LOGGER.get()).booleanValue() && !Platform.isDevelopmentEnvironment()) {
            return;
        }
        this.ChunkEntries.forEach((chunkPos, chunkEntries) -> this.LOGGER.debug("{\"ChunkPos\": {}, \"Entries\": [{}]}", chunkPos, (Object)chunkEntries.parallelStream().map(BlockEntry::toJSONFormat).collect(Collectors.joining(", "))));
    }

    public boolean isBlockPlacedByEntity(class_2338 pos) {
        return !this.ChunkEntries.values().stream().flatMap(Collection::stream).map(BlockEntry::placedBlocks).flatMap(Collection::stream).filter(b -> b.pos.equals((Object)pos)).toList().isEmpty();
    }

    public Map<class_1923, List<BlockEntry>> getChunkEntries() {
        return this.ChunkEntries;
    }

    public static IneligibleBlocksSavedData getOrCreate(class_3218 level) {
        return (IneligibleBlocksSavedData)level.method_17983().method_17924(NBT -> IneligibleBlocksSavedData.load(level, NBT), () -> IneligibleBlocksSavedData.create(level), DATA_KEY);
    }

    private static IneligibleBlocksSavedData create(class_3218 level) {
        return new IneligibleBlocksSavedData(level, new HashMap<class_1923, List<BlockEntry>>());
    }

    private static IneligibleBlocksSavedData load(class_3218 level, class_2487 NBT) {
        return new IneligibleBlocksSavedData(level, IneligibleBlocksSavedData.deserializeIneligibleBlocks(NBT));
    }

    @NotNull
    public class_2487 method_75(class_2487 NBT) {
        NBT.method_10543(this.serializeIneligibleBlocks());
        return NBT;
    }

    public boolean method_79() {
        return true;
    }

    private class_2487 serializeIneligibleBlocks() {
        class_2499 entriesTagList = new class_2499();
        for (Map.Entry<class_1923, List<BlockEntry>> entry : this.ChunkEntries.entrySet()) {
            class_1923 chunkPos = entry.getKey();
            List<BlockEntry> chunkEntries = entry.getValue();
            class_2487 entryTag = new class_2487();
            entryTag.method_10566("Pos", (class_2520)IneligibleBlocksSavedData.writeChunkPos(chunkPos));
            entryTag.method_10566("Data", (class_2520)chunkEntries.stream().map(BlockEntry::serialize).collect(class_2499::new, AbstractList::add, AbstractCollection::addAll));
            entriesTagList.add((Object)entryTag);
        }
        class_2487 finalTag = new class_2487();
        finalTag.method_10566("ChunkEntries", (class_2520)entriesTagList);
        return finalTag;
    }

    private static Map<class_1923, List<BlockEntry>> deserializeIneligibleBlocks(class_2487 tag) {
        HashMap<class_1923, List<BlockEntry>> finalMap = new HashMap<class_1923, List<BlockEntry>>();
        class_2499 entriesListTag = tag.method_10554("ChunkEntries", 10);
        for (int i = 0; i < entriesListTag.size(); ++i) {
            class_2487 fetchedTag = entriesListTag.method_10602(i);
            class_1923 chunkPos = IneligibleBlocksSavedData.readChunkPos(fetchedTag.method_10562("Pos"));
            List<BlockEntry> chunkEntries = fetchedTag.method_10554("Data", 10).stream().map(entryTag -> BlockEntry.deserialize((class_2487)entryTag)).toList();
            finalMap.put(chunkPos, new ArrayList<BlockEntry>(chunkEntries));
        }
        return finalMap;
    }

    public void validateBlocks(class_3218 level) {
        for (Map.Entry<class_1923, List<BlockEntry>> entry : this.ChunkEntries.entrySet()) {
            for (BlockEntry blockEntry : entry.getValue()) {
                blockEntry.placedBlocks.removeIf(blockInfo -> level.method_14178().method_12123(((class_1923)entry.getKey()).field_9181, ((class_1923)entry.getKey()).field_9180) && !level.method_8320(blockInfo.pos).method_27852(blockInfo.blockState.method_26204()));
            }
        }
    }

    public static class_2487 writeChunkPos(class_1923 chunkPos) {
        class_2487 NBT = new class_2487();
        NBT.method_10569("X", chunkPos.field_9181);
        NBT.method_10569("Z", chunkPos.field_9180);
        return NBT;
    }

    public static class_1923 readChunkPos(class_2487 tag) {
        return new class_1923(tag.method_10550("X"), tag.method_10550("Z"));
    }

    public static class BlockInfo {
        public class_2680 blockState;
        public final class_2338 pos;

        public BlockInfo(class_2680 state, class_2338 pos) {
            this.blockState = state;
            this.pos = pos;
        }

        public String toString() {
            return "{\"State\": \"%s\", \"Pos\": \"%s\"}".formatted(class_2512.method_10686((class_2680)this.blockState), class_2512.method_10692((class_2338)this.pos));
        }
    }

    public record BlockEntry(class_2960 entityId, UUID entityUUID, List<BlockInfo> placedBlocks) {
        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            class_2499 blocksList = new class_2499();
            for (BlockInfo info : this.placedBlocks) {
                class_2487 blockTag = new class_2487();
                blockTag.method_10566("State", (class_2520)class_2512.method_10686((class_2680)info.blockState));
                blockTag.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)info.pos));
                blocksList.add((Object)blockTag);
            }
            class_2487 entity = new class_2487();
            entity.method_10582("Id", this.entityId.toString());
            entity.method_25927("UUID", this.entityUUID);
            tag.method_10566("Entity", (class_2520)entity);
            tag.method_10566("Blocks", (class_2520)blocksList);
            return tag;
        }

        public static BlockEntry deserialize(class_2487 tag) {
            class_2487 entity = tag.method_10562("Entity");
            class_2960 id = new class_2960(entity.method_10558("Id"));
            UUID uuid = entity.method_25926("UUID");
            ArrayList<BlockInfo> blockInfoList = new ArrayList<BlockInfo>();
            class_2499 blocksListTag = tag.method_10554("Blocks", 10);
            for (int i = 0; i < blocksListTag.size(); ++i) {
                class_2487 tag2 = blocksListTag.method_10602(i);
                class_2487 stateTag = tag2.method_10562("State");
                class_2487 posTag = tag2.method_10562("Pos");
                class_2680 blockState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)stateTag);
                class_2338 blockPos = class_2512.method_10691((class_2487)posTag);
                blockInfoList.add(new BlockInfo(blockState, blockPos));
            }
            return new BlockEntry(id, uuid, blockInfoList);
        }

        public boolean isEntityMatched(class_2960 id, UUID uuid) {
            return this.entityId.equals((Object)id) && this.entityUUID.equals(uuid);
        }

        public String toJSONFormat() {
            return "{\"EntityId\": \"%s\", \"EntityUUID\": \"%s\", \"blocksCount\": %s, \"placedBlocks\": [%s]}".formatted(this.entityId, this.entityUUID, this.placedBlocks.size(), this.placedBlocks.parallelStream().map(BlockInfo::toString).collect(Collectors.joining(", ")));
        }
    }
}

