/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.challenge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengesManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static ChallengesManager INSTANCE = new ChallengesManager();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ultimine Addition/ChallengesManager");
    private Map<class_2960, ChallengesData> challenges = new TreeMap<class_2960, ChallengesData>();

    public ChallengesManager() {
        super(GSON, "challenges");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> object, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        this.challenges.clear();
        object.forEach((location, json) -> {
            AtomicReference<ChallengesData> challenge = new AtomicReference<ChallengesData>();
            challenge.set((ChallengesData)ChallengesData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow(false, err -> {
                LOGGER.error("There is an issue with ({}) challenge JSON file.", (Object)location.toString());
                LOGGER.error(err);
            }));
            if (((ChallengesData)challenge.get()).getChallengeType() == ChallengesData.Type.INTERACT_WITH_BLOCK || ((ChallengesData)challenge.get()).getChallengeType() == ChallengesData.Type.INTERACT_WITH_BLOCK_CONSUME) {
                LOGGER.warn("This challenge type ({}) you choose in ({}) isn't stable! You may have to change the type until a new update comes to fix it.", (Object)((ChallengesData)challenge.get()).getChallengeType().getTypeName(), (Object)location.toString());
            }
            this.challenges.put((class_2960)location, (ChallengesData)challenge.get());
        });
    }

    public Map<class_2960, ChallengesData> getRandomChallenges(int quantity, MiningSkillCardItem.Type type, MiningSkillCardItem.Tier tier) {
        if (quantity > this.challenges.values().stream().filter(data -> data.getForCardType().equals(type) && data.getForCardTier().isEligible(tier)).toList().size()) {
            String error = String.format("There aren't enough %s %s challenges for tier %s to add it to Mining Skill Card.", quantity, type.getId().toLowerCase(), tier.name().toLowerCase());
            LOGGER.error(error);
            return new HashMap<class_2960, ChallengesData>();
        }
        HashMap<class_2960, ChallengesData> randomValues = new HashMap<class_2960, ChallengesData>();
        Random random = new Random();
        while (randomValues.size() < quantity) {
            int randomIndex = random.nextInt(this.challenges.size());
            class_2960[] keys = this.challenges.keySet().toArray(new class_2960[0]);
            class_2960 randomKey = keys[randomIndex];
            if (!this.challenges.get(randomKey).getForCardType().equals(type) || !this.challenges.get(randomKey).getForCardTier().isEligible(tier)) continue;
            randomValues.put(randomKey, this.challenges.get(randomKey));
        }
        if (((Boolean)ConfigHandler.COMMON.CHALLENGE_MANAGER_LOGGER.get()).booleanValue() || Platform.isDevelopmentEnvironment()) {
            LOGGER.info("Added Challenges:");
            randomValues.forEach((location, data) -> LOGGER.info("id: {}", location));
        }
        return randomValues;
    }

    public Map<class_2960, ChallengesData> getAllChallenges() {
        return this.challenges;
    }

    public void validateAllChallenges() {
        ArrayList markedToRemove = new ArrayList();
        this.challenges.forEach((location, challengesData) -> {
            AtomicBoolean isValid = new AtomicBoolean();
            List<class_2248> blocks = this.utilizeTargetedBlocks((ChallengesData)challengesData);
            if (!blocks.isEmpty()) {
                isValid.set(true);
            }
            if (!isValid.get()) {
                markedToRemove.add(location);
                LOGGER.error("There is no valid targeted blocks in ({}) challenge JSON file.", (Object)location.toString());
            }
        });
        if (markedToRemove.isEmpty()) {
            LOGGER.info("Loaded {} challenges", (Object)this.challenges.size());
        } else {
            int oldSize = this.challenges.size();
            markedToRemove.forEach(this.challenges::remove);
            LOGGER.info("Loaded {} from {} challenges", (Object)this.challenges.size(), (Object)oldSize);
        }
    }

    public List<class_2248> utilizeTargetedBlocks(ChallengesData data) {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        if (data.getTargetedBlocks() == null) {
            return new ArrayList<class_2248>();
        }
        for (String value : data.getTargetedBlocks()) {
            if (value.startsWith("#")) {
                ArrayList blocks = new ArrayList();
                class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(value.replaceAll("#", "")))).ifPresent(holders -> blocks.addAll(holders.method_40239().map(class_6880::comp_349).toList()));
                if (blocks.isEmpty()) continue;
                list.addAll(blocks);
                continue;
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(value));
            if (block == class_2246.field_10124) continue;
            list.add(block);
        }
        return list;
    }

    public boolean isCorrectTool(class_1657 player, ChallengesData challengesData) {
        if (challengesData.getForCardType().isCustomType()) {
            return ItemUtils.isItemInHandCustomCardValid(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.PICKAXE)) {
            return ItemUtils.isItemInHandPickaxe(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.AXE)) {
            return ItemUtils.isItemInHandAxe(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.SHOVEL)) {
            return ItemUtils.isItemInHandShovel(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.HOE)) {
            return ItemUtils.isItemInHandHoe(player);
        }
        return false;
    }

    public void setChallenges(Map<class_2960, ChallengesData> dataMap) {
        this.challenges = dataMap;
    }
}

