/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.challenge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public class ChallengesData {
    private final MiningSkillCardItem.Type forCardType;
    private final MiningSkillCardItem.Tier forCardTier;
    private final Type challengeType;
    private final class_1799 requiredSpecificTool;
    private final List<String> targetedBlocks;
    private final Pair<Integer, Integer> requiredAmount;
    public static final Codec<ChallengesData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiningSkillCardItem.Type.CODEC.fieldOf("for_card_type").forGetter(ChallengesData::getForCardType), (App)MiningSkillCardItem.Tier.CODEC.fieldOf("for_card_tier").forGetter(ChallengesData::getForCardTier), (App)Type.CODEC.fieldOf("challenge_type").forGetter(ChallengesData::getChallengeType), (App)Codec.pair((Codec)Codec.INT.fieldOf("min").codec(), (Codec)Codec.INT.fieldOf("max").codec()).optionalFieldOf("required_amount", (Object)new Pair((Object)1, (Object)1)).forGetter(ChallengesData::getRequiredAmountPair), (App)class_1799.field_24671.optionalFieldOf("required_specific_tool", (Object)class_1799.field_8037, Lifecycle.experimental()).forGetter(ChallengesData::getRequiredSpecificTool), (App)Codec.STRING.listOf().fieldOf("targeted_blocks").forGetter(ChallengesData::getTargetedBlocks)).apply((Applicative)instance, ChallengesData::new));

    public ChallengesData(MiningSkillCardItem.Type forCardType, MiningSkillCardItem.Tier forCardTier, Type challengeType, Pair<Integer, Integer> requiredAmount, class_1799 requiredSpecificTool, List<String> targetedBlocks) {
        this.forCardType = forCardType;
        this.forCardTier = forCardTier;
        this.challengeType = challengeType;
        this.requiredAmount = requiredAmount;
        this.requiredSpecificTool = requiredSpecificTool;
        this.targetedBlocks = targetedBlocks;
    }

    public MiningSkillCardItem.Type getForCardType() {
        return this.forCardType;
    }

    public MiningSkillCardItem.Tier getForCardTier() {
        return this.forCardTier;
    }

    public Type getChallengeType() {
        return this.challengeType;
    }

    public int getRequiredAmount() {
        Random random = new Random();
        return random.nextInt((Integer)this.requiredAmount.getSecond() - (Integer)this.requiredAmount.getFirst() + 1) + (Integer)this.requiredAmount.getFirst();
    }

    private Pair<Integer, Integer> getRequiredAmountPair() {
        return this.requiredAmount;
    }

    public class_1799 getRequiredSpecificTool() {
        return this.requiredSpecificTool;
    }

    public List<String> getTargetedBlocks() {
        return this.targetedBlocks;
    }

    public static void writeBuffer(class_2540 buf, ChallengesData data) {
        buf.method_10814(data.getForCardType().getId());
        buf.writeInt(data.getForCardTier().getValue());
        buf.method_10814(data.getChallengeType().getTypeName());
        buf.writeBoolean(data.getChallengeType().isConsuming());
        buf.writeInt(((Integer)data.getRequiredAmountPair().getFirst()).intValue());
        buf.writeInt(((Integer)data.getRequiredAmountPair().getSecond()).intValue());
        buf.method_10793(data.getRequiredSpecificTool());
        buf.method_34062(data.getTargetedBlocks(), class_2540::method_10814);
    }

    public static ChallengesData readBuffer(class_2540 buf) {
        MiningSkillCardItem.Type cardType = MiningSkillCardItem.Type.fromString(buf.method_19772());
        MiningSkillCardItem.Tier cardTier = MiningSkillCardItem.Tier.fromInt(buf.readInt());
        Type type = Type.fromValues(buf.method_19772(), buf.readBoolean());
        Pair requiredAmounts = Pair.of((Object)buf.readInt(), (Object)buf.readInt());
        class_1799 requiredSpecificTool = buf.method_10819();
        List targetedBlocks = buf.method_34066(class_2540::method_19772);
        return new ChallengesData(cardType, cardTier, type, (Pair<Integer, Integer>)requiredAmounts, requiredSpecificTool, targetedBlocks);
    }

    public static enum Type {
        BREAK_BLOCK("break_block", false),
        STRIP_BLOCK("strip_block", false),
        FLATTEN_BLOCK("flatten_block", false),
        TILLING_BLOCK("tilling_block", false),
        INTERACT_WITH_BLOCK("interact_with_block", false),
        BREAK_BLOCK_CONSUME("break_block", true),
        STRIP_BLOCK_CONSUME("strip_block", true),
        FLATTEN_BLOCK_CONSUME("flatten_block", true),
        TILLING_BLOCK_CONSUME("tilling_block", true),
        INTERACT_WITH_BLOCK_CONSUME("interact_with_block", true);

        private final String type;
        private final boolean consume;
        public static final Codec<Type> CODEC;

        private Type(String type, boolean consume) {
            this.type = type;
            this.consume = consume;
        }

        public String getTypeName() {
            return this.type.toLowerCase();
        }

        public Type getConsumeVersion() {
            return Type.fromValues(this.type, true);
        }

        public boolean isConsuming() {
            return this.consume;
        }

        private Pair<String, Boolean> getPair() {
            return Pair.of((Object)this.type, (Object)this.consume);
        }

        public static Type fromValues(String input, boolean state) {
            for (Type enumValue : Type.values()) {
                if (!enumValue.getTypeName().equalsIgnoreCase(input) || enumValue.isConsuming() != state) continue;
                return enumValue;
            }
            throw new IllegalArgumentException(String.format("No enum constant with the specified values: %s, %s", input, state));
        }

        static {
            CODEC = Codec.pair((Codec)Codec.STRING.fieldOf("id").codec(), (Codec)Codec.BOOL.fieldOf("consume_block").codec()).comapFlatMap(pair -> {
                try {
                    return DataResult.success((Object)((Object)Type.fromValues((String)pair.getFirst(), (Boolean)pair.getSecond())));
                }
                catch (EnumConstantNotPresentException e) {
                    return DataResult.error(() -> pair + " is not present.");
                }
            }, Type::getPair);
        }
    }
}

