/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.config;

import dev.architectury.platform.Platform;
import net.ixdarklord.coolcat_lib.util.TomlConfigReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SafeConfig<T> {
    private final T cachedValue;

    private SafeConfig(T cachedValue) {
        this.cachedValue = cachedValue;
    }

    public T get() {
        return this.cachedValue;
    }

    public static class Builder {
        private final String modId;
        private final String filePath;
        private final TomlConfigReader reader;
        private final Logger LOGGER;

        public Builder(String modId, String filePath) {
            this(modId, filePath, modId + "/SafeConfig");
        }

        public Builder(String modId, String filePath, String loggerName) {
            this.modId = modId;
            this.filePath = filePath;
            this.LOGGER = LogManager.getLogger((String)loggerName);
            this.reader = new TomlConfigReader(modId, "%s/%s/%s".formatted(Platform.getConfigFolder(), modId, filePath));
            if (this.reader.hasErrorOccurred()) {
                this.LOGGER.error("Failed to load config file!", (Object)filePath);
                switch (this.reader.getFileErrorState()) {
                    case FILE_NOT_FOUND: {
                        this.LOGGER.error("There is no file exists with this path: {}", (Object)filePath);
                        break;
                    }
                    case UNABLE_TO_READ: {
                        this.LOGGER.error("Unable to read the file: {}", (Object)filePath);
                        break;
                    }
                    case UNEXPECTED_ERROR: {
                        this.LOGGER.error("May the game need a restart to fix this issue: {}", (Object)filePath);
                    }
                }
            }
        }

        public SafeConfig<String> readString(String key, String fallbackValue) {
            if (this.reader.hasErrorOccurred()) {
                this.LOGGER.error("Unable to get (\"{}\")! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
                return new SafeConfig<String>(fallbackValue);
            }
            String value = this.reader.getResult(key);
            if (value == null) {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
            }
            return new SafeConfig<String>(value != null ? value : fallbackValue);
        }

        public SafeConfig<Integer> readInt(String key, int fallbackValue) {
            if (this.reader.hasErrorOccurred()) {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
                return new SafeConfig<Integer>(fallbackValue);
            }
            String value = this.reader.getResult(key);
            if (value != null) {
                try {
                    return new SafeConfig<Integer>(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    this.LOGGER.error("This key does not contain an integer value: {}", (Object)key);
                }
            } else {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
            }
            return new SafeConfig<Integer>(fallbackValue);
        }

        public SafeConfig<Boolean> readBoolean(String key, boolean fallbackValue) {
            if (this.reader.hasErrorOccurred()) {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
                return new SafeConfig<Boolean>(fallbackValue);
            }
            String value = this.reader.getResult(key);
            if (value == null) {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue);
            }
            return new SafeConfig<Boolean>(value != null ? Boolean.parseBoolean(value) : fallbackValue);
        }

        public <E extends Enum<E>> SafeConfig<E> readEnum(String key, E fallbackValue) {
            if (this.reader.hasErrorOccurred()) {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue.name());
                return new SafeConfig<E>(fallbackValue);
            }
            String value = this.reader.getResult(key);
            Class<E> enumClass = fallbackValue.getDeclaringClass();
            for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                if (value == null) break;
                if (!enumConstant.name().equalsIgnoreCase(value.replace("\"", ""))) continue;
                return new SafeConfig<Enum>(enumConstant);
            }
            if (value != null) {
                this.LOGGER.error("No enum constant with name " + value + " in enum class " + enumClass.getName());
            } else {
                this.LOGGER.error("Unable to get \"{}\"! Assign the fallback value... ({})", (Object)key, (Object)fallbackValue.name());
            }
            return new SafeConfig<E>(fallbackValue);
        }

        public Builder refreshBuilder() {
            return new Builder(this.modId, this.filePath);
        }
    }
}

