/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class CardSlotsArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "4");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(entry -> class_2561.method_43469((String)"slot.unknown", (Object[])new Object[]{entry}));
    private final int slotCount = 4;

    public static CardSlotsArgument slots() {
        return new CardSlotsArgument();
    }

    public static Integer getSlot(CommandContext<class_2168> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int value = reader.readInt();
        if (value < 0 || value >= 4) {
            throw ERROR_UNKNOWN_SLOT.create((Object)value);
        }
        return value;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        List integerList = IntStream.rangeClosed(0, 3).mapToObj(Integer::toString).collect(Collectors.toList());
        return class_2172.method_9265(integerList, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

