/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.brewing;

import net.ixdarklord.coolcat_lib.common.brewing.fabric.BrewingRecipe;
import net.ixdarklord.coolcat_lib.common.brewing.fabric.BrewingRecipeRegistry;
import net.ixdarklord.coolcat_lib.common.brewing.fabric.IBrewingRecipe;
import net.ixdarklord.ultimine_addition.api.CustomMSCApi;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.potion.MineGoPotion;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MineGoJuiceRecipe
extends BrewingRecipe {
    private final class_1842 input;
    private final class_1842 output;

    public MineGoJuiceRecipe(class_1842 input, class_1792 ingredient, class_1842 output) {
        super(class_1856.method_8101((class_1799[])new class_1799[]{class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)input)}), class_1856.method_8091((class_1935[])new class_1935[]{ingredient}), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)output));
        this.input = input;
        this.output = output;
    }

    public MineGoJuiceRecipe(class_1842 input, class_1799 ingredient, class_1842 output) {
        super(class_1856.method_8101((class_1799[])new class_1799[]{class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)input)}), class_1856.method_8101((class_1799[])new class_1799[]{ingredient}), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)output));
        this.input = input;
        this.output = output;
    }

    public static void register() {
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return;
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MineGoJuiceRecipe(class_1847.field_8991, class_1802.field_8598, (class_1842)Registration.KNOWLEDGE_POTION.get()));
        MineGoJuiceRecipe.addTiers((class_1792)Registration.MINING_SKILL_CARD_PICKAXE.get(), Registration.MINE_GO_JUICE_PICKAXE_POTION.getId());
        MineGoJuiceRecipe.addTiers((class_1792)Registration.MINING_SKILL_CARD_AXE.get(), Registration.MINE_GO_JUICE_AXE_POTION.getId());
        MineGoJuiceRecipe.addTiers((class_1792)Registration.MINING_SKILL_CARD_SHOVEL.get(), Registration.MINE_GO_JUICE_SHOVEL_POTION.getId());
        MineGoJuiceRecipe.addTiers((class_1792)Registration.MINING_SKILL_CARD_HOE.get(), Registration.MINE_GO_JUICE_HOE_POTION.getId());
        for (MiningSkillCardItem.Type type : CustomMSCApi.CUSTOM_TYPES) {
            String cardName = "mining_skill_card_%s".formatted(type.getId());
            String potionName = "mine_go_juice_%s".formatted(type.getId());
            class_1792 customCard = (class_1792)Registration.ITEMS.getRegistrar().get(UltimineAddition.getLocation(cardName));
            class_1842 customPotion = (class_1842)Registration.POTIONS.getRegistrar().get(UltimineAddition.getLocation(potionName));
            if (customCard == null || customPotion == null) continue;
            MineGoJuiceRecipe.addTiers(customCard, UltimineAddition.getLocation(potionName));
        }
    }

    private static void addTiers(@NotNull class_1792 item, class_2960 output) {
        class_1799 stack = new class_1799((class_1935)item);
        MiningSkillCardData data = new MiningSkillCardData().loadData(stack);
        class_1799 tier1 = stack.method_7972();
        class_1842 potion1 = (class_1842)class_7923.field_41179.method_10223(output);
        data.setTier(MiningSkillCardItem.Tier.Novice).saveData(tier1);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MineGoJuiceRecipe((class_1842)Registration.KNOWLEDGE_POTION.get(), tier1, potion1));
        class_1799 tier2 = stack.method_7972();
        class_1842 potion2 = (class_1842)class_7923.field_41179.method_10223(new class_2960(output + "_2"));
        data.setTier(MiningSkillCardItem.Tier.Apprentice).saveData(tier2);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MineGoJuiceRecipe((class_1842)Registration.KNOWLEDGE_POTION.get(), tier2, potion2));
        class_1799 tier3 = stack.method_7972();
        class_1842 potion3 = (class_1842)class_7923.field_41179.method_10223(new class_2960(output + "_3"));
        data.setTier(MiningSkillCardItem.Tier.Adept).saveData(tier3);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MineGoJuiceRecipe((class_1842)Registration.KNOWLEDGE_POTION.get(), tier3, potion3));
    }

    public boolean isInput(@NotNull class_1799 stack) {
        if (stack.method_7909() instanceof class_1812) {
            return class_1844.method_8063((class_1799)stack) == this.input;
        }
        return super.isInput(stack);
    }

    public boolean isIngredient(@NotNull class_1799 ingredient) {
        class_1792 class_17922 = ingredient.method_7909();
        if (class_17922 instanceof MiningSkillCardItem) {
            MiningSkillCardItem item = (MiningSkillCardItem)class_17922;
            int tier = item.getData(ingredient).getTier().getValue();
            return this.getIngredient().method_8093(ingredient) && tier > 0 && tier < 4 && item.getData(ingredient).getPotionPoints() > 0;
        }
        return super.isIngredient(ingredient);
    }

    @NotNull
    public class_1799 getOutput(@NotNull class_1799 input, @NotNull class_1799 ingredient) {
        if (!this.isInput(input) || !this.isIngredient(ingredient)) {
            return class_1799.field_8037;
        }
        class_1792 class_17922 = ingredient.method_7909();
        if (class_17922 instanceof MiningSkillCardItem) {
            MiningSkillCardItem item = (MiningSkillCardItem)class_17922;
            class_17922 = this.output;
            if (class_17922 instanceof MineGoPotion) {
                MineGoPotion potion = (MineGoPotion)class_17922;
                if (!item.getData(ingredient).getTier().equals((Object)potion.getTier())) {
                    return class_1799.field_8037;
                }
            }
        }
        return this.getOutput().method_7972();
    }
}

