/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.ixdarklord.coolcat_lib.client.button.CustomImageButton;
import net.ixdarklord.coolcat_lib.client.gui.component.TextScreen;
import net.ixdarklord.coolcat_lib.util.ColorUtils;
import net.ixdarklord.coolcat_lib.util.MathUtils;
import net.ixdarklord.coolcat_lib.util.MouseHelper;
import net.ixdarklord.coolcat_lib.util.ScreenUtils;
import net.ixdarklord.ultimine_addition.client.gui.component.SkillsRecordTooltip;
import net.ixdarklord.ultimine_addition.client.gui.screen.ChallengesInfoPanel;
import net.ixdarklord.ultimine_addition.client.handler.KeyHandler;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.common.menu.slot.CustomSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.MiningSkillCardSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PaperSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PenSlot;
import net.ixdarklord.ultimine_addition.core.UltimineAddition;
import net.ixdarklord.ultimine_addition.hooks.KeyBindingHooks;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import net.minecraft.class_811;

public class SkillsRecordScreen
extends class_465<SkillsRecordMenu> {
    private final class_2960 OPTIONS_TEXTURE = UltimineAddition.getGuiTexture("skills_record_options", "png");
    private final class_2960 TEXTURE = UltimineAddition.getGuiTexture("skills_record", "png");
    protected final SkillsRecordMenu container;
    private TextScreen textScreen;
    private final int maxProgress = 100;
    private final List<class_4185> optionsButtonList = new ArrayList<class_4185>();
    private final List<Double> optionsX = new ArrayList<Double>(List.of(Double.valueOf(0.0), Double.valueOf(0.0)));
    private final List<Double> optionsY = new ArrayList<Double>(List.of(Double.valueOf(0.0), Double.valueOf(0.0)));
    private BGColor backgroundColor;
    private float time;
    private static float itemCycle;
    private int progressMode;
    private int selectedSlot;
    private boolean isChallengesExists;
    private boolean isMissingItems;
    private boolean notEnoughInk;
    private int currentProgress;
    private CustomImageButton configurationButton;
    private class_4185 backgroundColorButton;
    private class_4185 animationsButton;
    private class_4185 progressionBarButton;
    private class_4185 challengesPanelPosButton;
    private class_4185 challengesPanelSizeButton;
    private boolean isScrolling;
    private boolean isOptionsShown;
    private boolean isDraggingWindow;
    private boolean isAnimationsEnabled;
    private boolean isProgressionBarShown;

    public SkillsRecordScreen(SkillsRecordMenu container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        this.container = container;
        this.field_2779 = 218;
        this.field_25267 = 8;
        this.field_25268 = 5;
        this.field_25269 = 8;
        this.field_25270 = this.field_2779 - 92;
        this.time = 0.0f;
        this.selectedSlot = container.getData().getViewingCard();
        this.currentProgress = 0;
        this.backgroundColor = (BGColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        this.isAnimationsEnabled = (Boolean)ConfigHandler.CLIENT.ANIMATIONS_MODE.get();
        this.progressMode = (Integer)ConfigHandler.CLIENT.PROGRESS_BAR.get();
    }

    protected void method_25426() {
        super.method_25426();
        this.textScreen = new TextScreen(this.field_2776 + 10, this.field_2800 + 17, 157, 82, ((Boolean)ConfigHandler.CLIENT.TEXT_SCREEN_SHADOW.get()).booleanValue()).build(2);
        this.resetOptionsWindow();
        this.createButtons(this.field_2776, this.field_2800);
    }

    private void createButtons(int x, int y) {
        this.configurationButton = (CustomImageButton)this.method_37063((class_364)new CustomImageButton(x + 160, y + 4, 9, 9, 177, 0, 9, this.TEXTURE, 256, 256, button -> {
            this.isOptionsShown ^= true;
            this.resetOptionsWindow();
        }, class_5244.field_39003));
        double X = this.optionsX.get(0);
        double Y = this.optionsY.get(0);
        this.backgroundColorButton = (class_4185)this.method_37063((class_364)new class_344((int)(X + 9.0), (int)(Y + 29.0), 100, 10, 0, 0, 0, this.TEXTURE, 0, 0, button -> {
            this.backgroundColor = !class_437.method_25442() ? this.backgroundColor.next() : this.backgroundColor.previous();
            this.saveValuesToConfig();
        }, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.bg_color")));
        this.animationsButton = (class_4185)this.method_37063((class_364)new class_344((int)(X + 9.0), (int)(Y + 42.0), 100, 10, 0, 0, 0, this.TEXTURE, 0, 0, button -> {
            this.isAnimationsEnabled ^= true;
            this.saveValuesToConfig();
        }, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.animations")));
        this.progressionBarButton = (class_4185)this.method_37063((class_364)new class_344((int)(X + 9.0), (int)(Y + 55.0), 100, 10, 0, 0, 0, this.TEXTURE, 0, 0, button -> {
            int n = this.progressMode = this.progressMode >= 2 ? 0 : this.progressMode + 1;
            if (this.progressMode == 1) {
                this.isProgressionBarShown = false;
            }
            this.saveValuesToConfig();
        }, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.progression_bar")));
        this.challengesPanelPosButton = (class_4185)this.method_37063((class_364)new class_344((int)(X + 9.0), (int)(Y + 68.0), 100, 10, 0, 0, 0, this.TEXTURE, 0, 0, button -> {
            if (!class_437.method_25442()) {
                ChallengesInfoPanel.INSTANCE.setPanelPos(ChallengesInfoPanel.INSTANCE.getPanelPos().next());
            } else {
                ChallengesInfoPanel.INSTANCE.setPanelPos(ChallengesInfoPanel.INSTANCE.getPanelPos().previous());
            }
            this.saveValuesToConfig();
        }, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.panel_pos")));
        this.challengesPanelSizeButton = (class_4185)this.method_37063((class_364)new class_344((int)(X + 9.0), (int)(Y + 81.0), 100, 10, 0, 0, 0, this.TEXTURE, 0, 0, button -> {}, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.panel_size")));
        this.optionsButtonList.clear();
        this.optionsButtonList.addAll(List.of(this.backgroundColorButton, this.animationsButton, this.progressionBarButton, this.challengesPanelPosButton, this.challengesPanelSizeButton));
        this.updateButton(0, 0);
    }

    private void updateButton(int mouseX, int mouseY) {
        AtomicInteger length = new AtomicInteger(this.getButtonsTextLength());
        length.set(Math.max(this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.configuration")), length.get()));
        int spacing = Math.max(length.get() - 100 + 2, 0);
        if (spacing > 0) {
            this.optionsButtonList.forEach(button -> button.method_25358(length.get()));
        }
        this.configurationButton.setColor(this.backgroundColor.color);
        boolean bl = !MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)this.field_2776, (int)this.field_2800, (int)160, (int)4, (int)9, (int)9) || !MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (double)this.optionsX.get(0), (double)this.optionsY.get(0), (double)0.0, (double)0.0, (int)(this.isOptionsShown ? 118 + spacing : 0), (int)(this.isOptionsShown ? 108 : 0)) ? true : (this.configurationButton.field_22763 = false);
        if (!this.configurationButton.field_22763) {
            this.configurationButton.method_47400(null);
        } else {
            class_5250 component = class_2561.method_43471((String)"gui.ultimine_addition.skills_record.configuration");
            this.configurationButton.method_47400(class_7919.method_47408((class_2561)class_2561.method_43470((String)"\u00a78\u27a4 ").method_10852((class_2561)component).method_27692(class_124.field_1056), (class_2561)component));
        }
        if (!this.configurationButton.method_25405((double)mouseX, (double)mouseY) && this.configurationButton.method_25370()) {
            this.configurationButton.method_25365(false);
        }
        for (class_4185 button2 : this.optionsButtonList) {
            button2.field_22764 = this.isOptionsShown;
            if (button2.method_25405((double)mouseX, (double)mouseY) || !button2.method_25370()) continue;
            button2.method_25365(false);
        }
    }

    private void update(float partialTick) {
        DataHandler data;
        if (!class_437.method_25441()) {
            this.time += partialTick;
        }
        this.currentProgress = 0;
        if (this.selectedSlot > -1 && ((class_1735)this.container.getCardSlots().get(this.selectedSlot)).method_7677() == class_1799.field_8037) {
            this.selectedSlot = -1;
            data = this.container.getData();
            ((SkillsRecordData)((SkillsRecordData)data).setViewingCard(this.selectedSlot).sendToServer()).saveData(((SkillsRecordData)data).get());
        }
        data = new MiningSkillCardData().loadData(this.selectedSlot > -1 ? ((class_1735)this.container.getCardSlots().get(this.selectedSlot)).method_7677() : class_1799.field_8037);
        boolean isCardTierMastered = ((MiningSkillCardData)data).getTier() == MiningSkillCardItem.Tier.Mastered;
        this.isChallengesExists = !((MiningSkillCardData)data).getChallenges().isEmpty();
        boolean hasCorrectGamemode = !this.container.getPlayer().method_7337() && !this.container.getPlayer().method_7325();
        this.isMissingItems = hasCorrectGamemode && (!((class_1735)this.container.getAllSlots().get(4)).method_7681() || !((class_1735)this.container.getAllSlots().get(5)).method_7681());
        boolean bl = this.notEnoughInk = hasCorrectGamemode && this.selectedSlot > -1 && this.container.getInkAmount() == 0;
        if (this.isOptionsShown) {
            this.isProgressionBarShown = false;
            this.container.getAllSlots().forEach(slot -> ((CustomSlot)((Object)slot)).setEnabled(false));
        } else {
            if (this.isChallengesExists && !this.isMissingItems && !this.notEnoughInk && this.progressMode == 0) {
                this.isProgressionBarShown = true;
            } else if (this.selectedSlot == -1 || isCardTierMastered) {
                this.isProgressionBarShown = false;
            }
            this.container.getAllSlots().forEach(slot -> ((CustomSlot)((Object)slot)).setEnabled(true));
        }
        this.textScreen.clear();
        this.textScreen.setHeight(82 - (this.isProgressionBarShown ? 9 : 0), true);
    }

    private void saveValuesToConfig() {
        ConfigHandler.CLIENT.BACKGROUND_COLOR.set((Object)this.backgroundColor);
        ConfigHandler.CLIENT.ANIMATIONS_MODE.set((Object)this.isAnimationsEnabled);
        ConfigHandler.CLIENT.PROGRESS_BAR.set((Object)this.progressMode);
        ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.set((Object)ChallengesInfoPanel.INSTANCE.getPanelPos());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.update(partialTick);
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScroll(guiGraphics, this.field_2776, this.field_2800, mouseX, mouseY);
        this.renderProgressBar(guiGraphics, this.field_2776, this.field_2800, mouseX, mouseY);
        this.renderConsumeButton(guiGraphics, this.field_2776, this.field_2800, mouseX, mouseY);
        this.renderTextBoxComponent(guiGraphics, mouseX, mouseY);
        this.renderOptions(guiGraphics, mouseX, mouseY);
        this.method_2380(guiGraphics, mouseX, mouseY);
        this.updateButton(mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderGhostItem(guiGraphics, this.field_2776, this.field_2800);
        this.renderSlotDecorations(guiGraphics, this.field_2776, this.field_2800);
        this.renderTextBox(guiGraphics);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        Color color = ColorUtils.blendColors((Color)new Color(0, 0, 0), (Color)this.backgroundColor.color, (double)0.75);
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, color.getRGB(), false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, color.getRGB(), false);
    }

    private void renderGhostItem(class_332 guiGraphics, int x, int y) {
        class_4587 poseStack = guiGraphics.method_51448();
        List<class_1799> listOfCards = List.of(new class_1799((class_1935)ModItems.MINING_SKILL_CARD_PICKAXE), new class_1799((class_1935)ModItems.MINING_SKILL_CARD_AXE), new class_1799((class_1935)ModItems.MINING_SKILL_CARD_SHOVEL), new class_1799((class_1935)ModItems.MINING_SKILL_CARD_HOE));
        class_1799 displayItem = class_1799.field_8037;
        for (class_1735 slot : this.container.getAllSlots()) {
            float alpha;
            if (slot instanceof MiningSkillCardSlot) {
                displayItem = listOfCards.get(class_3532.method_15375((float)(this.time / 20.0f)) % listOfCards.size());
            }
            if (slot instanceof PenSlot) {
                displayItem = new class_1799((class_1935)ModItems.PEN);
            }
            if (slot instanceof PaperSlot) {
                displayItem = new class_1799((class_1935)class_1802.field_8407);
            }
            if (displayItem == class_1799.field_8037) {
                return;
            }
            class_1799 stack = slot.method_7677();
            if (stack == class_1799.field_8037 || this.isOptionsShown) {
                boolean bl;
                poseStack.method_22903();
                poseStack.method_46416((float)(x + slot.field_7873), (float)(y + slot.field_7872), 100.0f);
                poseStack.method_22904(8.0, 8.0, 0.0);
                poseStack.method_22905(1.0f, -1.0f, 1.0f);
                poseStack.method_22905(16.0f, 16.0f, 16.0f);
                class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
                assert (this.field_22787 != null);
                class_1087 model = this.field_22787.method_1480().method_4019(displayItem, null, null, 0);
                RenderSystem.applyModelViewMatrix();
                boolean bl2 = bl = !model.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                poseStack.method_22903();
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float size = MathUtils.cycledBetweenValues((float)0.75f, (float)0.9f, (float)1.0f, (float)(this.time / 20.0f), (boolean)true);
                size = this.isAnimationsEnabled ? size : 0.9f;
                poseStack.method_22905(size, size, size);
                this.field_22787.method_1480().method_23179(displayItem, class_811.field_4317, false, poseStack, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, model);
                RenderSystem.enableDepthTest();
                bufferSource.method_22993();
                poseStack.method_22909();
                if (bl) {
                    class_308.method_24211();
                }
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                poseStack.method_22909();
            }
            boolean isMissingItems = this.isChallengesExists && this.isMissingItems && (slot instanceof PenSlot || slot instanceof PaperSlot);
            boolean notEnoughInk = this.isChallengesExists && this.notEnoughInk && slot instanceof PenSlot;
            int color = isMissingItems || notEnoughInk || this.container.isCardSlotsEmpty() && slot instanceof MiningSkillCardSlot ? 0xFF0000 : 0x8B8B8B;
            float f = alpha = isMissingItems || notEnoughInk || this.container.isCardSlotsEmpty() && slot instanceof MiningSkillCardSlot ? 0.15f : 0.55f;
            if (stack != class_1799.field_8037 && !notEnoughInk && !this.isOptionsShown) continue;
            poseStack.method_22903();
            poseStack.method_46416((float)(x + slot.field_7873), (float)(y + slot.field_7872), 100.0f);
            poseStack.method_22904(8.0, 8.0, 0.0);
            RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
            guiGraphics.method_51739(class_1921.method_51785(), -8, -8, 8, 8, ColorUtils.RGBToRGBA((int)color, (float)alpha));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22909();
        }
    }

    private void renderSlotDecorations(class_332 guiGraphics, int x, int y) {
        if (this.isOptionsShown) {
            return;
        }
        if (this.container.method_7611(4).method_7677() != class_1799.field_8037) {
            guiGraphics.method_25302(this.TEXTURE, x + 133, y + 99, 157, 219, 5, 8);
        }
        if (this.container.method_7611(5).method_7677() != class_1799.field_8037) {
            guiGraphics.method_25302(this.TEXTURE, x + 153, y + 99, 157, 219, 5, 8);
        }
        if (this.selectedSlot == -1) {
            return;
        }
        int X = 18 + 20 * this.selectedSlot;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(this.TEXTURE, x + X, y + 99, 157, 219, 5, 8);
    }

    private void renderTextBox(class_332 guiGraphics) {
        class_1799 stack = this.selectedSlot > -1 ? ((class_1735)this.container.getCardSlots().get(this.selectedSlot)).method_7677() : class_1799.field_8037;
        MiningSkillCardData data = new MiningSkillCardData().loadData(stack);
        if (this.container.isCardSlotsEmpty()) {
            this.textScreen.selectBox(0).alignPosToCenter(true).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.no_cards"), new class_124[]{class_124.field_1061});
        } else if (this.selectedSlot == -1) {
            this.textScreen.selectBox(0).alignPosToCenter(true).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.select_card"), new class_124[]{class_124.field_1080});
        } else if (this.selectedSlot > -1 && !data.getChallenges().isEmpty()) {
            this.textScreen.selectBox(0).alignPosToCenter(false);
            this.createChallengesText(this.container.getCardSlots());
        } else if (this.selectedSlot > -1 && data.getTier() == MiningSkillCardItem.Tier.Mastered) {
            this.textScreen.selectBox(0).alignPosToCenter(true).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.completed_card"), new class_124[]{class_124.field_1065, class_124.field_1056});
        } else {
            this.textScreen.selectBox(0).alignPosToCenter(true).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.no_challenges"), new class_124[]{class_124.field_1080});
        }
        if (this.isOptionsShown) {
            this.textScreen.selectBox(1).shouldRender(true).alignPosToCenter(List.of(Boolean.valueOf(true), Boolean.valueOf(false)).get(class_3532.method_15375((float)(this.time / 20.0f)) % 2).booleanValue()).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.example"), (class_2561)class_2561.method_43470((String)"A: 001"), new class_124[]{class_124.field_1068}).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.example"), (class_2561)class_2561.method_43470((String)"B: 002"), new class_124[]{class_124.field_1080}).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.example"), (class_2561)class_2561.method_43470((String)"C: 003"), new class_124[]{class_124.field_1062}).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.example"), (class_2561)class_2561.method_43470((String)"C: 004"), new class_124[]{class_124.field_1065});
            if (this.textScreen.canScroll() && this.optionsX.get(0) == (double)(this.field_2776 + 178) && this.optionsY.get(0) == (double)this.field_2800) {
                this.moveOptionsWindowTo(this.field_2776 + 191, this.field_2800);
            }
        } else if (this.isChallengesExists && this.isMissingItems) {
            this.textScreen.selectBox(1).shouldRender(true).alignPosToCenter(true).backgroundColor(new Color(75, 24, 24, 218)).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.missing_items").method_27692(class_124.field_1061), new class_124[0]);
            ArrayList<class_1799> missingItems = new ArrayList<class_1799>();
            if (!((class_1735)this.container.getAllSlots().get(4)).method_7681()) {
                missingItems.add(ModItems.PEN.method_7854());
            }
            if (!((class_1735)this.container.getAllSlots().get(5)).method_7681()) {
                missingItems.add(class_1802.field_8407.method_7854());
            }
            for (class_1799 item : missingItems) {
                this.textScreen.add(class_2561.method_43470((String)"\u00a7c\u2022 ").method_10852((class_2561)class_2561.method_43473().method_10852(item.method_7964()).method_27694(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(item))))).method_30937());
            }
        } else if (this.isChallengesExists && this.notEnoughInk) {
            this.textScreen.selectBox(1).shouldRender(true).alignPosToCenter(true).backgroundColor(new Color(75, 24, 24, 218)).create((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.not_enough_ink").method_27692(class_124.field_1061), new class_124[0]);
        } else {
            this.textScreen.selectBox(1).shouldRender(false);
        }
        this.textScreen.renderAllBoxes(guiGraphics, Color.DARK_GRAY.getRGB(), this.backgroundColor.color);
    }

    private void moveOptionsWindowTo(double newX, double newY) {
        this.optionsX.set(0, newX);
        this.optionsY.set(0, newY);
    }

    private void renderScroll(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!this.textScreen.canScroll()) {
            return;
        }
        float offset = (float)this.textScreen.getScrollOffset() / Math.max(1.0f, (float)this.textScreen.getRemainingLines());
        float delta = class_3532.method_15363((float)offset, (float)0.0f, (float)1.0f);
        int Y = (int)class_3532.method_16439((float)delta, (float)(this.field_2800 + 16), (float)(this.field_2800 + 88));
        boolean isOverButton = MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)(x + 174), (int)Y, (int)0, (int)0, (int)9, (int)10);
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.TEXTURE, x + 173, y + 10, 177, 28, 16, 95);
        guiGraphics.method_25302(this.TEXTURE, x + 174, Y, 177, !isOverButton ? 124 : 135, 9, 11);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderProgressBar(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!this.isProgressionBarShown) {
            return;
        }
        class_4587 poseStack = guiGraphics.method_51448();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(this.TEXTURE, x + 10, y + 91, 0, 219, 156, 7);
        float f = this.currentProgress;
        Objects.requireNonNull(this);
        float value = f / 100.0f;
        int bar = (int)class_3532.method_16439((float)value, (float)0.0f, (float)154.0f);
        poseStack.method_22903();
        poseStack.method_46416((float)(x + 11), (float)(y + 97), 0.0f);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
        guiGraphics.method_51740(class_1921.method_51785(), 0, 0, 5, bar, ColorUtils.RGBToRGBA((int)this.getProgressionBarColor(), (float)0.55f), ColorUtils.RGBToRGBA((int)this.getProgressionBarColor(), (float)0.75f), 0);
        poseStack.method_22909();
        if (this.isOptionsShown) {
            return;
        }
        if (MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)x, (int)y, (int)10, (int)91, (int)156, (int)7)) {
            class_5250 component = class_2561.method_43469((String)"gui.ultimine_addition.skills_record.progress", (Object[])new Object[]{class_2561.method_43470((String)("%" + this.currentProgress)).method_27696(class_2583.field_24360.method_36139(this.getProgressionBarColor()))}).method_27692(class_124.field_1080);
            guiGraphics.method_51438(this.field_22793, (class_2561)component, mouseX - 50, mouseY - 5);
        }
    }

    private void renderConsumeButton(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!this.isOptionsShown && !this.isConsumeChallengeExists()) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.TEXTURE, x + 86, y + 106, 177, 147, 9, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = this.container.getData().isConsumeMode() ? new Color(65359).getRGB() : new Color(14229793).getRGB();
        guiGraphics.method_25296(x + 87, y + 107, x + 94, y + 123, ColorUtils.RGBToRGBA((int)color, (float)1.0f), ColorUtils.RGBToRGBA((int)color, (float)0.75f));
        int yPos = this.container.getData().isConsumeMode() ? 115 : 107;
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.TEXTURE, x + 87, y + yPos, 177, 166, 7, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isOptionsShown && MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)x, (int)y, (int)86, (int)106, (int)9, (int)18)) {
            class_5250 state = this.container.getData().isConsumeMode() ? class_2561.method_43471((String)"options.on").method_27692(class_124.field_1060) : class_2561.method_43471((String)"options.off").method_27692(class_124.field_1061);
            class_5250 info = class_2561.method_43470((String)"\u27a4 ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"gui.ultimine_addition.skills_record.consume", (Object[])new Object[]{state}).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
            guiGraphics.method_51438(this.field_22793, (class_2561)info, mouseX, mouseY);
        }
    }

    private void renderTextBoxComponent(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isOptionsShown) {
            return;
        }
        class_2583 style = this.textScreen.getComponentStyleAt((double)mouseX, (double)mouseY);
        if (style != null && style.method_10969() != null) {
            class_2561 component;
            class_2568 styleHoverEvent = style.method_10969();
            if (styleHoverEvent.method_10891(class_2568.class_5247.field_24342) != null && (component = (class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342)) != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)component, Math.max(this.field_22789 / 2, 200)), mouseX, mouseY);
            }
            if (styleHoverEvent.method_10891(class_2568.class_5247.field_24343) != null) {
                class_2568.class_5249 stackInfo = (class_2568.class_5249)styleHoverEvent.method_10891(class_2568.class_5247.field_24343);
                if (stackInfo == null) {
                    return;
                }
                int X = -10;
                int Y = -30;
                guiGraphics.method_51448().method_22903();
                this.renderItemTooltip(guiGraphics, stackInfo.method_27683(), style, mouseX + X, mouseY + Y);
                guiGraphics.method_51448().method_22909();
            }
        }
    }

    private void renderOptions(class_332 guiGraphics, int mouseX, int mouseY) {
        int i;
        if (!this.isOptionsShown) {
            return;
        }
        if (this.isDraggingWindow) {
            if (this.optionsX.get(1) == 0.0) {
                this.optionsX.set(1, Math.abs(this.optionsX.get(0) - (double)mouseX));
                this.optionsY.set(1, Math.abs(this.optionsY.get(0) - (double)mouseY));
            }
            this.optionsX.set(0, (double)mouseX - this.optionsX.get(1));
            this.optionsY.set(0, (double)mouseY - this.optionsY.get(1));
        } else {
            this.optionsX.set(1, 0.0);
            this.optionsY.set(1, 0.0);
        }
        AtomicInteger length = new AtomicInteger(this.getButtonsTextLength());
        length.set(Math.max(this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.configuration")), length.get()));
        int spacing = Math.max(length.get() - 100 + 2, 0);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(this.optionsX.get(0).doubleValue(), this.optionsY.get(0).doubleValue(), 350.0);
        int filling = 5;
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.OPTIONS_TEXTURE, 0, 0, 0, 0, 59, 108);
        for (i = 0; i <= spacing / filling; ++i) {
            guiGraphics.method_25302(this.OPTIONS_TEXTURE, 59 + filling * i, 0, 9, 0, filling, 108);
        }
        guiGraphics.method_25302(this.OPTIONS_TEXTURE, 59 + spacing, 0, 60, 0, 58, 108);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.configuration"), 59 + spacing / 2, 17, Color.WHITE.getRGB());
        for (i = 0; i < this.optionsButtonList.size(); ++i) {
            int l = 13 * i;
            this.optionsButtonList.get(i).method_46421((int)(this.optionsX.get(0) + 9.0));
            this.optionsButtonList.get(i).method_46419((int)(this.optionsY.get(0) + 29.0 + (double)l));
            guiGraphics.method_25294(9, 29 + l, 108 + spacing, 39 + l, ColorUtils.RGBToRGBA((int)Color.WHITE.getRGB(), (float)(this.optionsButtonList.get(i).method_25367() ? 0.45f : 0.25f)));
            guiGraphics.method_27534(this.field_22793, this.optionsButtonList.get(i).method_25369(), 59 + spacing / 2, 30 + l, Color.WHITE.getRGB());
        }
        this.renderOptionsTooltip(guiGraphics, (int)((double)mouseX - this.optionsX.get(0)), (int)((double)mouseY - this.optionsY.get(0)));
        if (this.isDraggingWindow) {
            guiGraphics.method_25294(7, 4, 110 + spacing, 13, ColorUtils.RGBToRGBA((int)Color.WHITE.getRGB(), (float)0.25f));
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderOptionsTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        for (class_4185 button : this.optionsButtonList) {
            if (!button.method_49606()) continue;
            class_5250 component = class_2561.method_43470((String)"\u27a4 ").method_27692(class_124.field_1063);
            Optional<Object> tooltipComponent = Optional.empty();
            if (button == this.backgroundColorButton) {
                int color = ColorUtils.RGBToRGBA((int)this.backgroundColor.color.getRGB(), (float)this.backgroundColor.getAlpha());
                component.method_10852((class_2561)class_2561.method_43471((String)String.format("gui.ultimine_addition.color.%s", this.backgroundColor.name().toLowerCase())).method_27696(class_2583.field_24360.method_36139(color)));
                tooltipComponent = Optional.of(new SkillsRecordTooltip.Option(0, (class_2561)component));
            }
            if (button == this.animationsButton) {
                component.method_10852((class_2561)(this.isAnimationsEnabled ? class_2561.method_43471((String)"options.on").method_27692(class_124.field_1060) : class_2561.method_43471((String)"options.off").method_27692(class_124.field_1061)));
            }
            if (button == this.progressionBarButton) {
                switch (this.progressMode) {
                    case 0: {
                        component.method_10852((class_2561)class_2561.method_43471((String)"options.on").method_27692(class_124.field_1060));
                        break;
                    }
                    case 1: {
                        component.method_10852((class_2561)class_2561.method_43469((String)"gui.ultimine_addition.skills_record.option.hold_keybind", (Object[])new Object[]{KeyHandler.KEY_SHOW_PROGRESSION_BAR.method_16007()}).method_27692(class_124.field_1075));
                        break;
                    }
                    case 2: {
                        component.method_10852((class_2561)class_2561.method_43471((String)"options.off").method_27692(class_124.field_1061));
                    }
                }
            }
            if (button == this.challengesPanelPosButton) {
                class_124 color = ChallengesInfoPanel.INSTANCE.getPanelPos().method_15434().equals("disabled") ? class_124.field_1061 : class_124.field_1068;
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.panel_pos.%s".formatted(ChallengesInfoPanel.INSTANCE.getPanelPos().method_15434())).method_27692(color));
                tooltipComponent = Optional.of(new SkillsRecordTooltip.Option(1, (class_2561)component));
            }
            if (button == this.challengesPanelSizeButton) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.option.soon").method_27692(class_124.field_1068));
            }
            guiGraphics.method_51448().method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_51437(this.field_22793, List.of(component.method_27692(class_124.field_1056)), tooltipComponent, mouseX, mouseY);
            guiGraphics.method_51448().method_22909();
        }
    }

    private void renderItemTooltip(class_332 guiGraphics, class_1799 stack, class_2583 style, int mouseX, int mouseY) {
        assert (this.field_22787 != null);
        AtomicInteger length = new AtomicInteger();
        List tooltip = class_437.method_25408((class_310)this.field_22787, (class_1799)stack);
        List<class_5684> tooltipComponents = tooltip.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        tooltipComponents.forEach(component -> length.set(Math.max(length.get(), component.method_32664(this.field_22793))));
        if (style.method_10970() != null) {
            class_5250 component2 = class_2561.method_43471((String)"tooltip.ultimine_addition.skills_record.press.left_click").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
            tooltipComponents.addAll(class_2477.method_10517().method_30933(this.field_22793.method_27527().method_27495((class_5348)component2, Math.max(length.get(), 150), class_2583.field_24360)).stream().map(class_5684::method_32662).toList());
        }
        boolean isExceedingWindow = mouseX + 12 + 18 + length.get() > this.field_22789;
        int alignPosX = isExceedingWindow ? 6 : 0;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        RenderSystem.setShaderColor((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue(), (float)this.backgroundColor.getAlpha());
        guiGraphics.method_25302(this.TEXTURE, mouseX + alignPosX, mouseY, 0, 227, 26, 26);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51445(stack, mouseX + alignPosX + 5, mouseY + 5);
        int spacing = 6 - tooltipComponents.size() * 6;
        guiGraphics.method_51435(this.field_22793, tooltipComponents, mouseX + 18, mouseY + 21 + spacing, class_8001.field_41687);
    }

    private boolean isConsumeChallengeExists() {
        AtomicBoolean result = new AtomicBoolean();
        this.container.getCardSlots().forEach(slot -> {
            class_1799 stack = slot.method_7677();
            MiningSkillCardData cardData = new MiningSkillCardData().loadData(stack);
            if (!cardData.getChallenges().keySet().stream().filter(identifier -> {
                if (ChallengesManager.INSTANCE.getAllChallenges().get(identifier.id()) == null) {
                    return false;
                }
                return ChallengesManager.INSTANCE.getAllChallenges().get(identifier.id()).getChallengeType().isConsuming();
            }).toList().isEmpty()) {
                result.set(true);
            }
        });
        return result.get();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isOptionsShown && this.isInsideOptionsDragBox(mouseX, mouseY)) {
                this.isDraggingWindow = true;
                return true;
            }
            if (this.isInsideScrollbar(mouseX, mouseY)) {
                this.isScrolling = this.textScreen.canScroll();
                return true;
            }
            class_2583 style = this.textScreen.getComponentStyleAt(mouseX, mouseY);
            if (style != null && style.method_10970() != null) {
                if (style.method_10970().method_10844().contains("cycle")) {
                    itemCycle += 1.0f;
                    return true;
                }
                if (style.method_10970().method_10844().contains("pin") && this.selectedSlot > -1) {
                    String[] value = style.method_10970().method_10844().split(",");
                    class_2960 challengeId = new class_2960(value[1]);
                    SkillsRecordData data = this.container.getData();
                    ((SkillsRecordData)data.togglePinned(this.selectedSlot, challengeId).sendToServer()).saveData(data.get());
                    return true;
                }
            }
            if (!this.isOptionsShown && this.isConsumeChallengeExists() && MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)this.field_2776, (int)this.field_2800, (int)86, (int)106, (int)9, (int)18)) {
                SkillsRecordData data = this.container.getData();
                ((SkillsRecordData)data.toggleConsumeMode().sendToServer()).saveData(data.get());
                return true;
            }
        }
        if (button == 1 && this.field_2787 != null && this.field_2787.method_7677() != class_1799.field_8037 && this.container.getCardSlots().contains((Object)this.field_2787)) {
            this.selectedSlot = this.selectedSlot == -1 || this.selectedSlot != this.field_2787.method_34266() ? this.field_2787.method_34266() : -1;
            SkillsRecordData data = this.container.getData();
            ((SkillsRecordData)data.setViewingCard(this.selectedSlot).sendToServer()).saveData(data.get());
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingWindow = false;
            this.isScrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int i = this.field_2800 + 15;
            int j = i + 83;
            float delta = class_3532.method_15363((float)((float)((mouseY - (double)i) / (double)(j - i))), (float)0.0f, (float)1.0f);
            this.textScreen.scrollTo((int)class_3532.method_16439((float)delta, (float)0.0f, (float)this.textScreen.getRemainingLines()), true);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.textScreen.canScroll()) {
            if (delta < 0.0) {
                this.textScreen.scrollTo(1, false);
            }
            if (delta > 0.0) {
                this.textScreen.scrollTo(-1, false);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_2787 != null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (KeyBindingHooks.isMatches(KeyHandler.KEY_SHOW_PROGRESSION_BAR, keyCode, scanCode) && this.isChallengesExists && !this.isMissingItems && !this.notEnoughInk && !this.isOptionsShown && this.progressMode == 1) {
            this.isProgressionBarShown = true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (!KeyBindingHooks.isMatches(KeyHandler.KEY_SHOW_PROGRESSION_BAR, keyCode, scanCode) && this.progressMode == 1) {
            this.isProgressionBarShown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    protected boolean method_2378(int x, int y, int width, int height, double mouseX, double mouseY) {
        int spacing = Math.max(this.getButtonsTextLength() - 100, 0);
        if (MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (double)this.optionsX.get(0), (double)this.optionsY.get(0), (double)0.0, (double)0.0, (int)(118 + spacing), (int)108)) {
            return false;
        }
        return super.method_2378(x, y, width, height, mouseX, mouseY);
    }

    private boolean isInsideScrollbar(double mouseX, double mouseY) {
        return MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)this.field_2776, (int)this.field_2800, (int)174, (int)16, (int)6, (int)82);
    }

    private boolean isInsideOptionsDragBox(double mouseX, double mouseY) {
        return MouseHelper.isMouseOver((double)((int)mouseX), (double)((int)mouseY), (double)this.optionsX.get(0), (double)this.optionsY.get(0), (double)7.0, (double)4.0, (int)104, (int)8);
    }

    private void resetOptionsWindow() {
        this.optionsX.set(0, Double.valueOf(this.field_2776 + 178));
        this.optionsY.set(0, Double.valueOf(this.field_2800));
    }

    private void createChallengesText(class_2371<class_1735> slots) {
        class_1799 stack = ((class_1735)slots.get(this.selectedSlot)).method_7677();
        MiningSkillCardData cardData = new MiningSkillCardData().loadData(stack);
        ChallengesManager manager = ChallengesManager.INSTANCE;
        AtomicInteger currentValues = new AtomicInteger();
        AtomicInteger requiredValues = new AtomicInteger();
        cardData.getChallenges().forEach((identifier, infoData) -> {
            ArrayList<class_1799> itemList = new ArrayList<class_1799>(List.of(class_1799.field_8037));
            ChallengesData challengesData = manager.getAllChallenges().get(identifier.id());
            String type = "null";
            if (challengesData != null) {
                itemList.clear();
                type = challengesData.getChallengeType().getTypeName();
                ChallengesManager.INSTANCE.utilizeTargetedBlocks(challengesData).forEach(block -> itemList.add(new class_1799((class_1935)block)));
                currentValues.addAndGet(infoData.getCurrentValue());
                requiredValues.addAndGet(infoData.getRequiredValue());
            }
            class_1799 displayItem = (class_1799)itemList.get(class_3532.method_15375((float)itemCycle) % itemList.size());
            class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(displayItem));
            class_2583 questStyle = class_2583.field_24360.method_10949(hoverEvent).method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1062);
            if (itemList.size() > 1) {
                questStyle = questStyle.method_10958(new class_2558(class_2558.class_2559.field_11746, "cycle"));
            }
            class_2561 title = ScreenUtils.limitComponent((class_2561)class_2561.method_43470((String)"\u300e").method_10852((class_2561)class_2561.method_43469((String)"challenge.ultimine_addition.title", (Object[])new Object[]{identifier.order()})).method_27693("\u300f"), (int)this.textScreen.getWidth());
            class_5250 consume = class_2561.method_43470((String)"\u2716 ").method_10852((class_2561)class_2561.method_43471((String)"challenge.ultimine_addition.consume")).method_27692(class_124.field_1061);
            class_2561 description = SkillsRecordScreen.createChallengeDescription(type, questStyle, itemList, itemCycle);
            class_2583 descStyle = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080);
            class_2583 counterStyle = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1065);
            if (challengesData != null && challengesData.getChallengeType().isConsuming() && !this.container.getData().isConsumeMode() && !cardData.isChallengeAccomplished(identifier.id())) {
                class_2568 consumeRequired = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"challenge.ultimine_addition.consume.info").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                counterStyle = class_2583.field_24360.method_10949(consumeRequired).method_36140(Boolean.valueOf(true)).method_10977(class_124.field_1061);
            } else if (challengesData != null && challengesData.getChallengeType().isConsuming() && this.container.getData().isConsumeMode() && !cardData.isChallengeAccomplished(identifier.id())) {
                counterStyle = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1064);
            } else if (cardData.isChallengeAccomplished(identifier.id())) {
                counterStyle = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1060);
            }
            ArrayList<class_5481> result = new ArrayList<class_5481>(class_2477.method_10517().method_30933(this.field_22793.method_27527().method_27495((class_5348)title, this.textScreen.getWidth(), title.method_10866())));
            if (challengesData != null && challengesData.getChallengeType().isConsuming()) {
                result.addAll(class_2477.method_10517().method_30933(this.field_22793.method_27527().method_27495((class_5348)consume, this.textScreen.getWidth(), consume.method_10866())));
            }
            result.addAll(class_2477.method_10517().method_30933(this.field_22793.method_27527().method_27495((class_5348)description, this.textScreen.getWidth(), descStyle)));
            class_5481 counter = class_5481.method_30747((String)"\u27a4 %s/%s".formatted(infoData.getCurrentValue(), infoData.getRequiredValue()), (class_2583)counterStyle);
            class_2568 pinHover = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"gui.ultimine_addition.skills_record.pin").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            class_5481 pinButton = class_5481.method_30747((String)"\u25ce", (class_2583)class_2583.field_24360.method_10977(infoData.isPinned() ? class_124.field_1054 : class_124.field_1080).method_36140(Boolean.valueOf(!infoData.isPinned())).method_10949(pinHover).method_10958(new class_2558(class_2558.class_2559.field_11746, "pin,%s".formatted(identifier.id().toString()))));
            pinButton = class_5481.method_30742((class_5481)class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360), (class_5481)pinButton);
            result.add(class_5481.method_30742((class_5481)counter, (class_5481)pinButton));
            if (!this.textScreen.isEmpty()) {
                this.textScreen.add(class_5481.field_26385).addAll(result);
            } else {
                this.textScreen.addAll(result);
            }
        });
        this.calculateProgression(currentValues.get(), requiredValues.get());
    }

    public static class_2561 createChallengeDescription(String challengeType, class_2583 style, List<class_1799> items, float cycle) {
        class_1799 displayItem = items.get(class_3532.method_15375((float)cycle) % items.size());
        class_5250 info = items.size() > 1 ? class_2561.method_43469((String)"challenge.ultimine_addition.various_blocks", (Object[])new Object[]{class_2561.method_43470((String)displayItem.method_7964().getString()).method_27696(style)}) : class_2561.method_43470((String)items.get(0).method_7964().getString()).method_27696(style);
        return class_2561.method_43469((String)"challenge.ultimine_addition.%s".formatted(challengeType), (Object[])new Object[]{info});
    }

    private void calculateProgression(int currentValues, int requiredValues) {
        if (requiredValues == 0) {
            return;
        }
        float f = (float)currentValues / (float)requiredValues;
        Objects.requireNonNull(this);
        float value = f * 100.0f;
        this.currentProgress = (int)value;
    }

    public int getProgressionBarColor() {
        float f = Math.min((float)this.currentProgress / 100.0f, 1.0f);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Collection<class_768> getOptionsRect() {
        Set<class_768> collection = Collections.singleton(new class_768(0, 0, 0, 0));
        if (this.optionsButtonList.isEmpty()) {
            return collection;
        }
        int spacing = Math.max(this.getButtonsTextLength() - 100, 0);
        if (this.isOptionsShown) {
            collection = Collections.singleton(new class_768(this.optionsX.get(0).intValue(), this.optionsY.get(0).intValue(), 118 + spacing, 108));
        }
        return collection;
    }

    private int getButtonsTextLength() {
        AtomicInteger length = new AtomicInteger(0);
        this.optionsButtonList.forEach(button -> length.set(Math.max(this.field_22793.method_27525((class_5348)button.method_25369()), length.get())));
        return length.get();
    }

    public static float getItemCycle() {
        return itemCycle;
    }

    public static enum BGColor {
        DEFAULT(new Color(255, 255, 255)),
        RED(new Color(255, 116, 116)),
        ORANGE(new Color(255, 162, 94)),
        YELLOW(new Color(253, 241, 113)),
        GREEN(new Color(144, 238, 144)),
        BLUE(new Color(112, 153, 255)),
        INDIGO(new Color(126, 80, 176)),
        VIOLET(new Color(238, 130, 238));

        private final Color color;

        private BGColor(Color color) {
            this.color = color;
        }

        public float getAlpha() {
            return new ColorUtils(this.color.getRGB()).getAlpha();
        }

        public float getRed() {
            return new ColorUtils(this.color.getRGB()).getRed();
        }

        public float getGreen() {
            return new ColorUtils(this.color.getRGB()).getGreen();
        }

        public float getBlue() {
            return new ColorUtils(this.color.getRGB()).getBlue();
        }

        public BGColor next() {
            int nextIndex = (this.ordinal() + 1) % BGColor.values().length;
            return BGColor.values()[nextIndex];
        }

        public BGColor previous() {
            int prevIndex = (this.ordinal() - 1 + BGColor.values().length) % BGColor.values().length;
            return BGColor.values()[prevIndex];
        }

        public Color convert() {
            return this.color;
        }
    }
}

