/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.ixdarklord.coolcat_lib.client.gui.component.animation.AnimatedComponent;
import net.ixdarklord.coolcat_lib.client.gui.component.animation.SlideAnimation;
import net.ixdarklord.coolcat_lib.client.gui.screen.ScreenPosition;
import net.ixdarklord.coolcat_lib.util.ColorUtils;
import net.ixdarklord.coolcat_lib.util.MathUtils;
import net.ixdarklord.coolcat_lib.util.ScreenUtils;
import net.ixdarklord.ultimine_addition.client.gui.screen.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.common.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3542;
import net.minecraft.class_4668;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChallengesInfoPanel {
    private static final class_2960 HUD = new class_2960("ultimine_addition", "textures/gui/challenge_panel.png");
    public static final class_4668.class_4685 TRANSLUCENT_TRANSPARENCY = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final ChallengesInfoPanel INSTANCE = new ChallengesInfoPanel();
    private final int textureWidth = 112;
    private final int textureHeight = 32;
    private final List<Panel> PANEL_LIST = new ArrayList<Panel>();
    private Panel.Position panelPos = Panel.Position.LEFT;
    private float time;
    private float lastStamp;

    private void tick(float partialTicks) {
        if (partialTicks < this.lastStamp) {
            this.time += 1.0f - this.lastStamp;
            this.time += partialTicks;
        } else {
            this.time += partialTicks - this.lastStamp;
        }
        this.lastStamp = partialTicks;
        this.updatePos();
    }

    private void updatePos() {
        this.panelPos = (Panel.Position)((Object)ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.get());
        for (Panel panel : this.PANEL_LIST) {
            panel.getAnimatedComponent().setScreenPosition(this.panelPos.toScreenPos());
        }
    }

    public void render(class_332 guiGraphics, float partialTicks) {
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return;
        }
        class_310 MC = class_310.method_1551();
        if (MC.field_1690.field_1866) {
            return;
        }
        class_1041 window = MC.method_22683();
        class_327 font = MC.field_1772;
        class_746 player = MC.field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = ItemUtils.findItemInHand((class_1657)player, ModItems.SKILLS_RECORD);
        if (stack == class_1799.field_8037) {
            this.slideOutPanels(this.PANEL_LIST.stream().filter(Panel::isNotTestPanel));
        }
        if (!MC.method_1493() && !this.PANEL_LIST.isEmpty()) {
            this.tick(partialTicks);
        }
        if (!MC.method_1493()) {
            SkillsRecordData recordData = new SkillsRecordData().loadData(stack);
            this.createPanels(recordData);
            this.validatePanels(recordData, window, font);
            this.PANEL_LIST.forEach(panel -> panel.animatedComponent.updateAnimation());
        }
        guiGraphics.method_51448().method_22903();
        int textLength = this.getTextLength(font);
        for (int slot = 0; slot < this.PANEL_LIST.size(); ++slot) {
            Panel panel2 = this.PANEL_LIST.get(slot);
            if (panel2.isNotActive()) continue;
            AnimatedComponent animatedComponent = panel2.getAnimatedComponent();
            if (animatedComponent.getScreenPosition() == null) break;
            int[] offsets = animatedComponent.getAnimatedOffsets(window.method_4486(), window.method_4502(), panel2.getWidth() + textLength, panel2.getHeight(), 4);
            int X = offsets[0];
            int Y = this.getAlignedYPos(offsets[1], slot, 4);
            SkillsRecordScreen.BGColor bgColor = (SkillsRecordScreen.BGColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
            if (panel2.isNotMorePanel()) {
                RenderSystem.setShaderColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue(), (float)bgColor.getAlpha());
                guiGraphics.method_25290(HUD, X + 5, Y, 5.0f, 0.0f, 51, 10, 256, 256);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int spacing = 13 * Math.min(panel2.getSlot(), 3);
                double value = MathUtils.cycledBetweenValues((float)0.0f, (float)1.0f, (float)0.8f, (float)(this.time / 20.0f), (boolean)false);
                Color color = ColorUtils.blendColors((Color)new Color(6991904), (Color)new Color(9036329), (double)((Boolean)ConfigHandler.CLIENT.ANIMATIONS_MODE.get() != false ? value : 0.0));
                guiGraphics.method_25294(X + 8 + spacing, Y + 3, X + 14 + spacing, Y + 9, color.getRGB());
                RenderSystem.setShaderColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue(), (float)bgColor.getAlpha());
                guiGraphics.method_49697(HUD, X, Y + 10, panel2.getWidth() + textLength, 11, 20, 4, panel2.getWidth(), 11, 0, 10);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TRANSLUCENT_TRANSPARENCY.method_23516();
                RenderSystem.setShaderColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue(), (float)bgColor.getAlpha());
                int n = panel2.getWidth() + textLength;
                Objects.requireNonNull(font);
                guiGraphics.method_49697(HUD, X, Y + 18, n, 14 + Math.max(0, 9 * (panel2.getInfos().size() - 1)), 20, 4, panel2.getWidth(), 14, 0, 21);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TRANSLUCENT_TRANSPARENCY.method_23518();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_27534(font, panel2.getTitle(), X + (panel2.getWidth() + textLength) / 2, Y + 11, Color.WHITE.getRGB());
            } else {
                RenderSystem.setShaderColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue(), (float)bgColor.getAlpha());
                guiGraphics.method_49697(HUD, X, Y, panel2.getWidth() + textLength, 11, 20, 4, panel2.getWidth(), 11, 0, 10);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ScreenUtils.drawScrollingString((class_332)guiGraphics, (int)((int)this.time * 8), (class_327)font, (class_2561)panel2.getTitle(), (boolean)true, (int)X, (int)Y, (int)(panel2.getWidth() + textLength), (int)10, (int)4, (int)Color.WHITE.getRGB());
            }
            for (int i = 0; i < panel2.getInfos().size(); ++i) {
                Panel.Info info = panel2.getInfos().get(i);
                float value = (float)info.getCurrentValue() / (float)info.getRequiredValue() * 100.0f;
                int currentProgression = (int)value;
                class_5250 values = class_2561.method_43470((String)("%" + currentProgression)).method_27692(currentProgression >= 100 ? class_124.field_1060 : class_124.field_1065);
                int valuesXPos = font.method_27525((class_5348)values) - font.method_1727("%0");
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int n = (int)this.time * 8;
                class_5250 class_52502 = info.getMessage().method_27661().method_27692(class_124.field_1080);
                Objects.requireNonNull(font);
                ScreenUtils.drawScrollingString((class_332)guiGraphics, (int)n, (class_327)font, (class_2561)class_52502, (boolean)false, (int)(X + 2), (int)(Y + 22 + 9 * i), (int)(94 + textLength - valuesXPos), (int)8, (int)0, (int)Color.WHITE.getRGB());
                Objects.requireNonNull(font);
                guiGraphics.method_27535(font, (class_2561)values, X + textLength + 98 - valuesXPos, Y + 22 + 9 * i, Color.WHITE.getRGB());
            }
        }
        guiGraphics.method_51448().method_22909();
    }

    private void createPanels(SkillsRecordData recordData) {
        ArrayList<Panel> trashList = new ArrayList<Panel>(this.PANEL_LIST.stream().filter(panel -> !panel.getAnimatedComponent().isPlaying()).filter(Panel::isNotMorePanel).filter(Panel::isNotTestPanel).toList());
        int i = 0;
        while (i < recordData.getCardSlots().size()) {
            int cardSlot = i++;
            class_1799 cardStack = (class_1799)recordData.getCardSlots().get(cardSlot);
            MiningSkillCardData cardData = new MiningSkillCardData().loadData(cardStack);
            cardData.getChallenges().forEach((identifier, infoData) -> {
                this.PANEL_LIST.removeIf(panel -> panel.getUUID() == null || !panel.getUUID().equals(recordData.getUUID()));
                List<Panel> list = this.PANEL_LIST.stream().filter(panel -> panel.getSlot() == cardSlot).toList();
                ChallengesManager manager = ChallengesManager.INSTANCE;
                ChallengesData challengesData = manager.getAllChallenges().get(identifier.id());
                class_5250 message = class_2561.method_43470((String)identifier.id().toString());
                if (challengesData != null) {
                    List<class_1799> items = manager.utilizeTargetedBlocks(challengesData).stream().map(class_1799::new).toList();
                    message = SkillsRecordScreen.createChallengeDescription(challengesData.getChallengeType().getTypeName(), class_2583.field_24360, items, SkillsRecordScreen.getItemCycle());
                }
                if (infoData.isPinned()) {
                    if (list.isEmpty()) {
                        this.PANEL_LIST.add(new Panel(recordData.getUUID(), cardSlot, new Panel.TextureDimension(112, 32), (class_2561)class_2561.method_43470((String)((class_1799)recordData.getCardSlots().get(cardSlot)).method_7964().getString()), List.of(new Panel.Info(identifier.order(), identifier.id(), (class_2561)message, infoData.getCurrentValue(), infoData.getRequiredValue())), (AnimatedComponent)new SlideAnimation(this.panelPos.toScreenPos(), 60)));
                    } else {
                        panel = list.get(0);
                        trashList.removeIf(panel1 -> panel1.equals(panel));
                        List<Panel.Info> infoList = panel.getInfos();
                        AnimatedComponent component = panel.getAnimatedComponent();
                        List<Panel.Info> filteredInfoList = infoList.stream().filter(info -> info.getChallengeId().equals((Object)identifier.id())).toList();
                        if (filteredInfoList.isEmpty()) {
                            infoList.add(new Panel.Info(identifier.order(), identifier.id(), (class_2561)message, infoData.getCurrentValue(), infoData.getRequiredValue()));
                        } else {
                            class_5250 finalMessage = message;
                            filteredInfoList.forEach(arg_0 -> ChallengesInfoPanel.lambda$createPanels$8((class_2561)finalMessage, arg_0));
                            filteredInfoList.forEach(info -> {
                                info.setCurrentValue(infoData.getCurrentValue());
                                info.setRequiredValue(infoData.getRequiredValue());
                            });
                        }
                        if (component.isPlaying() && !component.isEnteringScene()) {
                            panel.getAnimatedComponent().startAnimation(true);
                        }
                    }
                } else if (!list.isEmpty()) {
                    panel = list.get(0);
                    List<Panel.Info> infoList = panel.getInfos();
                    infoList.removeIf(info -> info.getChallengeId().equals((Object)identifier.id()));
                }
            });
        }
        this.slideOutPanels(trashList.stream());
    }

    private void validatePanels(SkillsRecordData recordData, class_1041 window, class_327 font) {
        Panel panel2;
        this.PANEL_LIST.forEach(panel -> panel.setActive(true));
        int slot = this.PANEL_LIST.size();
        while (slot-- > 0) {
            Panel panel3 = this.PANEL_LIST.get(slot);
            if (panel3.isNotActive() || panel3.isMorePanel) continue;
            AnimatedComponent animatedComponent = panel3.getAnimatedComponent();
            if (animatedComponent.getScreenPosition() == null) break;
            int offsetY = animatedComponent.getAnimatedOffsets(0, window.method_4502(), 0, panel3.getHeight(), 4)[1];
            int Y = this.getAlignedYPos(offsetY, slot, 4);
            if (this.panelPos != Panel.Position.BOTTOM_LEFT && this.panelPos != Panel.Position.BOTTOM_RIGHT) {
                Y += panel3.getHeight();
            }
            if (Y >= 0 && Y <= window.method_4502() - 4) continue;
            if (this.panelPos == Panel.Position.BOTTOM_LEFT || this.panelPos == Panel.Position.BOTTOM_RIGHT) {
                this.PANEL_LIST.get(this.PANEL_LIST.size() - 1 - (slot + 1)).setActive(false);
                continue;
            }
            panel3.setActive(false);
        }
        int inactiveSlots = this.PANEL_LIST.stream().filter(Panel::isNotActive).toList().size();
        int slot2 = this.PANEL_LIST.size();
        while (slot2-- > 0) {
            panel2 = this.PANEL_LIST.get(slot2);
            AnimatedComponent component = panel2.getAnimatedComponent();
            if (component.isPlaying() && !panel2.isNotActive() || component.isEnteringScene()) continue;
            panel2.setRemoved();
        }
        List<Panel> list = this.PANEL_LIST.stream().filter(panel -> panel.getSlot() == 999).toList();
        if (inactiveSlots > 0) {
            if (list.isEmpty()) {
                this.PANEL_LIST.add(new Panel(recordData.getUUID(), 999, new Panel.TextureDimension(112, 12), (class_2561)class_2561.method_43469((String)"gui.ultimine_addition.skills_record.pin.panel", (Object[])new Object[]{inactiveSlots}), null, (AnimatedComponent)new SlideAnimation(this.panelPos.toScreenPos(), 60), true, false));
            } else {
                panel2 = list.get(0);
                panel2.setTitle((class_2561)class_2561.method_43469((String)"gui.ultimine_addition.skills_record.pin.panel", (Object[])new Object[]{inactiveSlots}));
                AnimatedComponent component = panel2.getAnimatedComponent();
                if (recordData.get() != class_1799.field_8037 && component.isPlaying() && !component.isEnteringScene()) {
                    panel2.getAnimatedComponent().startAnimation(true);
                }
            }
        } else if (!list.isEmpty()) {
            this.slideOutPanels(list.stream());
        }
        this.PANEL_LIST.removeIf(Panel::isAssignedToRemove);
        this.PANEL_LIST.sort(Comparator.comparingInt(Panel::getSlot));
    }

    private int getTextLength(class_327 font) {
        int textLength = 0;
        for (Panel panel : this.PANEL_LIST) {
            if (panel.isNotActive() || !panel.isNotMorePanel()) continue;
            textLength = Math.max(font.method_27525((class_5348)panel.getTitle()), textLength);
            textLength = Math.max(0, textLength - panel.getWidth());
        }
        return textLength > 0 ? textLength + 8 : 0;
    }

    private int getAlignedYPos(int yOffset, int slot, int padding) {
        int Y = yOffset;
        switch (this.panelPos) {
            case TOP_LEFT: 
            case TOP_RIGHT: {
                for (int i = 0; i < slot; ++i) {
                    Panel panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y += panel.getHeight() + padding;
                }
                break;
            }
            case LEFT: 
            case RIGHT: {
                Y += Math.max(0, this.PANEL_LIST.get(slot).getHeight() / 2);
                for (Panel panel : this.PANEL_LIST) {
                    if (panel.isNotActive()) continue;
                    Y -= panel.getHeight() / 2 + padding / 2;
                }
                for (int i = 0; i < slot; ++i) {
                    Panel panel;
                    panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y += panel.getHeight() + padding;
                }
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                for (int i = slot + 1; i < this.PANEL_LIST.size(); ++i) {
                    Panel panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y -= panel.getHeight() + padding;
                }
                break;
            }
        }
        return Y;
    }

    private void slideOutPanels(Stream<Panel> panelStream) {
        panelStream.map(Panel::getAnimatedComponent).filter(AnimatedComponent::isEnteringScene).forEach(component -> component.startAnimation(false));
    }

    public void setPanelPos(Panel.Position panelPos) {
        this.panelPos = panelPos;
    }

    public Panel.Position getPanelPos() {
        return this.panelPos;
    }

    private static /* synthetic */ void lambda$createPanels$8(class_2561 finalMessage, Panel.Info info) {
        info.setMessage(finalMessage);
    }

    public static class Panel {
        private boolean active = true;
        private final UUID uuid;
        private final TextureDimension textureDimension;
        private final int slot;
        private class_2561 title;
        private final List<Info> infos;
        private final AnimatedComponent animatedComponent;
        private boolean assignedToRemove;
        private final boolean isMorePanel;
        private final boolean isTestPanel;

        Panel(UUID uuid, int slot, TextureDimension textureDimension, class_2561 title, List<Info> infos, AnimatedComponent animatedComponent) {
            this(uuid, slot, textureDimension, title, infos, animatedComponent, false, false, false);
        }

        Panel(UUID uuid, int slot, TextureDimension textureDimension, class_2561 title, List<Info> infos, AnimatedComponent animatedComponent, boolean isMorePanel, boolean isTestPanel) {
            this(uuid, slot, textureDimension, title, infos, animatedComponent, false, isMorePanel, isTestPanel);
        }

        Panel(UUID uuid, int slot, TextureDimension textureDimension, class_2561 title, List<Info> infos, AnimatedComponent animatedComponent, boolean assignedToRemove, boolean isMorePanel, boolean isTestPanel) {
            this.uuid = uuid;
            this.slot = slot;
            this.textureDimension = textureDimension;
            this.title = title;
            this.infos = infos == null ? new ArrayList<Info>() : new ArrayList<Info>(infos);
            this.animatedComponent = animatedComponent;
            this.assignedToRemove = assignedToRemove;
            this.isMorePanel = isMorePanel;
            this.isTestPanel = isTestPanel;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setTitle(class_2561 title) {
            this.title = title;
        }

        public void setRemoved() {
            this.assignedToRemove = true;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public boolean isNotActive() {
            return !this.active;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getWidth() {
            return this.textureDimension.width();
        }

        public int getHeight() {
            int n = this.textureDimension.height();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            return n + Math.max(0, 9 * (this.infos.size() - 1));
        }

        public TextureDimension getTextureDimension() {
            return this.textureDimension;
        }

        public class_2561 getTitle() {
            return this.title;
        }

        public List<Info> getInfos() {
            if (this.infos == null) {
                return new ArrayList<Info>();
            }
            this.infos.sort(Comparator.comparingInt(o -> o.order));
            return this.infos;
        }

        public AnimatedComponent getAnimatedComponent() {
            return this.animatedComponent;
        }

        public boolean isAssignedToRemove() {
            return this.assignedToRemove;
        }

        public boolean isNotMorePanel() {
            return !this.isMorePanel;
        }

        public boolean isNotTestPanel() {
            return !this.isTestPanel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Panel panel = (Panel)o;
            return this.active == panel.active && this.slot == panel.slot && this.assignedToRemove == panel.assignedToRemove && this.isMorePanel == panel.isMorePanel && this.isTestPanel == panel.isTestPanel && Objects.equals(this.uuid, panel.uuid) && Objects.equals(this.textureDimension, panel.textureDimension) && Objects.equals(this.title, panel.title) && Objects.equals(this.infos, panel.infos) && Objects.equals(this.animatedComponent, panel.animatedComponent);
        }

        public int hashCode() {
            return Objects.hash(this.active, this.uuid, this.textureDimension, this.slot, this.title, this.infos, this.animatedComponent, this.assignedToRemove, this.isMorePanel, this.isTestPanel);
        }

        public record TextureDimension(int width, int height) {
        }

        public static class Info {
            private final int order;
            private final class_2960 challengeId;
            private class_2561 message;
            private int currentValue;
            private int requiredValue;

            private Info(int order, class_2960 challengeId, class_2561 message, int currentValue, int requiredValue) {
                this.order = order;
                this.challengeId = challengeId;
                this.message = message;
                this.currentValue = currentValue;
                this.requiredValue = requiredValue;
            }

            public class_2960 getChallengeId() {
                return this.challengeId;
            }

            public class_2561 getMessage() {
                return this.message;
            }

            public int getCurrentValue() {
                return this.currentValue;
            }

            public int getRequiredValue() {
                return this.requiredValue;
            }

            public void setMessage(class_2561 message) {
                this.message = message;
            }

            public void setCurrentValue(int currentValue) {
                this.currentValue = currentValue;
            }

            public void setRequiredValue(int requiredValue) {
                this.requiredValue = requiredValue;
            }
        }

        public static enum Position implements class_3542
        {
            DISABLED(-1, null),
            TOP_LEFT(0, ScreenPosition.TOP_LEFT),
            TOP_RIGHT(2, ScreenPosition.TOP_RIGHT),
            LEFT(3, ScreenPosition.LEFT),
            RIGHT(5, ScreenPosition.RIGHT),
            BOTTOM_LEFT(6, ScreenPosition.BOTTOM_LEFT),
            BOTTOM_RIGHT(8, ScreenPosition.BOTTOM_RIGHT);

            private final int posIndex;
            @Nullable
            private final ScreenPosition screenPos;

            private Position(int posIndex, ScreenPosition screenPos) {
                this.posIndex = posIndex;
                this.screenPos = screenPos;
            }

            @Nullable
            public ScreenPosition toScreenPos() {
                return this.screenPos;
            }

            public Position next() {
                int nextOrdinal = (this.ordinal() + 1) % Position.values().length;
                return Position.values()[nextOrdinal];
            }

            public Position previous() {
                int previousOrdinal = (this.ordinal() - 1 + Position.values().length) % Position.values().length;
                return Position.values()[previousOrdinal];
            }

            @NotNull
            public String method_15434() {
                return this.name().toLowerCase();
            }

            public int getPosIndex() {
                return this.posIndex;
            }
        }
    }
}

