/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.ixdarklord.ultimine_addition.client.gui.component.SkillsRecordTooltip;
import net.ixdarklord.ultimine_addition.client.gui.screen.ChallengesInfoPanel;
import net.ixdarklord.ultimine_addition.client.gui.screen.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.config.ConfigHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

@Environment(value=EnvType.CLIENT)
public class ClientSkillsRecordTooltip
implements class_5684 {
    public static final class_2960 TEXTURE_LOCATION = new class_2960("textures/gui/container/bundle.png");
    private final class_2371<class_1799> items;

    public ClientSkillsRecordTooltip(SkillsRecordTooltip skillsRecordTooltip) {
        this.items = skillsRecordTooltip.getItems();
    }

    public int method_32661() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int method_32664(class_327 font) {
        return this.gridSizeX() * 18 + 2;
    }

    public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = x + m * 18 + 1;
                int o = y + l * 20 + 1;
                this.renderSlot(n, o, k++, guiGraphics, font);
            }
        }
        this.drawBorder(x, y, i, j, guiGraphics);
    }

    private void renderSlot(int x, int y, int itemIndex, class_332 guiGraphics, class_327 font) {
        if (itemIndex >= this.items.size()) {
            this.blit(guiGraphics, x, y, Texture.SLOT);
        } else {
            class_1799 itemStack = (class_1799)this.items.get(itemIndex);
            this.blit(guiGraphics, x, y, Texture.SLOT);
            guiGraphics.method_51428(itemStack, x + 1, y + 1, itemIndex);
            guiGraphics.method_51431(font, itemStack, x + 1, y + 1);
        }
    }

    private void drawBorder(int x, int y, int slotWidth, int slotHeight, class_332 guiGraphics) {
        int i;
        this.blit(guiGraphics, x, y, Texture.BORDER_CORNER_TOP);
        this.blit(guiGraphics, x + slotWidth * 18 + 1, y, Texture.BORDER_CORNER_TOP);
        for (i = 0; i < slotWidth; ++i) {
            this.blit(guiGraphics, x + 1 + i * 18, y, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(guiGraphics, x + 1 + i * 18, y + slotHeight * 20, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (i = 0; i < slotHeight; ++i) {
            this.blit(guiGraphics, x, y + i * 20 + 1, Texture.BORDER_VERTICAL);
            this.blit(guiGraphics, x + slotWidth * 18 + 1, y + i * 20 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(guiGraphics, x, y + slotHeight * 20, Texture.BORDER_CORNER_BOTTOM);
        this.blit(guiGraphics, x + slotWidth * 18 + 1, y + slotHeight * 20, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(class_332 guiGraphics, int x, int y, Texture texture) {
        SkillsRecordScreen.BGColor bgColor = (SkillsRecordScreen.BGColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        RenderSystem.setShaderColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue(), (float)bgColor.getAlpha());
        guiGraphics.method_25291(TEXTURE_LOCATION, x, y, 0, (float)texture.x, (float)texture.y, texture.w, texture.h, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int gridSizeX() {
        return this.items.size();
    }

    private int gridSizeY() {
        return 1;
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    public static class Option
    implements class_5684 {
        private final int buttonId;
        private final class_2561 textComponent;

        public Option(SkillsRecordTooltip.Option option) {
            this.buttonId = option.buttonId();
            this.textComponent = option.textComponent();
        }

        public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
            switch (this.buttonId) {
                case 0: {
                    this.renderBGColors(font, x, y, guiGraphics);
                    break;
                }
                case 1: {
                    this.renderPanelPos(font, x, y, guiGraphics);
                }
            }
        }

        private void renderBGColors(class_327 font, int x, int y, class_332 guiGraphics) {
            int gridSize = 3;
            int cellSpacing = 2;
            int cellWidth = (this.method_32664(font) - gridSize * cellSpacing) / gridSize;
            int cellHeight = (this.method_32661() - gridSize * cellSpacing) / gridSize;
            SkillsRecordScreen.BGColor[] colors = SkillsRecordScreen.BGColor.values();
            int colorIndex = 0;
            for (int row = 0; row < gridSize; ++row) {
                for (int col = 0; col < gridSize; ++col) {
                    int adjuster = 2 + Math.max(0, font.method_27525((class_5348)this.textComponent) - this.method_32664(font)) / 2;
                    int minX = x + col * (cellWidth + cellSpacing) + adjuster;
                    int minY = y + row * (cellHeight + cellSpacing);
                    int maxX = minX + cellWidth;
                    int maxY = minY + cellHeight;
                    colorIndex = row * gridSize + col;
                    guiGraphics.method_25294(minX, minY, maxX, maxY, colors[colorIndex].convert().getRGB());
                    class_2960 texture = new class_2960("textures/gui/container/beacon.png");
                    int textureX = minX + (cellWidth - 18) / 2;
                    int textureY = minY + (cellHeight - 18) / 2;
                    if (colorIndex == ((SkillsRecordScreen.BGColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get())).ordinal()) {
                        guiGraphics.method_25302(texture, textureX + 1, textureY, 90, 220, 18, 18);
                    }
                    if (colorIndex >= colors.length - 1) break;
                }
                if (colorIndex >= colors.length - 1) break;
            }
        }

        private void renderPanelPos(class_327 font, int x, int y, class_332 guiGraphics) {
            int gridSize = 3;
            int cellSpacing = 2;
            int cellWidth = (this.method_32664(font) - gridSize * cellSpacing) / gridSize;
            int cellHeight = (this.method_32661() - gridSize * cellSpacing) / gridSize;
            int[] disabledPositions = new int[]{1, 4, 7};
            for (int row = 0; row < gridSize; ++row) {
                for (int col = 0; col < gridSize; ++col) {
                    int directionIndex;
                    Color color;
                    int adjuster = 2 + Math.max(0, font.method_27525((class_5348)this.textComponent) - this.method_32664(font)) / 2;
                    int minX = x + col * (cellWidth + cellSpacing) + adjuster;
                    int minY = y + row * (cellHeight + cellSpacing);
                    int maxX = minX + cellWidth;
                    int maxY = minY + cellHeight;
                    int selectedDirection = ((ChallengesInfoPanel.Panel.Position)((Object)ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.get())).getPosIndex();
                    Color color2 = color = selectedDirection == (directionIndex = row * gridSize + col) ? Color.GREEN : Color.GRAY;
                    if (Arrays.stream(disabledPositions).anyMatch(value -> value == directionIndex)) {
                        color = Color.DARK_GRAY.darker();
                    }
                    guiGraphics.method_25294(minX, minY, maxX, maxY, color.getRGB());
                    class_2960 texture = new class_2960("textures/gui/container/beacon.png");
                    int textureX = minX + (cellWidth - 18) / 2;
                    int textureY = minY + (cellHeight - 18) / 2;
                    if (directionIndex == selectedDirection) {
                        guiGraphics.method_25302(texture, textureX + 1, textureY, 90, 220, 18, 18);
                    }
                    if (directionIndex != 4 || selectedDirection != ChallengesInfoPanel.Panel.Position.DISABLED.getPosIndex()) continue;
                    guiGraphics.method_25302(texture, textureX + 1, textureY, 112, 220, 18, 18);
                }
            }
        }

        public int method_32661() {
            return 64;
        }

        public int method_32664(class_327 font) {
            return 64;
        }
    }
}

