/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.api;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.ixdarklord.ultimine_addition.api.IUAPlugin;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UAApi {
    private static final Logger LOGGER = LogManager.getLogger((String)"Ultimine Addition/API");
    private static final Collection<IUAPlugin> plugins = new HashSet<IUAPlugin>();

    public static void init() {
        UAApi.call("Registering plugin", plugins, plugin -> plugin.register(new IUAPlugin.Registration((IUAPlugin)plugin)));
        if (!plugins.isEmpty()) {
            LOGGER.info("Loaded {} plugins", (Object)plugins.size());
        }
    }

    private static void call(String title, Collection<IUAPlugin> plugins, Consumer<IUAPlugin> func) {
        ArrayList<IUAPlugin> invalidPlugins = new ArrayList<IUAPlugin>();
        for (IUAPlugin plugin : plugins) {
            try {
                class_2960 pluginUid = plugin.getUid();
                LOGGER.info("{}: {}...", (Object)title, (Object)pluginUid);
                Stopwatch stopwatch = Stopwatch.createStarted();
                func.accept(plugin);
                LOGGER.info("{}: {} took {}", (Object)title, (Object)pluginUid, (Object)stopwatch);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Caught an error from mod plugin: {} {}", plugin.getClass(), (Object)plugin.getUid(), (Object)e);
                invalidPlugins.add(plugin);
            }
        }
        plugins.removeAll(invalidPlugins);
    }

    public static List<IUAPlugin.Registration> getRegistrations() {
        return plugins.stream().map(plugin -> {
            IUAPlugin.Registration registration = new IUAPlugin.Registration((IUAPlugin)plugin);
            Consumer<IUAPlugin> consumer = p -> p.register(registration);
            consumer.accept((IUAPlugin)plugin);
            return registration;
        }).toList();
    }

    public static Collection<MiningSkillCardItem.Type> getTypes() {
        return UAApi.getRegistrations().stream().map(IUAPlugin.Registration::getTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

