/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.api;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.class_1802;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMSCApi {
    private static final Logger LOGGER = LogManager.getLogger((String)"Ultimine Addition/API/CustomMSC");
    public static final String dir = String.format("%s/%s/custom_cards", Platform.getConfigFolder(), "ultimine_addition");
    public static List<MiningSkillCardItem.Type> CUSTOM_TYPES = new ArrayList<MiningSkillCardItem.Type>();

    public static void init() {
        try {
            CUSTOM_TYPES = CustomMSCApi.readFrom();
            MiningSkillCardItem.Type.refreshTypes();
        }
        catch (IOException err) {
            LOGGER.error((Object)err);
        }
    }

    private static List<MiningSkillCardItem.Type> readFrom() throws IOException {
        File[] jsonFiles;
        ArrayList<MiningSkillCardItem.Type> items = new ArrayList<MiningSkillCardItem.Type>();
        HashSet<String> uniqueIds = new HashSet<String>();
        File directory = new File(CustomMSCApi.dir);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory: .config/" + CustomMSCApi.dir);
        }
        if (directory.isDirectory() && (jsonFiles = directory.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            LOGGER.info("Loading Custom Mining Skill Cards...");
            Stopwatch stopwatch = Stopwatch.createStarted();
            for (File jsonFile : jsonFiles) {
                try (FileReader reader = new FileReader(jsonFile);){
                    MiningSkillCardItem.Type type = (MiningSkillCardItem.Type)MiningSkillCardItem.Type.CARD_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).result().orElseThrow(() -> new RuntimeException("Failed to load custom card: " + jsonFile.getAbsolutePath()));
                    if (!type.isActive()) {
                        LOGGER.warn("[Disabled] Skipping custom card: \"{}\"...", (Object)type.getId());
                        continue;
                    }
                    if (type.getId().isEmpty() || type.getDefaultDisplayItem() == null || type.getDefaultDisplayItem() == class_1802.field_8162) {
                        throw new RuntimeException("Invalid data for card type: " + type.getId());
                    }
                    if (uniqueIds.contains(type.getId())) {
                        throw new RuntimeException("Duplicate ID found: " + type.getId());
                    }
                    if (type.getRequiredTools().isEmpty()) {
                        throw new RuntimeException("Required tools are empty for card type: " + type.getId());
                    }
                    uniqueIds.add(type.getId());
                    items.add(type);
                    LOGGER.info("[Enabled] Custom card \"{}\" is loaded.", (Object)type.getId());
                }
            }
            if (!items.isEmpty()) {
                LOGGER.info("Loaded {} Custom Mining Skill Cards took {}.", (Object)items.size(), (Object)stopwatch);
            }
        }
        return items;
    }

    public static void printJson() {
        MiningSkillCardItem.Type type = new MiningSkillCardItem.Type(true, "test", List.of(), class_1802.field_8077);
        MiningSkillCardItem.Type.CARD_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)type).result().ifPresent(jsonElement -> System.out.println(jsonElement.getAsJsonObject().toString()));
    }
}

