/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public interface IKeyLockable {
    public static final int MAX_ITEM_NAME_LEN = 50;

    public void setPassword(String var1);

    public String getPassword();

    public void clearPassword();

    default public void onPasswordCleared(class_1657 player, class_2338 pos) {
        player.method_7353((class_2561)class_2561.method_43471((String)"message.supplementaries.safe.cleared"), true);
        player.method_37908().method_8396(null, pos, class_3417.field_15082, class_3419.field_15245, 0.5f, 1.5f);
    }

    default public boolean shouldShowPassword() {
        String password = this.getPassword();
        return password != null && password.length() <= 50;
    }

    default public void onKeyAssigned(class_1937 level, class_2338 pos, class_1657 player, String newKey) {
        class_5250 message = this.shouldShowPassword() ? class_2561.method_43469((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{newKey}) : class_2561.method_43471((String)"message.supplementaries.safe.assigned_key_generic");
        player.method_7353((class_2561)message, true);
        level.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15082, class_3419.field_15245, 0.5f, 1.5f);
    }

    default public KeyStatus getKeyStatus(class_1799 key) {
        return IKeyLockable.getKeyStatus(key, this.getPassword());
    }

    public static KeyStatus getKeyStatus(class_1799 key, String password) {
        String correct = IKeyLockable.getKeyPassword(key);
        if (correct != null) {
            if (correct.equals(password)) {
                return KeyStatus.CORRECT_KEY;
            }
            return KeyStatus.INCORRECT_KEY;
        }
        return KeyStatus.NO_KEY;
    }

    @Nullable
    public static String getKeyPassword(class_1799 key) {
        class_1792 class_17922 = key.method_7909();
        if (class_17922 instanceof KeyItem) {
            KeyItem k = (KeyItem)class_17922;
            return k.getPassword(key);
        }
        if (key.method_31573(ModTags.KEYS)) {
            return ModRegistry.KEY_ITEM.get().getPassword(key);
        }
        return null;
    }

    default public boolean testIfHasCorrectKey(class_1657 player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = ItemsUtil.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.method_7353((class_2561)class_2561.method_43471((String)("message.supplementaries." + translName + ".locked")), true);
        }
        return false;
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;


        public boolean isCorrect() {
            return this == CORRECT_KEY;
        }
    }
}

