/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements Codec<T> {
    private final BiMap<class_2960, T> map = HashBiMap.create();
    private final String name;

    public MapRegistry(String name) {
        this.name = name;
    }

    @Deprecated(forRemoval=true)
    public MapRegistry() {
        this.name = "unnamed";
    }

    public static <B> CodecMapRegistry<B> ofCodec(String name) {
        return new CodecMapRegistry(name);
    }

    public static <B> CodecMapRegistry<B> ofCodec() {
        return new CodecMapRegistry("unnamed");
    }

    public <E> Codec<E> dispatch(Function<? super E, ? extends T> type) {
        return super.dispatch(type, c -> (Codec)c);
    }

    public <B extends T> T register(class_2960 name, B value) {
        this.map.put((Object)name, value);
        return value;
    }

    public <B extends T> T register(String name, B value) {
        this.register(new class_2960(name), value);
        return value;
    }

    @Nullable
    public T getValue(class_2960 name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public T getValue(String name) {
        return this.getValue(new class_2960(name));
    }

    @Nullable
    public class_2960 getKey(T value) {
        return (class_2960)this.map.inverse().get(value);
    }

    public Set<class_2960> keySet() {
        return this.map.keySet();
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public Set<Map.Entry<class_2960, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(class_2960 name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return class_2960.field_25139.decode(ops, json).flatMap(pair -> {
            class_2960 id = (class_2960)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Could not find any entry with key '" + id + "' in registry [" + this.name + "] \n Known keys: " + this.keySet()) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        class_2960 id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Could not find element " + object + " in registry" + this.name) : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }

    public void clear() {
        this.map.clear();
    }
}

