/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DraggableListPane<T extends Slot>
extends ScrollListPane<T> {
    private boolean clicked = false;
    private Integer frameColor = new Color(-6250336).getRGB();
    private boolean dragging = false;
    private boolean didDrag = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;

    public DraggableListPane(JmUI parent, class_310 mc, int width, int height, int x, int y) {
        super(parent, mc, width, height, 0, height, 20);
        this.field_19088 = x;
        this.field_19087 = x + width;
        this.field_19085 = y;
        this.field_19086 = y + height;
    }

    @Override
    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTicks) {
        super.method_25394(graphics, pMouseX, pMouseY, pPartialTicks);
    }

    @Override
    public void setSlots(List<T> slots) {
        int newWidth = this.field_22742;
        int newHeight = this.field_22743;
        super.setSlots(slots);
        for (Slot slot : this.getRootSlots()) {
            if (!(slot instanceof CategorySlot)) continue;
            newHeight = ((CategorySlot)slot).getAllChildMetadata().size() * 25;
            for (SlotMetadata child : ((CategorySlot)slot).getAllChildMetadata()) {
                String name = child.getName();
                int sWidth = class_310.method_1551().field_1772.method_1727(name) * 2;
                newWidth = Math.max(sWidth, newWidth);
            }
        }
        this.method_25323(newWidth, newHeight, this.field_19085, this.field_19086);
    }

    @Override
    public void method_25323(int width, int height, int top, int bottom) {
        this.field_22742 = width;
        this.field_22743 = height;
        this.field_19085 = top;
        this.field_19086 = top + height;
        this.field_19087 = this.field_19088 + width;
        this.scrollbarX = this.field_22742 - this.hpad + this.field_19088;
        this.listWidth = this.field_22742 - this.hpad * 4;
    }

    @Override
    protected void method_25325(class_332 graphics) {
        if (this.clicked) {
            graphics.method_25296(this.field_19088, this.field_19085, this.field_19087, this.field_19086, -1072689136, -804253680);
            float alpha = 1.0f;
            DrawUtil.drawRectangle(graphics.method_51448(), this.field_19088 - 1, this.field_19085 - 1, this.field_22742 + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), this.field_19088 - 1, this.field_19085 + this.field_22743, this.field_22742 + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), this.field_19088 - 1, this.field_19085 - 1, 1.0, this.field_22743 + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), this.field_22742 + this.field_19088, this.field_19085 - 1, 1.0, this.field_22743 + 2, this.frameColor, alpha);
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        boolean paneClicked = false;
        if (super.method_25405(pMouseX, pMouseY) && !(this.method_25308(pMouseX, pMouseY) instanceof CategorySlot)) {
            paneClicked = super.method_25402(pMouseX, pMouseY, pButton);
        } else if (super.method_25405(pMouseX, pMouseY) && this.method_25308(pMouseX, pMouseY) instanceof CategorySlot) {
            this.mouseDragOffsetX = (int)(pMouseX - (double)this.field_19088);
            this.mouseDragOffsetY = (int)(pMouseY - (double)this.field_19085);
            this.dragging = true;
        }
        return paneClicked;
    }

    @Override
    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.didDrag = true;
            int posX = (int)(pMouseX - (double)this.mouseDragOffsetX);
            int posY = (int)(pMouseY - (double)this.mouseDragOffsetY);
            this.updatePosition(posX, posY);
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && this.didDrag) {
            this.didDrag = false;
            this.dragging = false;
        } else if (super.method_25405(mouseX, mouseY) && this.method_25308(mouseX, mouseY) instanceof CategorySlot) {
            this.didDrag = false;
            this.dragging = false;
            super.method_25402(mouseX, mouseY, mouseButton);
            CategorySlot slot = (CategorySlot)this.method_25308(mouseX, mouseY);
            this.clicked = slot.isSelected();
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public void updatePosition(int x, int y) {
        this.field_19085 = y;
        this.field_19086 = this.field_19085 + this.field_22743;
        this.field_19088 = x;
        this.field_19087 = this.field_19088 + this.field_22742;
        this.scrollbarX = this.field_22742 - this.hpad + this.field_19088;
        this.listWidth = this.field_22742 - this.hpad * 4;
    }
}

