/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;

public class DynamicTextureImpl
extends class_1043
implements Texture {
    private float alpha;
    protected String description;
    private Integer renderWidth;
    private Integer renderHeight;
    private final Float2ObjectMap<Texture> scaledImageMap = new Float2ObjectOpenHashMap();
    @Nullable
    private class_2960 resourceLocation;

    public DynamicTextureImpl(class_1011 nativeImage) {
        super(nativeImage);
    }

    public DynamicTextureImpl(class_1011 nativeImage, class_2960 location) {
        this(nativeImage);
        this.resourceLocation = location;
    }

    public DynamicTextureImpl(int width, int height, boolean useCalloc) {
        this(new class_1011(width, height, useCalloc));
    }

    @Override
    @Nullable
    public class_2960 getLocation() {
        return this.resourceLocation;
    }

    public void method_4524() {
        try {
            if (super.method_4525() != null) {
                super.method_23207();
                super.method_4525().method_4301(0, 0, 0, false);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error uploading image to framebuffer:", (Throwable)e);
        }
    }

    @Override
    public int getWidth() {
        return this.renderWidth == null ? super.method_4525().method_4307() : this.renderWidth.intValue();
    }

    @Override
    public int getHeight() {
        return this.renderHeight == null ? super.method_4525().method_4323() : this.renderHeight.intValue();
    }

    @Override
    public void setDisplayWidth(int width) {
        this.renderWidth = width;
    }

    @Override
    public void setDisplayHeight(int height) {
        this.renderHeight = height;
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        if (drawScale == 1.0f) {
            return this;
        }
        Texture scaledTexture = (Texture)this.scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                class_1011 img = ImageUtil.getScaledImage(drawScale, super.method_4525(), false);
                scaledTexture = new DynamicTextureImpl(img);
                this.scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.getNativeImage().method_4315(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public int getTextureId() {
        return this.field_5204;
    }

    @Override
    public void release() {
        super.method_4528();
    }

    @Override
    public boolean hasImage() {
        return super.method_4525() != null && super.method_4525().field_4988 > 0L;
    }

    @Override
    public void remove() {
        ImageUtil.clearAndClose(super.method_4525());
    }

    @Override
    public void setNativeImage(class_1011 image) {
        super.method_4526(image);
    }

    @Override
    public class_1011 getNativeImage() {
        return super.method_4525();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

