/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.config;

import com.google.common.collect.Lists;
import java.util.List;
import me.frankv.jmi.config.IClientConfig;
import me.frankv.jmi.util.FileManager;

public class ClientConfig
implements IClientConfig {
    private static final FileManager<ClientConfig> FILE_MANAGER = new FileManager<ClientConfig>("/config/jmi-client.json", ClientConfig.class);
    private Boolean ftbChunks = true;
    private Boolean waystone = true;
    private List<String> waypointMessageBlocks = Lists.newArrayList();
    private Boolean waypointMessageEmptyHandOnly = true;
    private Double claimedChunkOverlayOpacity = 0.222223;
    private Boolean disableFTBFunction = true;
    private Integer waystoneColor = 0xFFFFFF;
    private Integer defaultConfigVersion = -1;

    public static ClientConfig loadConfig() {
        if (FILE_MANAGER.getFile().exists()) {
            return FILE_MANAGER.read();
        }
        ClientConfig config = new ClientConfig();
        FILE_MANAGER.write(config);
        return config;
    }

    @Override
    public Boolean getFtbChunks() {
        return this.ftbChunks;
    }

    @Override
    public Boolean getWaystone() {
        return this.waystone;
    }

    public List<String> getWaypointMessageBlocks() {
        return this.waypointMessageBlocks;
    }

    @Override
    public Boolean getWaypointMessageEmptyHandOnly() {
        return this.waypointMessageEmptyHandOnly;
    }

    @Override
    public Double getClaimedChunkOverlayOpacity() {
        return this.claimedChunkOverlayOpacity;
    }

    @Override
    public Boolean getDisableFTBFunction() {
        return this.disableFTBFunction;
    }

    @Override
    public Integer getWaystoneColor() {
        return this.waystoneColor;
    }

    @Override
    public Integer getDefaultConfigVersion() {
        return this.defaultConfigVersion;
    }

    public void setFtbChunks(Boolean ftbChunks) {
        this.ftbChunks = ftbChunks;
    }

    public void setWaystone(Boolean waystone) {
        this.waystone = waystone;
    }

    public void setWaypointMessageBlocks(List<String> waypointMessageBlocks) {
        this.waypointMessageBlocks = waypointMessageBlocks;
    }

    public void setWaypointMessageEmptyHandOnly(Boolean waypointMessageEmptyHandOnly) {
        this.waypointMessageEmptyHandOnly = waypointMessageEmptyHandOnly;
    }

    public void setClaimedChunkOverlayOpacity(Double claimedChunkOverlayOpacity) {
        this.claimedChunkOverlayOpacity = claimedChunkOverlayOpacity;
    }

    public void setDisableFTBFunction(Boolean disableFTBFunction) {
        this.disableFTBFunction = disableFTBFunction;
    }

    public void setWaystoneColor(Integer waystoneColor) {
        this.waystoneColor = waystoneColor;
    }

    public void setDefaultConfigVersion(Integer defaultConfigVersion) {
        this.defaultConfigVersion = defaultConfigVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ftbChunks = this.getFtbChunks();
        Boolean other$ftbChunks = other.getFtbChunks();
        if (this$ftbChunks == null ? other$ftbChunks != null : !((Object)this$ftbChunks).equals(other$ftbChunks)) {
            return false;
        }
        Boolean this$waystone = this.getWaystone();
        Boolean other$waystone = other.getWaystone();
        if (this$waystone == null ? other$waystone != null : !((Object)this$waystone).equals(other$waystone)) {
            return false;
        }
        Boolean this$waypointMessageEmptyHandOnly = this.getWaypointMessageEmptyHandOnly();
        Boolean other$waypointMessageEmptyHandOnly = other.getWaypointMessageEmptyHandOnly();
        if (this$waypointMessageEmptyHandOnly == null ? other$waypointMessageEmptyHandOnly != null : !((Object)this$waypointMessageEmptyHandOnly).equals(other$waypointMessageEmptyHandOnly)) {
            return false;
        }
        Double this$claimedChunkOverlayOpacity = this.getClaimedChunkOverlayOpacity();
        Double other$claimedChunkOverlayOpacity = other.getClaimedChunkOverlayOpacity();
        if (this$claimedChunkOverlayOpacity == null ? other$claimedChunkOverlayOpacity != null : !((Object)this$claimedChunkOverlayOpacity).equals(other$claimedChunkOverlayOpacity)) {
            return false;
        }
        Boolean this$disableFTBFunction = this.getDisableFTBFunction();
        Boolean other$disableFTBFunction = other.getDisableFTBFunction();
        if (this$disableFTBFunction == null ? other$disableFTBFunction != null : !((Object)this$disableFTBFunction).equals(other$disableFTBFunction)) {
            return false;
        }
        Integer this$waystoneColor = this.getWaystoneColor();
        Integer other$waystoneColor = other.getWaystoneColor();
        if (this$waystoneColor == null ? other$waystoneColor != null : !((Object)this$waystoneColor).equals(other$waystoneColor)) {
            return false;
        }
        Integer this$defaultConfigVersion = this.getDefaultConfigVersion();
        Integer other$defaultConfigVersion = other.getDefaultConfigVersion();
        if (this$defaultConfigVersion == null ? other$defaultConfigVersion != null : !((Object)this$defaultConfigVersion).equals(other$defaultConfigVersion)) {
            return false;
        }
        List<String> this$waypointMessageBlocks = this.getWaypointMessageBlocks();
        List<String> other$waypointMessageBlocks = other.getWaypointMessageBlocks();
        return !(this$waypointMessageBlocks == null ? other$waypointMessageBlocks != null : !((Object)this$waypointMessageBlocks).equals(other$waypointMessageBlocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ftbChunks = this.getFtbChunks();
        result = result * 59 + ($ftbChunks == null ? 43 : ((Object)$ftbChunks).hashCode());
        Boolean $waystone = this.getWaystone();
        result = result * 59 + ($waystone == null ? 43 : ((Object)$waystone).hashCode());
        Boolean $waypointMessageEmptyHandOnly = this.getWaypointMessageEmptyHandOnly();
        result = result * 59 + ($waypointMessageEmptyHandOnly == null ? 43 : ((Object)$waypointMessageEmptyHandOnly).hashCode());
        Double $claimedChunkOverlayOpacity = this.getClaimedChunkOverlayOpacity();
        result = result * 59 + ($claimedChunkOverlayOpacity == null ? 43 : ((Object)$claimedChunkOverlayOpacity).hashCode());
        Boolean $disableFTBFunction = this.getDisableFTBFunction();
        result = result * 59 + ($disableFTBFunction == null ? 43 : ((Object)$disableFTBFunction).hashCode());
        Integer $waystoneColor = this.getWaystoneColor();
        result = result * 59 + ($waystoneColor == null ? 43 : ((Object)$waystoneColor).hashCode());
        Integer $defaultConfigVersion = this.getDefaultConfigVersion();
        result = result * 59 + ($defaultConfigVersion == null ? 43 : ((Object)$defaultConfigVersion).hashCode());
        List<String> $waypointMessageBlocks = this.getWaypointMessageBlocks();
        result = result * 59 + ($waypointMessageBlocks == null ? 43 : ((Object)$waypointMessageBlocks).hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfig(ftbChunks=" + this.getFtbChunks() + ", waystone=" + this.getWaystone() + ", waypointMessageBlocks=" + this.getWaypointMessageBlocks() + ", waypointMessageEmptyHandOnly=" + this.getWaypointMessageEmptyHandOnly() + ", claimedChunkOverlayOpacity=" + this.getClaimedChunkOverlayOpacity() + ", disableFTBFunction=" + this.getDisableFTBFunction() + ", waystoneColor=" + this.getWaystoneColor() + ", defaultConfigVersion=" + this.getDefaultConfigVersion() + ")";
    }
}

