/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class BasicRecipeTransferHandlerServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(class_1657 player, List<TransferOperation> transferOperations, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        if (!RecipeTransferUtil.validateSlots(player, transferOperations, craftingSlots, inventorySlots)) {
            return;
        }
        Map<class_1735, ItemStackWithSlotHint> recipeSlotToRequiredItemStack = BasicRecipeTransferHandlerServer.calculateRequiredStacks(transferOperations, player);
        if (recipeSlotToRequiredItemStack == null) {
            return;
        }
        boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
        Map<class_1735, class_1799> recipeSlotToTakenStacks = BasicRecipeTransferHandlerServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (recipeSlotToTakenStacks.isEmpty()) {
            LOGGER.error("Tried to transfer recipe but was unable to remove any items from the inventory.");
            return;
        }
        List<class_1799> clearedCraftingItems = BasicRecipeTransferHandlerServer.clearCraftingGrid(craftingSlots, player);
        List<class_1799> remainderItems = BasicRecipeTransferHandlerServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks, requireCompleteSets);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, clearedCraftingItems);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, remainderItems);
        class_1703 container = player.field_7512;
        container.method_7623();
    }

    private static int getSlotStackLimit(Map<class_1735, class_1799> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        if (!requireCompleteSets) {
            return Integer.MAX_VALUE;
        }
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            class_1799 transferItem;
            class_1735 craftingSlot = (class_1735)e.getKey();
            if (craftingSlot.method_7680(transferItem = (class_1799)e.getValue())) {
                return craftingSlot.method_7676(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static List<class_1799> clearCraftingGrid(List<class_1735> craftingSlots, class_1657 player) {
        ArrayList<class_1799> clearedCraftingItems = new ArrayList<class_1799>();
        for (class_1735 craftingSlot : craftingSlots) {
            if (!craftingSlot.method_7674(player) || !craftingSlot.method_7681()) continue;
            class_1799 craftingItem = craftingSlot.method_7671(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<class_1799> putItemsIntoCraftingGrid(Map<class_1735, class_1799> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        int slotStackLimit = BasicRecipeTransferHandlerServer.getSlotStackLimit(recipeSlotToTakenStacks, requireCompleteSets);
        ArrayList<class_1799> remainderItems = new ArrayList<class_1799>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            if (slot.method_7677().method_7960() && slot.method_7680(stack)) {
                class_1799 remainder = slot.method_32755(stack, slotStackLimit);
                if (!remainder.method_7960()) {
                    remainderItems.add(remainder);
                }
            } else {
                remainderItems.add((class_1799)stack);
            }
        });
        return remainderItems;
    }

    @Nullable
    private static Map<class_1735, ItemStackWithSlotHint> calculateRequiredStacks(List<TransferOperation> transferOperations, class_1657 player) {
        HashMap<class_1735, ItemStackWithSlotHint> recipeSlotToRequired = new HashMap<class_1735, ItemStackWithSlotHint>(transferOperations.size());
        for (TransferOperation transferOperation : transferOperations) {
            class_1735 recipeSlot = transferOperation.craftingSlot();
            class_1735 inventorySlot = transferOperation.inventorySlot();
            if (!inventorySlot.method_7674(player)) {
                LOGGER.error("Tried to transfer recipe but was given an inventory slot that the player can't pickup from: {}", (Object)inventorySlot.field_7874);
                return null;
            }
            class_1799 slotStack = inventorySlot.method_7677();
            if (slotStack.method_7960()) {
                LOGGER.error("Tried to transfer recipe but was given an empty inventory slot as an ingredient source: {}", (Object)inventorySlot.field_7874);
                return null;
            }
            class_1799 stack = slotStack.method_7972();
            stack.method_7939(1);
            recipeSlotToRequired.put(recipeSlot, new ItemStackWithSlotHint(inventorySlot, stack));
        }
        return recipeSlotToRequired;
    }

    @Nonnull
    private static Map<class_1735, class_1799> takeItemsFromInventory(class_1657 player, Map<class_1735, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<class_1735, class_1799> foundItemsInSet;
        if (!maxTransfer) {
            return BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<class_1735, class_1799> recipeSlotToResult = new HashMap<class_1735, class_1799>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<class_1735> fullSlots = BasicRecipeTransferHandlerServer.merge(recipeSlotToResult, foundItemsInSet);
            for (class_1735 fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<class_1735, class_1799> removeOneSetOfItemsFromInventory(class_1657 player, Map<class_1735, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<class_1735, class_1799> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<class_1735, class_1799>();
        }
        HashMap<class_1735, class_1799> foundItemsInSet = new HashMap<class_1735, class_1799>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<class_1735, ItemStackWithSlotHint> entry : recipeSlotToRequiredItemStack.entrySet()) {
            class_1735 recipeSlot = entry.getKey();
            class_1799 requiredStack = entry.getValue().stack;
            class_1735 hint = entry.getValue().hint;
            class_1735 slot = BasicRecipeTransferHandlerServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.method_7677().method_7972());
                }
                class_1799 removedItemStack = slot.method_7671(1);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                class_1799 stack = (class_1799)slotEntry.getValue();
                ((class_1735)slotEntry.getKey()).method_7673(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    private static Set<class_1735> merge(Map<class_1735, class_1799> result, Map<class_1735, class_1799> addition) {
        HashSet<class_1735> fullSlots = new HashSet<class_1735>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.method_7947() == 1);
            class_1799 resultItemStack = (class_1799)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((class_1735)slot, resultItemStack);
            } else {
                assert (class_1799.method_31577((class_1799)resultItemStack, (class_1799)itemStack));
                resultItemStack.method_7933(itemStack.method_7947());
            }
            if (resultItemStack.method_7947() == slot.method_7676(resultItemStack)) {
                fullSlots.add((class_1735)slot);
            }
        });
        return fullSlots;
    }

    private static Optional<class_1735> getSlotWithStack(class_1657 player, class_1799 stack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, class_1735 hint) {
        return BasicRecipeTransferHandlerServer.getSlotWithStack(player, craftingSlots, stack).or(() -> BasicRecipeTransferHandlerServer.getValidatedHintSlot(player, stack, hint)).or(() -> BasicRecipeTransferHandlerServer.getSlotWithStack(player, inventorySlots, stack));
    }

    private static Optional<class_1735> getValidatedHintSlot(class_1657 player, class_1799 stack, class_1735 hint) {
        if (hint.method_7674(player) && !hint.method_7677().method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)hint.method_7677())) {
            return Optional.of(hint);
        }
        return Optional.empty();
    }

    private static void stowItems(class_1657 player, List<class_1735> inventorySlots, List<class_1799> itemStacks) {
        for (class_1799 itemStack : itemStacks) {
            class_1799 remainder = BasicRecipeTransferHandlerServer.stowItem(inventorySlots, itemStack);
            if (remainder.method_7960() || player.method_31548().method_7394(remainder)) continue;
            player.method_7328(remainder, false);
        }
    }

    private static class_1799 stowItem(Collection<class_1735> slots, class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        for (class_1735 slot : slots) {
            class_1799 inventoryStack = slot.method_7677();
            if (inventoryStack.method_7960() || !inventoryStack.method_7946()) continue;
            slot.method_32756(remainder);
            if (!remainder.method_7960()) continue;
            return class_1799.field_8037;
        }
        for (class_1735 slot : slots) {
            if (!slot.method_7677().method_7960()) continue;
            slot.method_32756(remainder);
            if (!remainder.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainder;
    }

    private static Optional<class_1735> getSlotWithStack(class_1657 player, Collection<class_1735> slots, class_1799 itemStack) {
        return slots.stream().filter(slot -> {
            class_1799 slotStack = slot.method_7677();
            return class_1799.method_31577((class_1799)itemStack, (class_1799)slotStack) && slot.method_7674(player);
        }).findFirst();
    }

    private record ItemStackWithSlotHint(class_1735 hint, class_1799 stack) {
    }
}

