/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_villages.world.processors;

import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_villages.IntegratedVilagesProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class WorkstationProcessor
extends class_3491 {
    public static final Codec<WorkstationProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)Codec.STRING.fieldOf("workstation_type").forGetter(config -> config.workstationType), (App)Codec.BOOL.fieldOf("enable_integration").orElse((Object)Boolean.TRUE).forGetter(config -> config.enableIntegration)).apply((Applicative)instance, instance.stable(WorkstationProcessor::new)));
    private final class_2248 inputBlock;
    private final String workstationType;
    private ArrayList<String> outputBlocksString = new ArrayList();
    private boolean enableIntegration;

    public WorkstationProcessor(class_2248 inputBlock, String workstationType, boolean enableIntegration) {
        this.inputBlock = inputBlock;
        this.workstationType = workstationType;
        this.enableIntegration = enableIntegration;
    }

    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        if (structureBlockInfoWorld.comp_1342().method_26204() == this.inputBlock) {
            class_5819 random = class_5819.method_43047();
            if (this.workstationType.equals("generic")) {
                this.outputBlocksString.add("minecraft:composter");
                if (this.enableIntegration) {
                    if (PlatformHooks.isModLoaded((String)"domestic_innovation")) {
                        this.outputBlocksString.add("domestic_innovation:pet_bed_white");
                    }
                    if (PlatformHooks.isModLoaded((String)"simplycats")) {
                        this.outputBlocksString.add("simplycats:shelter_book");
                    }
                    if (PlatformHooks.isModLoaded((String)"morevillagers")) {
                        this.outputBlocksString.add("morevillagers:woodworking_table");
                        this.outputBlocksString.add("morevillagers:gardening_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"sawmill")) {
                        this.outputBlocksString.add("sawmill:sawmill");
                    }
                    if (PlatformHooks.isModLoaded((String)"brewery")) {
                        this.outputBlocksString.add("brewery:bar_counter");
                    }
                    if (PlatformHooks.isModLoaded((String)"cloudstorage")) {
                        this.outputBlocksString.add("cloudstorage:balloon_stand");
                    }
                    if (PlatformHooks.isModLoaded((String)"betterarcheology")) {
                        this.outputBlocksString.add("betterarcheology:archeology_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"new_villagers")) {
                        this.outputBlocksString.add("new_villagers:archeology_table");
                        this.outputBlocksString.add("new_villagers:lumberjack_woodwork_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"recruits")) {
                        this.outputBlocksString.add("recruits:recruit_block");
                        this.outputBlocksString.add("recruits:recruit_shield_block");
                    }
                    if (PlatformHooks.isModLoaded((String)"wares")) {
                        this.outputBlocksString.add("wares:delivery_table");
                    }
                    if (this.outputBlocksString.size() >= 2) {
                        this.outputBlocksString.remove("minecraft:composter");
                    }
                }
            } else if (this.workstationType.equals("shepard")) {
                this.outputBlocksString.add("minecraft:loom");
            } else if (this.workstationType.equals("butcher")) {
                this.outputBlocksString.add("minecraft:smoker");
            } else if (this.workstationType.equals("mason")) {
                this.outputBlocksString.add("minecraft:stonecutter");
            } else if (this.workstationType.equals("cleric")) {
                this.outputBlocksString.add("minecraft:brewing_stand");
                if (this.enableIntegration) {
                    if (PlatformHooks.isModLoaded((String)"morevillagers")) {
                        this.outputBlocksString.add("morevillagers:blueprint_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"villagersplus")) {
                        this.outputBlocksString.add("villagersplus:occultist_table");
                        this.outputBlocksString.add("villagersplus:alchemist_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"mna")) {
                        this.outputBlocksString.add("mna:runescribing_table");
                        this.outputBlocksString.add("mna:manaweaving_altar");
                        this.outputBlocksString.add("mna:runeforge");
                    }
                }
            } else if (this.workstationType.equals("cartographer")) {
                this.outputBlocksString.add("minecraft:cartography_table");
                if (this.enableIntegration && PlatformHooks.isModLoaded((String)"morevillagers")) {
                    this.outputBlocksString.add("morevillagers:hunting_post");
                    this.outputBlocksString.add("morevillagers:oceanography_table");
                }
            } else if (this.workstationType.equals("blacksmith")) {
                this.outputBlocksString.add("minecraft:smithing_table");
                this.outputBlocksString.add("minecraft:grindstone");
                this.outputBlocksString.add("minecraft:blast_furnace");
                if (this.enableIntegration) {
                    if (PlatformHooks.isModLoaded((String)"morevillagers")) {
                        this.outputBlocksString.add("morevillagers:mining_bench");
                        this.outputBlocksString.add("morevillagers:blueprint_table");
                    }
                    if (PlatformHooks.isModLoaded((String)"new_villagers")) {
                        this.outputBlocksString.add("new_villagers:graze_bench");
                    }
                    if (PlatformHooks.isModLoaded((String)"immersiveengineering")) {
                        this.outputBlocksString.add("immersiveengineering:craftingtable");
                    }
                }
            } else if (this.workstationType.equals("librarian")) {
                this.outputBlocksString.add("minecraft:lectern");
                if (this.enableIntegration && PlatformHooks.isModLoaded((String)"iceandfire")) {
                    this.outputBlocksString.add("iceandfire:lectern");
                }
            } else if (this.workstationType.equals("fletcher")) {
                this.outputBlocksString.add("minecraft:fletching_table");
                if (PlatformHooks.isModLoaded((String)"recruits")) {
                    this.outputBlocksString.add("recruits:bowman_block");
                }
            } else if (this.workstationType.equals("leatherworker")) {
                this.outputBlocksString.add("minecraft:cauldron");
            } else if (this.workstationType.equals("beekeeper")) {
                this.outputBlocksString.add("minecraft:beehive");
                if (this.enableIntegration && PlatformHooks.isModLoaded((String)"new_villagers")) {
                    this.outputBlocksString.add("new_villagers:bee_station");
                }
            } else {
                try {
                    throw new Exception("Integrated Villages Error: Found invalid workstation type: " + this.workstationType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String newBlockString = this.outputBlocksString.get(random.method_43048(this.outputBlocksString.size()));
            class_2680 newBlockState = ((class_2248)class_7923.field_41175.method_10223(new class_2960(newBlockString))).method_9564();
            return new class_3499.class_3501(structureBlockInfoWorld.comp_1341(), newBlockState, structureBlockInfoWorld.comp_1343());
        }
        return structureBlockInfoWorld;
    }

    protected class_3828<?> method_16772() {
        return (class_3828)IntegratedVilagesProcessors.WORKSTATION_PROCESSOR.get();
    }
}

