/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_villages.lootmanager;

import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_villages.IntegratedVillages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.server.MinecraftServer;

public class StructureModdedLootImporter {
    public static final Map<class_2960, class_2960> TABLE_IMPORTS = StructureModdedLootImporter.createMap();

    public static Map<class_2960, class_2960> createMap() {
        HashMap<class_2960, class_2960> tableMap = new HashMap<class_2960, class_2960>();
        tableMap.put(new class_2960("integrated_villages", "chests/tavern_village/tavern_village"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("integrated_villages", "chests/tavern_village/tavern_village_blacksmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        if (PlatformHooks.isModLoaded((String)"betterstrongholds")) {
            tableMap.put(new class_2960("betterstrongholds", "chests/end/armoury"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/common"), new class_2960("minecraft:chests/end_city_treasure"));
        }
        return tableMap;
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<class_2960, class_2960> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().method_12836().equals("betterstrongholds") || !StructureModdedLootImporter.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            IntegratedVillages.LOGGER.error("Unknown import/target loot tables found for Integrated Villages. See above logs and report to CraisinLord.");
        }
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<class_2960, class_2960> entry) {
        boolean invalidLootTableFound = false;
        if (minecraftServer.method_3857().getLootTable(entry.getKey()) == class_52.field_948) {
            IntegratedVillages.LOGGER.error("Unable to find loot table key: {}", (Object)entry.getKey());
            invalidLootTableFound = true;
        }
        if (minecraftServer.method_3857().getLootTable(entry.getValue()) == class_52.field_948) {
            IntegratedVillages.LOGGER.error("Unable to find loot table value: {}", (Object)entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }
}

