/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures.pieces.assembler;

import com.craisinlord.integrated_api.utils.BoxOctree;
import com.craisinlord.integrated_api.world.structures.pieces.IASinglePoolElement;
import com.craisinlord.integrated_api.world.structures.pieces.assembler.PieceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceEntry {
    private class_3790 piece;
    private final MutableObject<BoxOctree> boxOctree;
    private final class_238 pieceAabb;
    private final int depth;
    private final List<PieceEntry> childEntries = new ArrayList<PieceEntry>();
    private final PieceEntry parentEntry;
    private final PieceContext sourcePieceContext;
    private final class_3780 parentJunction;
    private boolean delayGeneration = false;

    public PieceEntry(class_3790 piece, MutableObject<BoxOctree> boxOctree, class_238 pieceAabb, int depth, PieceEntry parentEntry, PieceContext sourcePieceContext, class_3780 parentJunction) {
        this.piece = piece;
        this.boxOctree = boxOctree;
        this.pieceAabb = pieceAabb;
        this.depth = depth;
        this.parentEntry = parentEntry;
        this.sourcePieceContext = sourcePieceContext;
        this.parentJunction = parentJunction;
    }

    public void addChildEntry(PieceEntry childEntry) {
        this.childEntries.add(childEntry);
    }

    public boolean hasChildren() {
        return this.childEntries.size() > 0;
    }

    public class_3790 getPiece() {
        return this.piece;
    }

    public void setPiece(class_3790 newPiece) {
        this.piece = newPiece;
    }

    public MutableObject<BoxOctree> getBoxOctree() {
        return this.boxOctree;
    }

    public int getDepth() {
        return this.depth;
    }

    public PieceEntry getParentEntry() {
        return this.parentEntry;
    }

    public PieceContext getSourcePieceContext() {
        return this.sourcePieceContext;
    }

    public class_238 getPieceAabb() {
        return this.pieceAabb;
    }

    public class_3780 getParentJunction() {
        return this.parentJunction;
    }

    public Optional<class_2960> getDeadendPool() {
        class_3784 class_37842 = this.piece.method_16644();
        if (class_37842 instanceof IASinglePoolElement) {
            IASinglePoolElement iaSingleElement = (IASinglePoolElement)class_37842;
            return iaSingleElement.getDeadendPool();
        }
        return Optional.empty();
    }

    public void setDelayGeneration(boolean delayGeneration) {
        this.delayGeneration = delayGeneration;
    }

    public boolean isDelayGeneration() {
        return this.delayGeneration;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PieceEntry that = (PieceEntry)obj;
        return Objects.equals(this.piece, that.piece) && Objects.equals(this.boxOctree, that.boxOctree) && this.depth == that.depth;
    }

    public int hashCode() {
        return Objects.hash(this.piece, this.boxOctree, this.depth);
    }

    public String toString() {
        return "PieceEntry[piece=" + this.piece + ", boxOctree=" + this.boxOctree + ", depth=" + this.depth + "]";
    }
}

