/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures.pieces;

import com.craisinlord.integrated_api.world.condition.StructureCondition;
import com.craisinlord.integrated_api.world.condition.StructureConditionType;
import com.craisinlord.integrated_api.world.structures.context.StructureContext;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class IAPoolElement
extends class_3784 {
    public final Optional<String> name;
    public final Optional<Integer> maxCount;
    @Deprecated
    public final Optional<Integer> minRequiredDepth;
    @Deprecated
    public final Optional<Integer> maxPossibleDepth;
    public final boolean isPriority;
    public final boolean ignoreBounds;
    public final StructureCondition condition;
    public final Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation;

    public IAPoolElement(class_3785.class_3786 projection, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, StructureCondition condition, Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation) {
        super(projection);
        this.name = name;
        this.maxCount = maxCount;
        this.minRequiredDepth = minRequiredDepth;
        this.maxPossibleDepth = maxPossibleDepth;
        this.isPriority = isPriority;
        this.ignoreBounds = ignoreBounds;
        this.condition = condition;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Integer> getMaxCount() {
        return this.maxCount;
    }

    @Deprecated
    public Optional<Integer> getMinRequiredDepth() {
        return this.minRequiredDepth;
    }

    @Deprecated
    public Optional<Integer> getMaxPossibleDepth() {
        return this.maxPossibleDepth;
    }

    public boolean isPriorityPiece() {
        return this.isPriority;
    }

    public boolean ignoresBounds() {
        return this.ignoreBounds;
    }

    public StructureCondition getCondition() {
        return this.condition;
    }

    public Optional<EnhancedTerrainAdaptation> getEnhancedTerrainAdaptation() {
        return this.enhancedTerrainAdaptation;
    }

    public boolean isAtValidDepth(int depth) {
        boolean isAtMinRequiredDepth = this.minRequiredDepth.isEmpty() || this.minRequiredDepth.get() <= depth;
        boolean isAtMaxAllowableDepth = this.maxPossibleDepth.isEmpty() || this.maxPossibleDepth.get() >= depth;
        return isAtMinRequiredDepth && isAtMaxAllowableDepth;
    }

    public boolean passesConditions(StructureContext ctx) {
        return this.condition.passes(ctx);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Optional<String>> nameCodec() {
        return Codec.STRING.optionalFieldOf("name").forGetter(IAPoolElement::getName);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Optional<Integer>> maxCountCodec() {
        return class_5699.field_33441.optionalFieldOf("max_count").forGetter(IAPoolElement::getMaxCount);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Optional<Integer>> minRequiredDepthCodec() {
        return class_5699.field_33441.optionalFieldOf("min_required_depth").forGetter(IAPoolElement::getMinRequiredDepth);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Optional<Integer>> maxPossibleDepthCodec() {
        return class_5699.field_33441.optionalFieldOf("max_possible_depth").forGetter(IAPoolElement::getMaxPossibleDepth);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Boolean> isPriorityCodec() {
        return Codec.BOOL.optionalFieldOf("is_priority", (Object)false).forGetter(IAPoolElement::isPriorityPiece);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Boolean> ignoreBoundsCodec() {
        return Codec.BOOL.optionalFieldOf("ignore_bounds", (Object)false).forGetter(IAPoolElement::ignoresBounds);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, StructureCondition> conditionCodec() {
        return StructureConditionType.CONDITION_CODEC.optionalFieldOf("condition", (Object)StructureCondition.ALWAYS_TRUE).forGetter(IAPoolElement::getCondition);
    }

    public static <E extends IAPoolElement> RecordCodecBuilder<E, Optional<EnhancedTerrainAdaptation>> enhancedTerrainAdaptationCodec() {
        return EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation").forGetter(IAPoolElement::getEnhancedTerrainAdaptation);
    }

    public class_2382 method_16601(class_3485 structureTemplateManager, class_2470 rotation) {
        return null;
    }

    public List<class_3499.class_3501> method_16627(class_3485 structureTemplateManager, class_2338 blockPos, class_2470 rotation, class_5819 randomSource) {
        return null;
    }

    public class_3341 method_16628(class_3485 structureTemplateManager, class_2338 blockPos, class_2470 rotation) {
        return null;
    }

    public boolean method_16626(class_3485 structureTemplateManager, class_5281 worldGenLevel, class_5138 structureManager, class_2794 chunkGenerator, class_2338 blockPos, class_2338 blockPos2, class_2470 rotation, class_3341 boundingBox, class_5819 randomSource, boolean bl) {
        return false;
    }

    public class_3816<?> method_16757() {
        return null;
    }
}

