/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5742;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class OptionalDependencyStructure
extends JigsawStructure {
    public static final Codec<OptionalDependencyStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OptionalDependencyStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)512).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.STRING.optionalFieldOf("required_mods").forGetter(structure -> structure.requiredMod), (App)Codec.STRING.optionalFieldOf("illegal_mods").forGetter(structure -> structure.illegalMod), (App)Codec.BOOL.fieldOf("rotation_fixed").orElse((Object)false).forGetter(structure -> structure.rotationFixed), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)instance, OptionalDependencyStructure::new));
    public final Optional<String> requiredMod;
    public final Optional<String> illegalMod;

    public OptionalDependencyStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, Optional<String> requiredMod, Optional<String> illegalMod, boolean rotationFixed, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        super(config, startPool, size, minYAllowed, maxYAllowed, Optional.empty(), startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), rotationFixed, enhancedTerrainAdaptation);
        this.requiredMod = requiredMod;
        this.illegalMod = illegalMod;
    }

    private ArrayList<String> convertModList(String modlist) {
        int startChar = 0;
        ArrayList<String> convertedModList = new ArrayList<String>();
        for (int i = 0; i < modlist.length(); ++i) {
            if (modlist.charAt(i) != ',') continue;
            convertedModList.add(modlist.substring(startChar, i));
            startChar = i + 1;
        }
        convertedModList.add(modlist.substring(startChar));
        return convertedModList;
    }

    @Override
    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        class_1923 chunkPos = context.comp_568();
        if (!this.requiredMod.isEmpty()) {
            ArrayList<String> requiredMods = this.convertModList(this.requiredMod.get());
            for (String mod : requiredMods) {
                if (this.isLoaded(mod)) continue;
                IntegratedAPI.LOGGER.debug("Attempted to spawn Integrated API structure but not all required mods " + requiredMods + " are present.");
                return false;
            }
        }
        if (!this.illegalMod.isEmpty()) {
            ArrayList<String> illegalMods = this.convertModList(this.illegalMod.get());
            for (String mod : illegalMods) {
                if (!this.isLoaded(mod)) continue;
                IntegratedAPI.LOGGER.debug("Attempted to spawn Integrated API structure but illegal mods " + illegalMods + " are present.");
                return false;
            }
        }
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = (Integer)this.biomeRadius.get();
            int sectionY = blockPos.method_10264();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.comp_562().method_18028(blockPos.method_10263(), blockPos.method_10260(), (class_2902.class_2903)this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
            }
            sectionY = class_5742.method_33100((int)sectionY);
            for (int curChunkX = chunkPos.field_9181 - validBiomeRange; curChunkX <= chunkPos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - validBiomeRange; curChunkZ <= chunkPos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), sectionY, class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        if (this.cannotSpawnInLiquid) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = context.comp_562().method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
            class_4966 columnOfBlocks = context.comp_562().method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_569(), context.comp_564());
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10264() + landHeight);
            if (!topBlock.method_26227().method_15769()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = (Integer)this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.field_9181 - terrainCheckRange; curChunkX <= chunkPos.field_9181 + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - terrainCheckRange; curChunkZ <= chunkPos.field_9180 + terrainCheckRange; ++curChunkZ) {
                    int height = context.comp_562().method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194), context.comp_569(), context.comp_564());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < (Integer)this.minYAllowed.get()) {
                        return false;
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= (Integer)this.maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > (Integer)this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    public boolean isLoaded(String name) {
        return PlatformHooks.isModLoaded(name);
    }

    @Override
    public class_7151<?> method_41618() {
        return IAStructures.OPTIONAL_DEPENDENCY_STRUCTURE.get();
    }
}

