/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.structures.pieces.manager.PieceLimitedJigsawManager;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class ModAdaptiveStructure
extends JigsawStructure {
    public static final Codec<ModAdaptiveStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModAdaptiveStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)512).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.fieldOf("rotation_fixed").orElse((Object)false).forGetter(structure -> structure.rotationFixed), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)Codec.STRING.fieldOf("change_pool_mods").forGetter(structure -> structure.changePoolMod), (App)class_3785.field_24954.fieldOf("new_pool").forGetter(structure -> structure.newPool)).apply((Applicative)instance, ModAdaptiveStructure::new));
    public final String changePoolMod;
    public final class_6880<class_3785> newPool;

    public ModAdaptiveStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, boolean rotationFixed, EnhancedTerrainAdaptation enhancedTerrainAdaptation, String changePoolMod, class_6880<class_3785> newPool) {
        super(config, startPool, size, minYAllowed, maxYAllowed, Optional.empty(), startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), rotationFixed, enhancedTerrainAdaptation);
        this.changePoolMod = changePoolMod;
        this.newPool = newPool;
    }

    private ArrayList<String> convertModList(String modlist) {
        int startChar = 0;
        ArrayList<String> convertedModList = new ArrayList<String>();
        for (int i = 0; i < modlist.length(); ++i) {
            if (modlist.charAt(i) != ',') continue;
            convertedModList.add(modlist.substring(startChar, i));
            startChar = i + 1;
        }
        convertedModList.add(modlist.substring(startChar));
        return convertedModList;
    }

    public boolean allModsPresent(ArrayList<String> convertedModList) {
        for (String mod : convertedModList) {
            if (ModAdaptiveStructure.isLoaded(mod)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        ArrayList<String> changePoolMods;
        int offsetY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockpos = new class_2338(context.comp_568().method_8326(), offsetY, context.comp_568().method_8328());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        class_6880<class_3785> finalPool = this.startPool;
        if (!this.changePoolMod.isEmpty() && this.allModsPresent(changePoolMods = this.convertModList(this.changePoolMod))) {
            finalPool = this.newPool;
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.allowedYRangeFromStart.isPresent()) {
            topClipOff = blockpos.method_10264() + (Integer)this.allowedYRangeFromStart.get();
            bottomClipOff = blockpos.method_10264() - (Integer)this.allowedYRangeFromStart.get();
        }
        if (this.maxYAllowed.isPresent()) {
            topClipOff = Math.min(topClipOff, (Integer)this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent()) {
            bottomClipOff = Math.max(bottomClipOff, (Integer)this.minYAllowed.get());
        }
        String rotationString = this.rotationFixed ? "NONE" : "RANDOM";
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, finalPool, this.size, context.comp_561().method_30530(class_7924.field_41246).method_10221((Object)this), blockpos, false, this.projectStartToHeightmap, topClipOff, bottomClipOff, null, this.maxDistanceFromCenter, rotationString, this.buryingType, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((class_6626)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<class_3790>)pieces));
    }

    public static boolean isLoaded(String name) {
        return PlatformHooks.isModLoaded(name);
    }

    @Override
    public class_7151<?> method_41618() {
        return IAStructures.MOD_ADAPTIVE_STRUCTURE.get();
    }
}

