/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.structures.pieces.manager.PieceLimitedJigsawManager;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4966;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class BiomeFacingStructure
extends JigsawStructure {
    public static final Codec<BiomeFacingStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeFacingStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)512).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)Codec.intRange((int)1, (int)100).fieldOf("target_biome_radius_check_blocks").orElse((Object)24).forGetter(structure -> structure.targetBiomeRadius), (App)class_6895.method_40340((class_5321)class_7924.field_41236).fieldOf("target_biomes").forGetter(structure -> structure.targetBiomes)).apply((Applicative)instance, BiomeFacingStructure::new));
    private final int targetBiomeRadius;
    private final class_6885<class_1959> targetBiomes;

    public BiomeFacingStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, EnhancedTerrainAdaptation enhancedTerrainAdaptation, int targetBiomeRadius, class_6885<class_1959> targetBiomes) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), false, enhancedTerrainAdaptation);
        this.targetBiomeRadius = targetBiomeRadius;
        this.targetBiomes = targetBiomes;
    }

    private String rotationToBiome(class_2338 blockpos, class_3195.class_7149 context) {
        int validBiomeRange = this.targetBiomeRadius;
        int sectionY = blockpos.method_10264();
        if (this.projectStartToHeightmap.isPresent()) {
            sectionY += context.comp_562().method_18028(blockpos.method_10263(), blockpos.method_10260(), (class_2902.class_2903)this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
        }
        sectionY = class_5742.method_33100((int)sectionY);
        int posZ = blockpos.method_10260();
        int posX = blockpos.method_10263();
        int sectionBiomeRange = (int)Math.ceil(validBiomeRange / 4) + 2;
        Set section2Biomes = context.comp_563().method_8763(posX - sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section2Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "NONE";
        }
        Set section3Biomes = context.comp_563().method_8763(posX + sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section3Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "NONE";
        }
        Set section12Biomes = context.comp_563().method_8763(posX + 2 * sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section12Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section8Biomes = context.comp_563().method_8763(posX + 2 * sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section8Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section14Biomes = context.comp_563().method_8763(posX - sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section14Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section15Biomes = context.comp_563().method_8763(posX + sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section15Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section5Biomes = context.comp_563().method_8763(posX - 2 * sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section5Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section9Biomes = context.comp_563().method_8763(posX - 2 * sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section9Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section6Biomes = context.comp_563().method_8763(posX - sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section6Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section7Biomes = context.comp_563().method_8763(posX + sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section7Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section11Biomes = context.comp_563().method_8763(posX + sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section11Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section10Biomes = context.comp_563().method_8763(posX - sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section10Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section1Biomes = context.comp_563().method_8763(posX - 2 * sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section1Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "NONE";
        }
        Set section4Biomes = context.comp_563().method_8763(posX + 2 * sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (Object biome : section4Biomes) {
            if (!this.targetBiomes.method_40241((class_6880)biome)) continue;
            return "NONE";
        }
        Set section16Biomes = context.comp_563().method_8763(posX + 2 * sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (class_6880 biome : section16Biomes) {
            if (!this.targetBiomes.method_40241(biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section13Biomes = context.comp_563().method_8763(posX - 2 * sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.comp_564().method_42371());
        for (class_6880 biome : section13Biomes) {
            if (!this.targetBiomes.method_40241(biome)) continue;
            return "CLOCKWISE_180";
        }
        IntegratedAPI.LOGGER.info("EVIL DETECTED YOU WILL BE EXTERMINATED");
        return "NONE";
    }

    private boolean checkBiome(class_2338 blockpos, class_3195.class_7149 context) {
        int validBiomeRange = this.targetBiomeRadius - 4;
        int sectionY = blockpos.method_10264();
        if (this.projectStartToHeightmap.isPresent()) {
            sectionY += context.comp_562().method_18028(blockpos.method_10263(), blockpos.method_10260(), (class_2902.class_2903)this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
        }
        sectionY = class_5742.method_33100((int)sectionY);
        int posZ = blockpos.method_10260();
        int posX = blockpos.method_10263();
        for (class_6880 biome : context.comp_563().method_8763(posX, sectionY, posZ, validBiomeRange, context.comp_564().method_42371())) {
            if (!this.targetBiomes.method_40241(biome)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        class_1923 chunkPos = context.comp_568();
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = (Integer)this.biomeRadius.get();
            int sectionY = blockPos.method_10264();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.comp_562().method_18028(blockPos.method_10263(), blockPos.method_10260(), (class_2902.class_2903)this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
            }
            sectionY = class_5742.method_33100((int)sectionY);
            for (int curChunkX = chunkPos.field_9181 - validBiomeRange; curChunkX <= chunkPos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - validBiomeRange; curChunkZ <= chunkPos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), sectionY, class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        if (!this.checkBiome(blockPos, context)) {
            return false;
        }
        if (this.cannotSpawnInLiquid) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = context.comp_562().method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
            class_4966 columnOfBlocks = context.comp_562().method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_569(), context.comp_564());
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10264() + landHeight);
            if (!topBlock.method_26227().method_15769()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = (Integer)this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.field_9181 - terrainCheckRange; curChunkX <= chunkPos.field_9181 + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - terrainCheckRange; curChunkZ <= chunkPos.field_9180 + terrainCheckRange; ++curChunkZ) {
                    int height = context.comp_562().method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194), context.comp_569(), context.comp_564());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < (Integer)this.minYAllowed.get()) {
                        return false;
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= (Integer)this.maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > (Integer)this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        String rotationString;
        int offsetY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockpos = new class_2338(context.comp_568().method_8326(), offsetY, context.comp_568().method_8328());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.allowedYRangeFromStart.isPresent()) {
            topClipOff = blockpos.method_10264() + (Integer)this.allowedYRangeFromStart.get();
            bottomClipOff = blockpos.method_10264() - (Integer)this.allowedYRangeFromStart.get();
        }
        if (this.maxYAllowed.isPresent()) {
            topClipOff = Math.min(topClipOff, (Integer)this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent()) {
            bottomClipOff = Math.max(bottomClipOff, (Integer)this.minYAllowed.get());
        }
        if ((rotationString = this.rotationToBiome(blockpos, context)) == null) {
            throw new RuntimeException(new Exception("Integrated API Found Null Rotation for Biome Facing Structure. REPORT THIS TO CRAISIN!"));
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, (class_6880<class_3785>)this.startPool, this.size, context.comp_561().method_30530(class_7924.field_41246).method_10221((Object)this), blockpos, false, this.projectStartToHeightmap, topClipOff, bottomClipOff, null, this.maxDistanceFromCenter, rotationString, this.buryingType, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((class_6626)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<class_3790>)pieces));
    }

    @Override
    public class_7151<?> method_41618() {
        return IAStructures.BIOME_FACING_STRUCTURE.get();
    }
}

