/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.processors;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAProcessors;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class IntegratedBlockReplaceProcessor
extends class_3491 {
    public static final Codec<IntegratedBlockReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)Codec.STRING.fieldOf("required_mod").forGetter(config -> config.requiredMod), (App)class_7923.field_41175.method_39673().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)class_7923.field_41175.method_39673().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability)), (App)class_7923.field_41175.method_39673().optionalFieldOf("otherwise_block").forGetter(config -> config.otherwiseBlock)).apply((Applicative)instance, instance.stable(IntegratedBlockReplaceProcessor::new)));
    private final class_2248 inputBlock;
    private final String requiredMod;
    private final Optional<class_2248> outputBlock;
    private final List<class_2248> outputBlocks;
    private final float probability;
    private final Optional<class_2248> otherwiseBlock;

    private IntegratedBlockReplaceProcessor(class_2248 inputBlock, String requiredMod, Optional<class_2248> outputBlock, List<class_2248> outputBlocks, float probability, Optional<class_2248> otherwiseBlock) {
        this.inputBlock = inputBlock;
        this.requiredMod = requiredMod;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
        this.otherwiseBlock = otherwiseBlock;
    }

    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        if (structureBlockInfoWorld.comp_1342().method_26204() == this.inputBlock) {
            if (PlatformHooks.isModLoaded(this.requiredMod)) {
                class_5819 random = class_5819.method_43047();
                if (random.method_43057() < this.probability) {
                    if (this.outputBlock.isPresent()) {
                        class_2680 newBlockState = this.outputBlock.get().method_9564();
                        return new class_3499.class_3501(structureBlockInfoWorld.comp_1341(), newBlockState, structureBlockInfoWorld.comp_1343());
                    }
                    if (!this.outputBlocks.isEmpty()) {
                        class_2680 newBlockState = this.outputBlocks.get(random.method_43048(this.outputBlocks.size())).method_9564();
                        return new class_3499.class_3501(structureBlockInfoWorld.comp_1341(), newBlockState, structureBlockInfoWorld.comp_1343());
                    }
                    IntegratedAPI.LOGGER.warn("Integrated API: integrated_api:integrated_block_replace_processor in a processor file has no replacement block of any kind.");
                }
            } else if (this.otherwiseBlock.isPresent()) {
                class_2680 newBlockState = this.otherwiseBlock.get().method_9564();
                return new class_3499.class_3501(structureBlockInfoWorld.comp_1341(), newBlockState, structureBlockInfoWorld.comp_1343());
            }
        }
        return structureBlockInfoWorld;
    }

    protected class_3828<?> method_16772() {
        return IAProcessors.INTEGRATED_BLOCK_REPLACE_PROCESSOR.get();
    }
}

