/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.predicates;

import com.craisinlord.integrated_api.modinit.IAPredicates;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_3825;
import net.minecraft.class_3827;
import net.minecraft.class_5819;

public class MatterPhaseRuleTest
extends class_3825 {
    public static final Codec<MatterPhaseRuleTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3542.method_28140(MATTER_PHASE::values).fieldOf("phase_to_test_for").stable().forGetter(ruletest -> ruletest.phaseToTestFor), (App)Codec.BOOL.fieldOf("invert_condition").orElse((Object)false).forGetter(ruletest -> ruletest.invertCondition)).apply((Applicative)instance, instance.stable(MatterPhaseRuleTest::new)));
    private final MATTER_PHASE phaseToTestFor;
    private final boolean invertCondition;

    private MatterPhaseRuleTest(MATTER_PHASE phaseToTestFor, boolean invertCondition) {
        this.phaseToTestFor = phaseToTestFor;
        this.invertCondition = invertCondition;
    }

    public boolean method_16768(class_2680 state, class_5819 random) {
        boolean phaseMatch = false;
        switch (this.phaseToTestFor) {
            case AIR: {
                if (!state.method_26215()) break;
                phaseMatch = true;
                break;
            }
            case LIQUID: {
                if (state.method_26227().method_15769()) break;
                phaseMatch = true;
                break;
            }
            case SOLID: {
                if (state.method_26215() || !state.method_26227().method_15769() || !state.method_26225()) break;
                phaseMatch = true;
                break;
            }
            case AIR_RAIL_OR_CHAIN: {
                if (!state.method_26215() && !state.method_27852(class_2246.field_23985) && !state.method_27852(class_2246.field_10167)) break;
                phaseMatch = true;
                break;
            }
            case LIQUID_RAIL_OR_CHAIN: {
                if (state.method_26227().method_15769() && !state.method_27852(class_2246.field_23985) && !state.method_27852(class_2246.field_10167)) break;
                phaseMatch = true;
            }
        }
        if (this.invertCondition) {
            phaseMatch = !phaseMatch;
        }
        return phaseMatch;
    }

    protected class_3827<?> method_16766() {
        return IAPredicates.MATTER_PHASE_RULE_TEST.get();
    }

    public static enum MATTER_PHASE implements class_3542
    {
        SOLID("SOLID"),
        LIQUID("LIQUID"),
        AIR("AIR"),
        AIR_RAIL_OR_CHAIN("AIR_RAIL_OR_CHAIN"),
        LIQUID_RAIL_OR_CHAIN("LIQUID_RAIL_OR_CHAIN");

        private final String name;
        private static final Map<String, MATTER_PHASE> BY_NAME;

        private MATTER_PHASE(String name) {
            this.name = name;
        }

        public static MATTER_PHASE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String method_15434() {
            return this.name;
        }

        static {
            BY_NAME = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
                MATTER_PHASE[] var1;
                for (MATTER_PHASE type : var1 = MATTER_PHASE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

