/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.condition;

import com.craisinlord.integrated_api.world.condition.AllOfCondition;
import com.craisinlord.integrated_api.world.condition.AltitudeCondition;
import com.craisinlord.integrated_api.world.condition.AlwaysTrueCondition;
import com.craisinlord.integrated_api.world.condition.AnyOfCondition;
import com.craisinlord.integrated_api.world.condition.DepthCondition;
import com.craisinlord.integrated_api.world.condition.ModLoadedCondition;
import com.craisinlord.integrated_api.world.condition.NotCondition;
import com.craisinlord.integrated_api.world.condition.PieceInHorizontalDirectionCondition;
import com.craisinlord.integrated_api.world.condition.PieceInRangeCondition;
import com.craisinlord.integrated_api.world.condition.RandomChanceCondition;
import com.craisinlord.integrated_api.world.condition.RotationCondition;
import com.craisinlord.integrated_api.world.condition.StructureCondition;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public interface StructureConditionType<C extends StructureCondition> {
    public static final Map<class_2960, StructureConditionType<?>> CONDITION_TYPES_BY_NAME = new HashMap();
    public static final Map<StructureConditionType<?>, class_2960> NAME_BY_CONDITION_TYPES = new HashMap();
    public static final Codec<StructureConditionType<?>> CONDITION_TYPE_CODEC = class_2960.field_25139.flatXmap(resourceLocation -> Optional.ofNullable(CONDITION_TYPES_BY_NAME.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown condition type: " + resourceLocation)), conditionType -> Optional.of(NAME_BY_CONDITION_TYPES.get(conditionType)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No ID found for condition type " + conditionType + ". Is it registered?")));
    public static final Codec<StructureCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch("type", StructureCondition::type, StructureConditionType::codec);
    public static final StructureConditionType<AlwaysTrueCondition> ALWAYS_TRUE = StructureConditionType.register("always_true", AlwaysTrueCondition.CODEC);
    public static final StructureConditionType<AnyOfCondition> ANY_OF = StructureConditionType.register("any_of", AnyOfCondition.CODEC);
    public static final StructureConditionType<AllOfCondition> ALL_OF = StructureConditionType.register("all_of", AllOfCondition.CODEC);
    public static final StructureConditionType<NotCondition> NOT = StructureConditionType.register("not", NotCondition.CODEC);
    public static final StructureConditionType<AltitudeCondition> ALTITUDE = StructureConditionType.register("altitude", AltitudeCondition.CODEC);
    public static final StructureConditionType<DepthCondition> DEPTH = StructureConditionType.register("depth", DepthCondition.CODEC);
    public static final StructureConditionType<RandomChanceCondition> RANDOM_CHANCE = StructureConditionType.register("random_chance", RandomChanceCondition.CODEC);
    public static final StructureConditionType<PieceInRangeCondition> PIECE_IN_RANGE = StructureConditionType.register("piece_in_range", PieceInRangeCondition.CODEC);
    public static final StructureConditionType<ModLoadedCondition> MOD_LOADED = StructureConditionType.register("mod_loaded", ModLoadedCondition.CODEC);
    public static final StructureConditionType<PieceInHorizontalDirectionCondition> PIECE_IN_HORIZONTAL_DIRECTION = StructureConditionType.register("piece_in_horizontal_direction", PieceInHorizontalDirectionCondition.CODEC);
    public static final StructureConditionType<RotationCondition> ROTATION = StructureConditionType.register("rotation", RotationCondition.CODEC);

    public static <C extends StructureCondition> StructureConditionType<C> register(class_2960 resourceLocation, Codec<C> codec) {
        StructureConditionType<C> conditionType = () -> codec;
        CONDITION_TYPES_BY_NAME.put(resourceLocation, conditionType);
        NAME_BY_CONDITION_TYPES.put(conditionType, resourceLocation);
        return conditionType;
    }

    private static <C extends StructureCondition> StructureConditionType<C> register(String id, Codec<C> codec) {
        return StructureConditionType.register(new class_2960("integrated_api", id), codec);
    }

    public Codec<C> codec();
}

