/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.condition;

import com.craisinlord.integrated_api.world.condition.StructureCondition;
import com.craisinlord.integrated_api.world.condition.StructureConditionType;
import com.craisinlord.integrated_api.world.structures.context.StructureContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_5699;

public class DepthCondition
extends StructureCondition {
    public static final Codec<DepthCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_5699.field_33441.optionalFieldOf("min_required_depth").forGetter(condition -> condition.minRequiredDepth), (App)class_5699.field_33441.optionalFieldOf("max_possible_depth").forGetter(condition -> condition.maxPossibleDepth)).apply((Applicative)builder, DepthCondition::new));
    public final Optional<Integer> minRequiredDepth;
    public final Optional<Integer> maxPossibleDepth;

    public DepthCondition(Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth) {
        this.minRequiredDepth = minRequiredDepth;
        this.maxPossibleDepth = maxPossibleDepth;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.DEPTH;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        int depth = ctx.depth();
        boolean isAtMinRequiredDepth = this.minRequiredDepth.isEmpty() || this.minRequiredDepth.get() <= depth;
        boolean isAtMaxAllowableDepth = this.maxPossibleDepth.isEmpty() || this.maxPossibleDepth.get() >= depth;
        return isAtMinRequiredDepth && isAtMaxAllowableDepth;
    }
}

